/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel;

import gov.llnl.babel.symbols.RegexMatch;
import gov.llnl.babel.symbols.SymbolID;
import java.util.LinkedList;
import java.util.List;

public class BabelConfiguration {
    private static final String BASE_CLASS = "SIDL.BaseClass";
    private static final String BASE_CLASSINFO = "SIDL.ClassInfo";
    private static final String BASE_CLASSINFOI = "SIDL.ClassInfoI";
    private static final String BASE_EXCEPTION = "SIDL.BaseException";
    private static final String BASE_INTERFACE = "SIDL.BaseInterface";
    private static final String MAKEFILE_NAME = "babel.make";
    private static final int MAXIMUM_ARRAY = 7;
    private boolean d_generate_client = false;
    private boolean d_generate_remote = false;
    private boolean d_generate_server = false;
    private boolean d_generate_stdlib = false;
    private boolean d_generate_text = false;
    private boolean d_generate_xml = false;
    private boolean d_package_subdirs = false;
    private boolean d_language_subdir = false;
    private boolean d_glue_subdirs = false;
    private boolean d_parser_check = false;
    private boolean d_suppress_timestamps = false;
    private boolean d_comment_local_only = false;
    private String d_target_language = "";
    private String d_output_directory = ".";
    private String d_vpath_directory = null;
    private StringBuffer d_repository_path = new StringBuffer("");
    private List d_excluded_symbols = new LinkedList();
    private boolean d_exclude_external = false;
    private List d_included_symbols = new LinkedList();
    private static BabelConfiguration s_my_instance;

    protected BabelConfiguration() {
    }

    public static BabelConfiguration getInstance() {
        if (s_my_instance == null) {
            s_my_instance = new BabelConfiguration();
        }
        return s_my_instance;
    }

    public static String getBaseClass() {
        return BASE_CLASS;
    }

    public static String getClassInfo() {
        return BASE_CLASSINFO;
    }

    public static String getClassInfoI() {
        return BASE_CLASSINFOI;
    }

    public static String getBaseException() {
        return BASE_EXCEPTION;
    }

    public static String getBaseInterface() {
        return BASE_INTERFACE;
    }

    public static String getMakefileName() {
        return MAKEFILE_NAME;
    }

    public static int getMaximumArray() {
        return 7;
    }

    public static boolean isSIDLBaseClass(SymbolID id) {
        String n;
        boolean is_sidl = false;
        if (id != null && (n = id.getFullName()) != null && (n.equals("SIDL") || n.startsWith("SIDL."))) {
            is_sidl = true;
        }
        return is_sidl;
    }

    public void setGenerateServer(boolean generate) {
        this.d_generate_server = generate;
    }

    public boolean generateServer() {
        return this.d_generate_server;
    }

    public void setGenerateRemote(boolean generate) {
        this.d_generate_remote = generate;
    }

    public boolean generateRemote() {
        return this.d_generate_remote;
    }

    public void setGenerateClient(boolean generate) {
        this.d_generate_client = generate;
    }

    public boolean generateClient() {
        return this.d_generate_client;
    }

    public void setGenerateText(boolean generate) {
        this.d_generate_text = generate;
    }

    public boolean generateText() {
        return this.d_generate_text;
    }

    public void setGenerateXML(boolean generate) {
        this.d_generate_xml = generate;
    }

    public boolean generateXML() {
        return this.d_generate_xml;
    }

    public void setGenerateStdlib(boolean generate) {
        this.d_generate_stdlib = generate;
    }

    public boolean generateStdlib() {
        return this.d_generate_stdlib;
    }

    public void setParseCheckOnly(boolean parse) {
        this.d_parser_check = parse;
    }

    public boolean parseCheckOnly() {
        return this.d_parser_check;
    }

    public void setCommentLocalOnly(boolean localOnly) {
        this.d_comment_local_only = localOnly;
    }

    public boolean getCommentLocalOnly() {
        return this.d_comment_local_only;
    }

    public void setSuppressTimestamps(boolean suppress) {
        this.d_suppress_timestamps = suppress;
    }

    public boolean suppressTimestamps() {
        return this.d_suppress_timestamps;
    }

    public void setMakePackageSubdirs(boolean make_subdirs) {
        this.d_package_subdirs = make_subdirs;
    }

    public boolean makePackageSubdirs() {
        return this.d_package_subdirs;
    }

    public void setMakeGlueSubdirs(boolean make_glue_subdirs) {
        this.d_glue_subdirs = make_glue_subdirs;
    }

    public boolean makeGlueSubdirs() {
        return this.d_glue_subdirs;
    }

    public void setMakeLanguageSubdir(boolean make_language_subdir) {
        this.d_language_subdir = make_language_subdir;
    }

    public boolean makeLanguageSubdir() {
        return this.d_language_subdir;
    }

    public void setOutputDirectory(String dir) {
        this.d_output_directory = dir;
    }

    public String getOutputDirectory() {
        return this.d_output_directory;
    }

    public void setVPathDirectory(String dir) {
        this.d_vpath_directory = dir;
    }

    public String getVPathDirectory() {
        return this.d_vpath_directory;
    }

    public void setTargetLanguage(String lang) {
        this.d_target_language = lang;
    }

    public String getTargetLanguage() {
        return this.d_target_language;
    }

    public void addToRepositoryPath(String new_path) {
        if (this.d_repository_path != null) {
            if (this.d_repository_path.length() == 0) {
                this.d_repository_path.insert(0, new_path);
            } else {
                this.d_repository_path.insert(0, new_path + ";");
            }
        } else {
            this.d_repository_path = new StringBuffer(new_path);
        }
    }

    public String getRepositoryPath() {
        return this.d_repository_path.toString();
    }

    public void addExcluded(RegexMatch rm) {
        this.d_excluded_symbols.add(rm);
    }

    public List getExcludedList() {
        return this.d_excluded_symbols;
    }

    public void addIncluded(String str) {
        this.d_included_symbols.add(str);
    }

    public List getIncludedList() {
        return this.d_included_symbols;
    }

    public void setExcludeExternal(boolean val) {
        this.d_exclude_external = val;
    }

    public boolean excludeExternal() {
        return this.d_exclude_external;
    }

    static {
        BASE_CLASS = BASE_CLASS;
        BASE_CLASSINFO = BASE_CLASSINFO;
        BASE_CLASSINFOI = BASE_CLASSINFOI;
        BASE_EXCEPTION = BASE_EXCEPTION;
        BASE_INTERFACE = BASE_INTERFACE;
        MAKEFILE_NAME = MAKEFILE_NAME;
        MAXIMUM_ARRAY = 7;
        s_my_instance = null;
    }
}

