/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.CollectionException;
import gov.llnl.babel.UserOptions;
import gov.llnl.babel.backend.BuildGenerator;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerationFactory;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileListener;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.parsers.sidl.Parser;
import gov.llnl.babel.parsers.sidl.SIDLException;
import gov.llnl.babel.repository.Repository;
import gov.llnl.babel.repository.RepositoryException;
import gov.llnl.babel.repository.RepositoryFactory;
import gov.llnl.babel.symbols.RegexMatch;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolNotFoundException;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Version;
import gov.llnl.babel.url.URLUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class CommandLineDriver {
    private static UserOptions d_option_parser = UserOptions.getInstance();
    private static BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
    private FileManager d_file_manager = null;
    private SymbolTable d_symbol_table = null;
    private static CommandLineDriver s_my_instance = null;

    protected CommandLineDriver() {
    }

    private static CommandLineDriver getInstance() {
        if (s_my_instance == null) {
            s_my_instance = new CommandLineDriver();
        }
        return s_my_instance;
    }

    private void processCommandline(String[] args) {
        int firstUnusedArg = d_option_parser.parseCommandlineOptions(s_babel_config, args);
        if (!d_option_parser.canProceed()) {
            System.exit(1);
        }
        this.resolveRepositoryPaths();
        this.setupFileManager();
        try {
            this.resolveRemainingArgs(args, firstUnusedArg);
        }
        catch (CollectionException ex) {
            System.err.println("Babel: Error: when trying to resolve remaining args...");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        if (s_babel_config.parseCheckOnly()) {
            System.exit(0);
        }
    }

    private void resolveRepositoryPaths() {
        String repoPath = s_babel_config.getRepositoryPath();
        RepositoryFactory the_factory = RepositoryFactory.getInstance();
        this.d_symbol_table = SymbolTable.getInstance();
        StringTokenizer tokenizer = new StringTokenizer(repoPath, ";");
        while (tokenizer.hasMoreTokens()) {
            try {
                String path = tokenizer.nextToken();
                if (path == null || path.equals("") || path.equals("null")) continue;
                this.d_symbol_table.addSymbolResolver(the_factory.createRepository(path));
            }
            catch (RepositoryException ex) {
                System.err.println("Babel: Warning: When creating repository...");
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
    }

    private void setupFileManager() {
        this.d_file_manager = FileManager.getInstance();
        if (s_babel_config == null) {
            System.err.println("Babel: Warning: configuration was not populated prior to setting up the file manager.");
            s_babel_config = BabelConfiguration.getInstance();
        }
        try {
            this.d_file_manager.setFileGenerationRootDirectory(s_babel_config.getOutputDirectory());
        }
        catch (CodeGenerationException ex) {
            System.err.println("Babel: Warning: when trying to set output directory...");
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        this.d_file_manager.setJavaStylePackageGeneration(s_babel_config.makePackageSubdirs());
        this.d_file_manager.setGlueSubdirGeneration(s_babel_config.makeGlueSubdirs());
        try {
            this.d_file_manager.setVPathDirectory(s_babel_config.getVPathDirectory());
        }
        catch (CodeGenerationException ex) {
            System.err.println("Babel: Warning: when trying to set VPATH directory...");
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    private CollectionException addToCollection(CollectionException ce, String uri, Exception ex) {
        if (ce == null) {
            ce = new CollectionException(uri, ex);
        } else {
            ce.addException(uri, ex);
        }
        return ce;
    }

    private void resolveRemainingArgs(String[] args, int firstUnusedArg) throws CollectionException {
        CollectionException ce = null;
        int i = firstUnusedArg;
        while (i < args.length) {
            try {
                File f = new File(args[i]);
                if (f.exists() && f.isFile() && f.canRead()) {
                    CommandLineDriver.parseURL(f.toURL().toString());
                } else if (f.exists() && f.isDirectory()) {
                    this.resolveSymbolByString(args[i]);
                } else if (args[i].indexOf(58) != -1) {
                    CommandLineDriver.parseURL(URLUtilities.expandURL(args[i]));
                } else if (this.resolveSymbolByString(args[i]) == null) {
                    throw new CodeGenerationException("Error : \"" + args[i] + "\" fails to resolve as a symbol or file.");
                }
            }
            catch (Exception ex) {
                ce = this.addToCollection(ce, args[i], ex);
            }
            ++i;
        }
        if (this.d_symbol_table == null) {
            System.err.println("Babel: Warning: symbol table was not populated prior to symbol resolution.");
            this.d_symbol_table = SymbolTable.getInstance();
        }
        try {
            this.d_symbol_table.resolveSymbol("SIDL");
            this.d_symbol_table.resolveAllReferences();
        }
        catch (Exception ex) {
            ce = this.addToCollection(ce, null, ex);
        }
        if (ce != null) {
            throw ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseURL(String url) throws SIDLException, MalformedURLException, IOException {
        URL u = new URL(url);
        InputStream s = null;
        try {
            s = u.openStream();
            Parser parser = new Parser(new BufferedInputStream(s));
            System.out.println("Babel: Parsing URL \"" + url + "\"...");
            parser.setSourceURL(url);
            String[] warnings = parser.beginParse();
            if (warnings != null) {
                int w = 0;
                while (w < warnings.length) {
                    System.err.println("Babel: Warning: " + warnings[w]);
                    ++w;
                }
            }
            Object var7_6 = null;
            if (s == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (s == null) throw throwable;
            s.close();
            throw throwable;
        }
        s.close();
    }

    private Symbol resolveSymbolByString(String symbol_string) throws NumberFormatException, SymbolRedefinitionException {
        int split = symbol_string.indexOf("-v");
        String symbol_name = split > 0 && split < symbol_string.length() ? symbol_string.substring(0, split) : symbol_string;
        String version_name = split > 0 && split + 2 < symbol_string.length() ? symbol_string.substring(split + 2) : null;
        Symbol symbol = null;
        if (version_name == null || version_name == "") {
            symbol = this.d_symbol_table.resolveSymbol(symbol_name);
        } else {
            SymbolID id = new SymbolID(symbol_name, new Version(version_name));
            symbol = this.d_symbol_table.resolveSymbol(id);
        }
        if (symbol != null) {
            System.out.println("Babel: Resolved symbol \"" + symbol_string + "\"...");
            symbol.setUserSpecified(true);
            if (symbol.getSymbolType() == 14) {
                s_babel_config.addIncluded(symbol_string + ".");
            }
        }
        return symbol;
    }

    private void generateSourceCode() {
        if (this.d_symbol_table == null) {
            System.err.println("Babel: Warning: symbol table was not populated prior to generating source code");
            this.d_symbol_table = SymbolTable.getInstance();
        }
        Set symbols = this.d_symbol_table.getSymbolNames();
        if (s_babel_config == null) {
            System.err.println("Babel: Warning: configuration was not populated prior to generating the source code");
            s_babel_config = BabelConfiguration.getInstance();
        }
        symbols = s_babel_config.excludeExternal() ? this.excludeExternalSymbols(symbols) : CommandLineDriver.excludeSymbols(symbols);
        if (s_babel_config.generateXML()) {
            System.err.println("Babel: Warning: The --xml option is now deprecated, please start using the --text=xml option instead");
            this.generateXMLCode(symbols);
        } else {
            String targetLanguage = s_babel_config.getTargetLanguage();
            if (s_babel_config.generateText()) {
                if (targetLanguage.equals("xml")) {
                    this.generateXMLCode(symbols);
                } else {
                    try {
                        this.d_symbol_table.resolveAllParents();
                        this.generateCode(symbols, "text", targetLanguage);
                    }
                    catch (SymbolNotFoundException snfe) {
                        System.err.println("Babel: Error: SIDL backend cannot find all parent packages.");
                        System.err.println(snfe.getMessage());
                        System.exit(1);
                    }
                }
            } else {
                BuildGenerator mg = this.getBuildGen(targetLanguage);
                if (mg instanceof FileListener) {
                    this.d_file_manager.addListener((FileListener)((Object)mg));
                }
                if (s_babel_config.generateClient()) {
                    this.generateClientSource(symbols);
                    this.generateMakefiles(mg);
                } else if (s_babel_config.generateServer()) {
                    this.generateServerSource(symbols);
                    this.generateMakefiles(mg);
                } else if (s_babel_config.generateRemote()) {
                    this.generateRemoteSource(symbols);
                    this.generateMakefiles(mg);
                }
            }
        }
    }

    private void generateXMLCode(Set symbols) {
        if (s_babel_config == null) {
            System.err.println("Babel: Warning: configuration was not populated prior to generating the XML code");
            s_babel_config = BabelConfiguration.getInstance();
        }
        try {
            Repository repository = RepositoryFactory.getInstance().createRepository(s_babel_config.getOutputDirectory());
            if (repository != null) {
                repository.writeSymbols(symbols);
            }
        }
        catch (RepositoryException ex) {
            System.err.println("Babel: Error: when creating output repository...");
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            Object repository = null;
            System.exit(1);
        }
    }

    private void generateCode(Set symbols, String type, String language) {
        CodeGenerator gen = this.getCodeGen(language, type);
        if (gen != null) {
            if (gen.getUserSymbolsOnly()) {
                symbols = CommandLineDriver.filterSymbols(symbols);
            }
            try {
                gen.generateCode(symbols);
            }
            catch (CodeGenerationException ex) {
                System.err.println("Babel: Error: when trying to generate " + type + " code...");
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
                System.exit(1);
            }
        } else {
            System.err.println("Babel: Warning: when generating code...unable to generate the " + type + " sources in " + language + ".");
        }
    }

    private void generateServerSource(Set symbols) {
        this.generateClientSource(symbols);
        String targetLanguage = s_babel_config.getTargetLanguage();
        this.generateCode(symbols, "skel", targetLanguage);
    }

    private void generateClientSource(Set symbols) {
        String targetLanguage = s_babel_config.getTargetLanguage();
        this.generateCode(symbols, "ior", "ior");
        this.generateCode(symbols, "stub", targetLanguage);
    }

    private void generateRemoteSource(Set symbols) {
        System.err.println("Babel: Warning: when generating code...process to generate the remote sources undefined.");
    }

    private BuildGenerator getBuildGen(String myLang) {
        BuildGenerator bg = CodeGenerationFactory.getInstance().getBuildGenerator(myLang);
        if (bg == null) {
            System.err.println("Babel: Warning: getBuildGen( " + myLang + ") returned null.");
        }
        return bg;
    }

    private CodeGenerator getCodeGen(String myLang, String mode) {
        CodeGenerator cg = CodeGenerationFactory.getInstance().getCodeGenerator(myLang, mode);
        if (cg == null) {
            System.err.println("Babel: Warning: getCodeGen( " + myLang + ", " + mode + ") returned null.");
        }
        return cg;
    }

    public static boolean notExcluded(SymbolID id) {
        Iterator i = s_babel_config.getExcludedList().iterator();
        while (i.hasNext()) {
            if (!((RegexMatch)i.next()).match(id)) continue;
            return false;
        }
        return true;
    }

    private static Set excludeSymbols(Collection symbols) {
        HashSet<SymbolID> result = new HashSet<SymbolID>(symbols.size());
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            if (!CommandLineDriver.notExcluded(id)) continue;
            result.add(id);
        }
        return result;
    }

    private Set excludeExternalSymbols(Collection symbols) {
        HashSet<SymbolID> result = new HashSet<SymbolID>(symbols.size());
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            if (!s_babel_config.excludeExternal()) continue;
            if (this.d_symbol_table.lookupSymbol(id).getUserSpecified()) {
                result.add(id);
                continue;
            }
            Iterator incl = s_babel_config.getIncludedList().iterator();
            while (incl.hasNext()) {
                if (!id.getFullName().startsWith((String)incl.next())) continue;
                this.d_symbol_table.lookupSymbol(id).setUserSpecified(true);
                result.add(id);
            }
        }
        return result;
    }

    private static boolean filterSymbol(SymbolID id) {
        return !BabelConfiguration.isSIDLBaseClass(id);
    }

    private static Set filterSymbols(Set symbols) {
        HashSet<SymbolID> result;
        if (s_babel_config.generateStdlib()) {
            result = symbols;
        } else {
            result = new HashSet<SymbolID>(symbols.size());
            Iterator i = symbols.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                if (!CommandLineDriver.filterSymbol(id)) continue;
                result.add(id);
            }
        }
        return result;
    }

    private void generateMakefiles(BuildGenerator mg) {
        try {
            mg.createAll();
        }
        catch (IOException ex) {
            System.err.println("Warning: when trying to generate makefiles...");
            System.err.println(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            try {
                CommandLineDriver myDriver = CommandLineDriver.getInstance();
                myDriver.processCommandline(args);
                myDriver.generateSourceCode();
            }
            catch (Throwable t) {
                System.err.println("Babel: Unexplained exception...");
                System.err.println(t.getMessage());
                t.printStackTrace();
                Runtime.getRuntime().exit(1);
                Object var3_4 = null;
                Runtime.getRuntime().exit(0);
            }
            Object var3_3 = null;
            Runtime.getRuntime().exit(0);
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Runtime.getRuntime().exit(0);
            throw throwable;
        }
    }
}

