/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.Iterator;

public class IOR {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 8;
    private static final String[] s_types;
    private static final String[] s_array_types;
    private static final String[] s_builtinMethods;
    private static final String[] s_builtin_comments;
    public static final int INTERFACE_BUILTIN_METHODS = 2;
    public static final int CLASS_BUILTIN_METHODS = 4;
    public static final int CAST = 0;
    public static final int DELETE = 1;
    public static final int CONSTRUCTOR = 2;
    public static final int DESTRUCTOR = 3;
    private static String s_exceptionType;
    private static String s_objectType;
    private static String s_interfaceType;

    public static Method getBuiltinMethod(int index, SymbolID id) {
        Method m = new Method();
        m.setMethodName(IOR.getBuiltinName(index));
        m.setDefinitionModifier(0);
        String[] s = new String[]{s_builtin_comments[index]};
        m.setComment(new Comment(s));
        if (0 == index) {
            Argument a = new Argument(false, 0, new Type(10), "name");
            m.setReturnType(new Type(9));
            m.addArgument(a);
        } else {
            m.setReturnType(new Type(0));
        }
        return m;
    }

    public static String getBuiltinName(int index) {
        return s_builtinMethods[index];
    }

    public static String getVectorEntry(String methodName) {
        StringBuffer buf = new StringBuffer(2 + methodName.length());
        buf.append("f_").append(methodName);
        return buf.toString();
    }

    public static String getHeaderFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_IOR.h";
    }

    public static String getSourceFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_IOR.c";
    }

    public static String getSymbolName(SymbolID id) {
        return id.getFullName().replace('.', '_');
    }

    public static String getEnumName(SymbolID id) {
        return "enum " + IOR.getSymbolName(id) + "__enum";
    }

    public static String getExternalName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__external";
    }

    public static String getExternalFunc(SymbolID id) {
        return IOR.getSymbolName(id) + "__externals";
    }

    public static String getObjectName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__object";
    }

    public static String getArrayName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__array";
    }

    public static String getEPVName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__epv";
    }

    public static String getSEPVName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__sepv";
    }

    public static String getNewName(SymbolID id) {
        return IOR.getSymbolName(id) + "__new";
    }

    public static String getRemoteName(SymbolID id) {
        return IOR.getSymbolName(id) + "__remote";
    }

    public static String getSetEPVName(SymbolID id) {
        return IOR.getSymbolName(id) + "__set_epv";
    }

    public static String getSetSEPVName(SymbolID id) {
        return IOR.getSymbolName(id) + "__set_sepv";
    }

    public static String getStaticsName(SymbolID id) {
        return IOR.getSymbolName(id) + "__statics";
    }

    public static String getInitName(SymbolID id) {
        return IOR.getSymbolName(id) + "__init";
    }

    public static String getFiniName(SymbolID id) {
        return IOR.getSymbolName(id) + "__fini";
    }

    public static String getVersionName(SymbolID id) {
        return IOR.getSymbolName(id) + "__IOR_version";
    }

    public static String getExceptionType() {
        return s_exceptionType;
    }

    public static String getClassType() {
        return s_objectType;
    }

    public static String getInterfaceType() {
        return s_interfaceType;
    }

    public static String getSymbolType(Symbol sym) {
        if (sym.getSymbolType() == 11) {
            return IOR.getEnumName(sym.getSymbolID());
        }
        return IOR.getObjectName(sym.getSymbolID()) + "*";
    }

    public static String getReturnString(Type type) throws CodeGenerationException {
        int t = type.getType();
        if (t < s_types.length) {
            return s_types[t];
        }
        if (t == 15) {
            Symbol symbol = Utilities.lookupSymbol(type.getSymbolID());
            return IOR.getSymbolType(symbol);
        }
        if (t == 16) {
            Type atype = type.getArrayType();
            int a = atype.getType();
            if (a < s_array_types.length) {
                return s_array_types[a];
            }
            return IOR.getArrayName(atype.getSymbolID()) + "*";
        }
        return null;
    }

    public static String getArgumentString(Argument arg) throws CodeGenerationException {
        String s = IOR.getReturnString(arg.getType());
        int type = arg.getType().getType();
        if (arg.getMode() == 0) {
            if (type == 10) {
                s = "const " + s;
            }
        } else {
            s = s + "*";
        }
        return s;
    }

    public static String getArgumentWithFormal(Argument arg) throws CodeGenerationException {
        return IOR.getArgumentString(arg) + " " + arg.getFormalName();
    }

    public static String getCast(Method method, String self) throws CodeGenerationException {
        StringBuffer cast = new StringBuffer();
        cast.append("(");
        cast.append(IOR.getReturnString(method.getReturnType()));
        cast.append(" (*)(");
        cast.append(self);
        boolean has_throws = !method.getThrows().isEmpty();
        ArrayList args = method.getArgumentList();
        if (args.size() > 0 || has_throws) {
            cast.append(",");
        }
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            cast.append(IOR.getArgumentString(arg));
            if (!a.hasNext() && !has_throws) continue;
            cast.append(",");
        }
        if (has_throws) {
            cast.append(IOR.getExceptionType());
            cast.append('*');
        }
        cast.append("))");
        return cast.toString();
    }

    static {
        MAJOR_VERSION = 0;
        MINOR_VERSION = 8;
        s_types = new String[]{"void", "SIDL_bool", "char", "struct SIDL_dcomplex", "double", "struct SIDL_fcomplex", "float", "int32_t", "int64_t", "void*", "char*"};
        s_array_types = new String[]{null, "struct SIDL_bool__array*", "struct SIDL_char__array*", "struct SIDL_dcomplex__array*", "struct SIDL_double__array*", "struct SIDL_fcomplex__array*", "struct SIDL_float__array*", "struct SIDL_int__array*", "struct SIDL_long__array*", "struct SIDL_opaque__array*", "struct SIDL_string__array*"};
        s_builtinMethods = new String[]{"_cast", "_delete", "_ctor", "_dtor"};
        s_builtin_comments = new String[]{"Cast method for interface and class type conversions.", "Delete method called automatically by IOR to destroy object.", "Class constructor called when the class is created.", "Class destructor called when the class is deleted."};
        INTERFACE_BUILTIN_METHODS = 2;
        CLASS_BUILTIN_METHODS = 4;
        CAST = 0;
        DELETE = 1;
        CONSTRUCTOR = 2;
        DESTRUCTOR = 3;
        s_exceptionType = null;
        s_objectType = null;
        s_interfaceType = null;
        SymbolID id = new SymbolID(BabelConfiguration.getBaseException(), new Version());
        s_exceptionType = IOR.getObjectName(id) + " *";
        id = new SymbolID(BabelConfiguration.getBaseClass(), new Version());
        s_objectType = IOR.getObjectName(id) + " *";
        id = new SymbolID(BabelConfiguration.getBaseInterface(), new Version());
        s_interfaceType = IOR.getObjectName(id) + " *";
    }
}

