/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ImplHeader {
    private LanguageWriterForC d_writer;
    private SymbolTable d_symtab;
    private CodeSplicer d_splicer;

    public ImplHeader(LanguageWriterForC writer, CodeSplicer splicer) {
        this.d_splicer = splicer;
        this.d_writer = writer;
        this.d_symtab = SymbolTable.getInstance();
    }

    public static void generateCode(Class cls, LanguageWriterForC writer, CodeSplicer splicer) throws CodeGenerationException {
        ImplHeader header = new ImplHeader(writer, splicer);
        header.generateCode(cls);
    }

    private void writePrologue(Class cls) {
        SymbolID id = cls.getSymbolID();
        String header = C.getImplHeaderFile(id);
        this.d_writer.writeBanner(cls, header, true, "Server-side implementation for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
    }

    private void writeIncludeSection(Class cls, Collection localRefs) {
        SymbolID id = cls.getSymbolID();
        String includes = id.getFullName() + "." + "_includes";
        this.d_writer.generateInclude("SIDL_header.h", true);
        Iterator i = localRefs.iterator();
        while (i.hasNext()) {
            SymbolID sid = (SymbolID)i.next();
            this.d_writer.generateInclude(C.getHeaderFile(sid), true);
        }
        i = null;
        this.d_writer.println();
        if (this.d_splicer.hasSymbol(includes)) {
            this.d_splicer.outputSymbolEdits(includes, this.d_writer.getPrintWriter());
        } else {
            this.d_writer.writeCommentLine(CodeSplicer.getBeginString(includes));
            this.d_writer.writeCommentLine("Put additional include files here...");
            this.d_writer.writeCommentLine(CodeSplicer.getEndString(includes));
        }
        this.d_writer.println();
    }

    private void writeForwardStructDecls(Class cls, Collection localRefs) {
    }

    private void writeGetPrivateDataDecl(Class cls) {
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("extern " + C.getDataName(id) + "*");
        this.d_writer.println(C.getDataGetName(id) + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(C.getObjectName(id) + ");");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println();
    }

    private void writeSetPrivateDataDecl(Class cls) {
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("extern void");
        this.d_writer.println(C.getDataSetName(id) + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(C.getObjectName(id) + ",");
        this.d_writer.println(C.getDataName(id) + "*);");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println();
    }

    private void writeIORWrapperDecl(Class cls, String funcName, Method iorMethod) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        Iterator args = Utilities.extendArgs(id, iorMethod).iterator();
        this.d_writer.println("extern void");
        this.d_writer.print(funcName);
        this.d_writer.println("(");
        this.d_writer.increaseTabLevel();
        while (args.hasNext()) {
            Argument a = (Argument)args.next();
            this.d_writer.print(C.getArgumentString(a));
            if (!args.hasNext()) continue;
            this.d_writer.print(", ");
        }
        this.d_writer.println(");");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println();
    }

    private static void writeMethodDecl(LanguageWriter lw, Method m, SymbolID id) throws CodeGenerationException {
        Iterator arguments = Utilities.extendArgs(id, m).iterator();
        lw.print("extern ");
        lw.println(C.getReturnString(m.getReturnType()));
        lw.print(C.getMethodImplName(id, m.getLongMethodName()));
        lw.println("(");
        if (arguments.hasNext()) {
            lw.increaseTabLevel();
            while (arguments.hasNext()) {
                Argument arg = (Argument)arguments.next();
                lw.print(C.getArgumentString(arg));
                if (!arguments.hasNext()) continue;
                lw.println(",");
            }
            lw.println(");");
            lw.decreaseTabLevel();
        } else {
            lw.print("void);");
        }
        lw.println();
    }

    public static void writeMethodDecls(LanguageWriter lw, Class cls, boolean isStatic) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        Iterator i = null;
        i = isStatic ? cls.getStaticMethods(false).iterator() : cls.getNonstaticMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            ImplHeader.writeMethodDecl(lw, m, id);
        }
    }

    public static void writeBuiltinDecls(LanguageWriter lw, Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        ImplHeader.writeMethodDecl(lw, IOR.getBuiltinMethod(2, id), id);
        ImplHeader.writeMethodDecl(lw, IOR.getBuiltinMethod(3, id), id);
    }

    public Collection getLocalReferences(Extendable ext) {
        boolean hasThrows = false;
        HashSet<SymbolID> refs = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(false).iterator();
        refs.add(ext.getSymbolID());
        while (i.hasNext()) {
            Symbol sym;
            Method m = (Method)i.next();
            refs.addAll(m.getSymbolReferences());
            if (hasThrows || m.getThrows().isEmpty() || (sym = this.d_symtab.lookupSymbol(BabelConfiguration.getBaseException())) == null) continue;
            hasThrows = true;
            refs.add(sym.getSymbolID());
        }
        return refs;
    }

    private void writePrivateDataType(Class cls) {
        SymbolID id = cls.getSymbolID();
        String name = id.getFullName();
        this.d_writer.writeComment("Private data for class " + name, false);
        this.d_writer.println(C.getDataName(id) + " {");
        this.d_writer.increaseTabLevel();
        String data = cls.getFullName() + "." + "_data";
        if (this.d_splicer.hasSymbol(data)) {
            this.d_splicer.outputSymbolEdits(data, this.d_writer.getPrintWriter());
        } else {
            this.d_writer.writeCommentLine(CodeSplicer.getBeginString(data));
            this.d_writer.writeCommentLine("Put private data members here...");
            this.d_writer.println("int ignore; /* dummy to force non-empty struct; remove if you add data */");
            this.d_writer.writeCommentLine(CodeSplicer.getEndString(data));
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("};");
        this.d_writer.println();
    }

    public void generateCode(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        Collection localRefs = this.getLocalReferences(cls);
        this.writePrologue(cls);
        this.writeIncludeSection(cls, localRefs);
        this.writeForwardStructDecls(cls, localRefs);
        this.writePrivateDataType(cls);
        this.d_writer.openCxxExtern();
        this.d_writer.writeComment("Access functions for class private data and built-in methods", false);
        this.writeGetPrivateDataDecl(cls);
        this.writeSetPrivateDataDecl(cls);
        if (cls.getParentClass() == null) {
            this.writeIORWrapperDecl(cls, C.getPrivateDestructor(id), IOR.getBuiltinMethod(1, id));
        }
        ImplHeader.writeBuiltinDecls(this.d_writer, cls);
        this.d_writer.writeComment("User-defined object methods", false);
        ImplHeader.writeMethodDecls(this.d_writer, cls, true);
        ImplHeader.writeMethodDecls(this.d_writer, cls, false);
        if (this.d_splicer.hasUnusedSymbolEdits()) {
            this.d_writer.println();
            this.d_writer.beginBlockComment(true);
            this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
            this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
            this.d_writer.println("This can result from a method rename/removal in the SIDL file.");
            this.d_writer.println("Move or remove the code in order to compile cleanly.");
            this.d_writer.endBlockComment(true);
            this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
            this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
        }
        this.d_writer.closeCxxExtern();
        this.d_writer.closeHeaderGuard();
    }
}

