/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.util.Iterator;

public class ImplSource {
    private CodeSplicer d_splicer;
    private LanguageWriterForC d_writer;

    public ImplSource(LanguageWriterForC writer, CodeSplicer splicer) {
        this.d_splicer = splicer;
        this.d_writer = writer;
    }

    public static void generateCode(Class cls, LanguageWriterForC writer, CodeSplicer splicer) throws CodeGenerationException {
        ImplSource source = new ImplSource(writer, splicer);
        source.generateCode(cls);
    }

    private void writePrologue(Class cls) {
        SymbolID id = cls.getSymbolID();
        String header = C.getImplSourceFile(id);
        this.d_writer.writeBanner(cls, header, true, "Server-side implementation for " + id.getFullName());
        this.d_writer.beginBlockComment(false);
        this.d_writer.println("DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS");
        this.d_writer.println("FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.");
        this.d_writer.endBlockComment(false);
        this.d_writer.writeComment(cls, false);
    }

    private void writeIncludeSection(Class cls) {
        SymbolID id = cls.getSymbolID();
        String includes = id.getFullName() + "." + "_includes";
        this.d_writer.generateInclude(C.getImplHeaderFile(id), false);
        this.d_writer.println();
        if (this.d_splicer.hasSymbol(includes)) {
            this.d_splicer.outputSymbolEdits(includes, this.d_writer.getPrintWriter());
        } else {
            this.d_writer.writeCommentLine(CodeSplicer.getBeginString(includes));
            this.d_writer.writeCommentLine("Put additional includes or other arbitrary code here...");
            this.d_writer.writeCommentLine(CodeSplicer.getEndString(includes));
        }
        this.d_writer.println();
    }

    private void writeMethodBody(SymbolID id, String name, String desc) {
        String splicerTag = id.getFullName() + '.' + name;
        if (this.d_splicer.hasSymbol(splicerTag)) {
            this.d_splicer.outputSymbolEdits(splicerTag, this.d_writer.getPrintWriter());
        } else {
            this.d_writer.writeCommentLine(CodeSplicer.getBeginString(splicerTag));
            this.d_writer.writeCommentLine("Insert the implementation of the " + desc + " method here...");
            this.d_writer.writeCommentLine(CodeSplicer.getEndString(splicerTag));
        }
    }

    private void writeMethodShell(Method m, SymbolID id, String desc) throws CodeGenerationException {
        Iterator arguments = Utilities.extendArgs(id, m).iterator();
        String method_name = C.getMethodImplName(id, m.getLongMethodName());
        this.d_writer.writeComment(m, false);
        this.d_writer.printlnUnformatted("#undef __FUNC__");
        this.d_writer.printlnUnformatted("#define __FUNC__ \"" + method_name + "\"");
        this.d_writer.println();
        this.d_writer.println(C.getReturnString(m.getReturnType()));
        this.d_writer.println(method_name + "(");
        if (arguments.hasNext()) {
            this.d_writer.increaseTabLevel();
            while (arguments.hasNext()) {
                Argument arg = (Argument)arguments.next();
                this.d_writer.print(C.getArgumentWithFormal(arg));
                if (!arguments.hasNext()) continue;
                this.d_writer.print(", ");
            }
            this.d_writer.println(")");
            this.d_writer.decreaseTabLevel();
        } else {
            this.d_writer.println("void)");
        }
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.writeMethodBody(id, m.getLongMethodName(), desc);
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void writeBuiltinMethods(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        this.writeMethodShell(IOR.getBuiltinMethod(2, id), id, "constructor");
        this.d_writer.println();
        this.writeMethodShell(IOR.getBuiltinMethod(3, id), id, "destructor");
    }

    private void writeMethods(Class cls, boolean isStatic) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        Iterator i = null;
        i = isStatic ? cls.getStaticMethods(false).iterator() : cls.getNonstaticMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.d_writer.println();
            this.writeMethodShell(m, id, m.getLongMethodName());
        }
    }

    public void generateCode(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        this.writePrologue(cls);
        this.writeIncludeSection(cls);
        this.writeBuiltinMethods(cls);
        this.writeMethods(cls, true);
        this.writeMethods(cls, false);
        if (this.d_splicer.hasUnusedSymbolEdits()) {
            this.d_writer.println();
            this.d_writer.beginBlockComment(true);
            this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
            this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
            this.d_writer.println("This can result from a method rename/removal in the SIDL file.");
            this.d_writer.println("Move or remove the code in order to compile cleanly.");
            this.d_writer.endBlockComment(true);
            this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
            this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
        }
    }
}

