/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.c.ArrayMethods;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Version;

public class FortArrayMethods {
    private static final int s_maxArray = BabelConfiguration.getMaximumArray();
    private SymbolID d_id;
    private boolean d_isEnum;
    private String d_implArrayType;
    private String d_implDataType;
    private SymbolID d_implID;

    public FortArrayMethods(SymbolID id, boolean isEnum) {
        this.d_id = id;
        this.d_isEnum = isEnum;
        this.d_implArrayType = isEnum ? "struct SIDL_int__array *" : "struct SIDL_interface__array *";
        this.d_implDataType = isEnum ? "(int32_t)" : "(struct SIDL_BaseInterface__object *)";
        this.d_implID = isEnum ? new SymbolID("SIDL.int", new Version()) : new SymbolID("SIDL.interface", new Version());
    }

    private String getTypeName() {
        return this.d_isEnum ? IOR.getEnumName(this.d_id) : IOR.getObjectName(this.d_id);
    }

    private static void writeMethodName(LanguageWriter lw, String methodName) {
        lw.println(Fortran.getFortranSymbol() + "(" + methodName.toLowerCase() + ",");
        lw.printSpaces(18);
        lw.println(methodName.toUpperCase() + ",");
        lw.printSpaces(18);
        lw.println(methodName + ")");
    }

    private static String generateCreateName(SymbolID id, String shortType) {
        return IOR.getSymbolName(id) + "__array_create" + shortType + Fortran.getMethodSuffix();
    }

    private void generateCreateSig(LanguageWriter lw, String shortType, String longType) {
        String methodName = FortArrayMethods.generateCreateName(this.d_id, shortType);
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int32_t *dimen,");
        lw.println(" int32_t lower[],");
        lw.println(" int32_t upper[],");
        lw.println(" int64_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateCreate(LanguageWriter lw, String shortType, String longType) {
        this.generateCreateSig(lw, shortType, longType);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = (ptrdiff_t)");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateCreateName(this.d_implID, shortType) + "(*dimen, lower, upper);");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateOneDName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_create1d" + Fortran.getMethodSuffix();
    }

    private void generateOneDSig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateOneDName(this.d_id);
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int32_t *len, int64_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateOneD(LanguageWriter lw) {
        this.generateOneDSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = (ptrdiff_t)" + ArrayMethods.generateOneDName(this.d_implID) + "(*len);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateTwoDName(SymbolID id, String shortType) {
        return IOR.getSymbolName(id) + "__array_create2d" + shortType + Fortran.getMethodSuffix();
    }

    private void generateTwoDSig(LanguageWriter lw, String shortType, String longType) {
        String methodName = FortArrayMethods.generateTwoDName(this.d_id, shortType);
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int32_t *m, int32_t *n, int64_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateTwoD(LanguageWriter lw, String shortType, String longType) {
        this.generateTwoDSig(lw, shortType, longType);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = (ptrdiff_t)" + ArrayMethods.generateTwoDName(this.d_implID, shortType) + "(*m, *n);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateDelRefName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_deleteRef" + Fortran.getMethodSuffix();
    }

    private void generateDelRefSig(LanguageWriter lw) {
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, FortArrayMethods.generateDelRefName(this.d_id));
        lw.increaseTabLevel();
        lw.println("(int64_t *array)");
        lw.decreaseTabLevel();
    }

    private void generateDelRef(LanguageWriter lw) {
        this.generateDelRefSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateDelRefName(this.d_implID) + "((" + this.d_implArrayType + ")(ptrdiff_t)*array);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateAddRefName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_addRef" + Fortran.getMethodSuffix();
    }

    private void generateAddRefSig(LanguageWriter lw) {
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, FortArrayMethods.generateAddRefName(this.d_id));
        lw.increaseTabLevel();
        lw.println("(int64_t *array)");
        lw.decreaseTabLevel();
    }

    private void generateAddRef(LanguageWriter lw) {
        this.generateAddRefSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateAddRefName(this.d_implID) + "((" + this.d_implArrayType + ")(ptrdiff_t)*array);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateGetName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_get" + Fortran.getMethodSuffix();
    }

    private static String generateGetName(SymbolID id, int num) {
        return IOR.getSymbolName(id) + "__array_get" + num + Fortran.getMethodSuffix();
    }

    private void generateGetSig(LanguageWriter lw, int num) {
        String methodName = FortArrayMethods.generateGetName(this.d_id, num);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *array, ");
        int i = 1;
        while (i <= num) {
            lw.println(" int32_t *i" + i + ", ");
            ++i;
        }
        lw.println(" int64_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateGet(LanguageWriter lw, int num) {
        this.generateGetSig(lw, num);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = (ptrdiff_t)");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateGetName(this.d_implID, num) + "((const " + this.d_implArrayType + ")(ptrdiff_t)*array");
        int i = 1;
        while (i <= num) {
            lw.print(", *i" + i);
            ++i;
        }
        lw.println(");");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private void generateGetSig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateGetName(this.d_id);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *array,");
        lw.println(" int32_t indices[],");
        lw.println(" int64_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateGet(LanguageWriter lw) {
        this.generateGetSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = (ptrdiff_t)");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateGetName(this.d_implID) + "((const " + this.d_implArrayType + ")(ptrdiff_t)*array, indices);");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateSetName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_set" + Fortran.getMethodSuffix();
    }

    private static String generateSetName(SymbolID id, int num) {
        return IOR.getSymbolName(id) + "__array_set" + num + Fortran.getMethodSuffix();
    }

    private void generateSetSig(LanguageWriter lw, int num) {
        String methodName = FortArrayMethods.generateSetName(this.d_id, num);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *array,");
        int i = 1;
        while (i <= num) {
            lw.println(" int32_t *i" + i + ",");
            ++i;
        }
        lw.println(" int64_t *value)");
        lw.decreaseTabLevel();
    }

    private void generateSet(LanguageWriter lw, int num) {
        this.generateSetSig(lw, num);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateSetName(this.d_implID, num) + "((" + this.d_implArrayType + ")(ptrdiff_t)*array");
        int i = 1;
        while (i <= num) {
            lw.print(", *i" + i);
            ++i;
        }
        lw.println(", " + this.d_implDataType + "(ptrdiff_t)*value);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private void generateSetSig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateSetName(this.d_id);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *array,");
        lw.println("int32_t indices[],");
        lw.println("int64_t *value)");
        lw.decreaseTabLevel();
    }

    private void generateSet(LanguageWriter lw) {
        this.generateSetSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateSetName(this.d_implID) + "((" + this.d_implArrayType + ")(ptrdiff_t)*array, indices, " + this.d_implDataType + "(ptrdiff_t)*value);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateDimenName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_dimen" + Fortran.getMethodSuffix();
    }

    private void generateDimenSig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateDimenName(this.d_id);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *array, int32_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateDimen(LanguageWriter lw) {
        this.generateDimenSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result =");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateDimenName(this.d_implID) + "((" + this.d_implArrayType + ")(ptrdiff_t)*array);");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateBoundName(SymbolID id, String direction) {
        return IOR.getSymbolName(id) + "__array_" + direction + Fortran.getMethodSuffix();
    }

    private void generateBoundSig(LanguageWriter lw, String direction, String desc, String bad) {
        String methodName = FortArrayMethods.generateBoundName(this.d_id, direction);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *array,");
        lw.println(" int32_t *ind,");
        lw.println(" int32_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateBound(LanguageWriter lw, String direction, String desc, String bad) {
        this.generateBoundSig(lw, direction, desc, bad);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = ");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateBoundName(this.d_implID, direction) + "((" + this.d_implArrayType + ")(ptrdiff_t)*array, *ind);");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateOrderName(SymbolID id, String order) {
        return IOR.getSymbolName(id) + "__array_is" + order.substring(0, 1).toUpperCase() + order.substring(1) + "Order" + Fortran.getMethodSuffix();
    }

    private void generateOrderSig(LanguageWriter lw, String order) {
        String methodName = FortArrayMethods.generateOrderName(this.d_id, order);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *array,");
        lw.println(" SIDL_F" + Fortran.getFortranVersion() + "_Bool *result)");
        lw.decreaseTabLevel();
    }

    private void generateOrder(LanguageWriter lw, String order) {
        this.generateOrderSig(lw, order);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = " + ArrayMethods.generateOrderName(this.d_implID, order) + "((" + this.d_implArrayType + ")(ptrdiff_t)*array);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateCopyName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_copy" + Fortran.getMethodSuffix();
    }

    private void generateCopySig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateCopyName(this.d_id);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *src,");
        lw.println(" int64_t *dest)");
        lw.decreaseTabLevel();
    }

    private void generateCopy(LanguageWriter lw) {
        this.generateCopySig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateCopyName(this.d_implID) + "((const " + this.d_implArrayType + ")(ptrdiff_t)*src,");
        lw.printSpaces(ArrayMethods.generateCopyName(this.d_implID).length() + 1);
        lw.println("(" + this.d_implArrayType + ")(ptrdiff_t)*dest);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateSliceName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_slice" + Fortran.getMethodSuffix();
    }

    private void generateSliceSig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateSliceName(this.d_id);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *src,");
        lw.println(" int32_t *dimen,");
        lw.println(" int32_t numElem[],");
        lw.println(" int32_t srcStart[],");
        lw.println(" int32_t srcStride[],");
        lw.println(" int32_t newStart[],");
        lw.println(" int64_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateSlice(LanguageWriter lw) {
        this.generateSliceSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = (ptrdiff_t)");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateSliceName(this.d_implID) + "((" + this.d_implArrayType + ")(ptrdiff_t)*src,");
        lw.increaseTabLevel();
        lw.println("*dimen, numElem, srcStart, srcStride, newStart);");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateSmartCopyName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_smartCopy" + Fortran.getMethodSuffix();
    }

    private void generateSmartCopySig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateSmartCopyName(this.d_id);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *src)");
        lw.decreaseTabLevel();
    }

    private void generateSmartCopy(LanguageWriter lw) {
        this.generateSmartCopySig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateSmartCopyName(this.d_implID) + "((" + this.d_implArrayType + ")(ptrdiff_t)*src);");
        lw.decreaseTabLevel();
        lw.println("}");
    }

    private static String generateEnsureName(SymbolID id) {
        return IOR.getSymbolName(id) + "__array_ensure" + Fortran.getMethodSuffix();
    }

    private void generateEnsureSig(LanguageWriter lw) {
        String methodName = FortArrayMethods.generateEnsureName(this.d_id);
        String arrayName = IOR.getArrayName(this.d_id) + "*";
        lw.println("void");
        FortArrayMethods.writeMethodName(lw, methodName);
        lw.increaseTabLevel();
        lw.println("(int64_t *src,");
        lw.println(" int32_t *dimen,");
        lw.println(" int     *ordering,");
        lw.println(" int64_t *result)");
        lw.decreaseTabLevel();
    }

    private void generateEnsure(LanguageWriter lw) {
        this.generateEnsureSig(lw);
        lw.println("{");
        lw.increaseTabLevel();
        lw.println("*result = (ptrdiff_t)");
        lw.increaseTabLevel();
        lw.println(ArrayMethods.generateEnsureName(this.d_implID) + "((" + this.d_implArrayType + ")(ptrdiff_t)*src,");
        lw.println("*dimen, *ordering);");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.println("}");
    }

    public void generateStub(LanguageWriter lw) {
        this.generateCreate(lw, "Col", "column");
        lw.println();
        this.generateCreate(lw, "Row", "row");
        lw.println();
        this.generateOneD(lw);
        lw.println();
        this.generateTwoD(lw, "Col", "column");
        lw.println();
        this.generateTwoD(lw, "Row", "row");
        lw.println();
        this.generateAddRef(lw);
        lw.println();
        this.generateDelRef(lw);
        lw.println();
        int i = 1;
        while (i <= s_maxArray) {
            this.generateGet(lw, i);
            lw.println();
            ++i;
        }
        this.generateGet(lw);
        lw.println();
        i = 1;
        while (i <= s_maxArray) {
            this.generateSet(lw, i);
            lw.println();
            ++i;
        }
        this.generateSet(lw);
        lw.println();
        this.generateDimen(lw);
        lw.println();
        this.generateBound(lw, "lower", "lower bound", "0");
        lw.println();
        this.generateBound(lw, "upper", "upper bound", "-1");
        lw.println();
        this.generateBound(lw, "stride", "stride", "0");
        lw.println();
        this.generateOrder(lw, "column");
        lw.println();
        this.generateOrder(lw, "row");
        lw.println();
        this.generateCopy(lw);
        lw.println();
        this.generateSmartCopy(lw);
        lw.println();
        this.generateSlice(lw);
        lw.println();
        this.generateEnsure(lw);
        lw.println();
    }
}

