/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.mangler.NameMangler;
import gov.llnl.babel.backend.mangler.NonMangler;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.SymbolID;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class ImplModule {
    private LanguageWriterForFortran d_lw;
    private NameMangler d_mang = new NonMangler();
    private CodeSplicer d_splicer;
    private Class d_cls;
    private SymbolID d_id;

    public ImplModule(LanguageWriterForFortran writer, CodeSplicer splicer, Class cls) throws NoSuchAlgorithmException {
        this.d_splicer = splicer;
        this.d_lw = writer;
        this.d_cls = cls;
        this.d_id = cls.getSymbolID();
    }

    public void generateCode() throws CodeGenerationException {
        String name = this.d_cls.getFullName();
        this.d_lw.writeBanner(this.d_cls, Fortran.getImplModuleFile(this.d_id), true, "Server-side private data module for " + this.d_id.getFullName());
        this.d_lw.printlnUnformatted("#include\"" + Fortran.getStubNameFile(this.d_id) + "\"");
        try {
            this.d_lw.println("module " + this.d_mang.shortName(name, "_impl"));
            this.d_lw.println();
            this.d_splicer.splice(name + ".use", this.d_lw, "Insert use statements here...");
            this.d_lw.println();
            this.d_lw.println("type " + this.d_mang.shortName(name, "_private"));
            this.d_lw.increaseTabLevel();
            this.d_lw.println("sequence");
            this.d_splicer.splice(name + ".private_data", this.d_lw, "integer :: place_holder ! replace with your private data");
            this.d_lw.decreaseTabLevel();
            this.d_lw.println("end type " + this.d_mang.shortName(name, "_private"));
            this.d_lw.println();
            this.d_lw.println("type " + this.d_mang.shortName(name, "_wrap"));
            this.d_lw.increaseTabLevel();
            this.d_lw.println("sequence");
            this.d_lw.println("type(" + this.d_mang.shortName(name, "_private") + "), pointer :: d_private_data");
            this.d_lw.decreaseTabLevel();
            this.d_lw.println("end type " + this.d_mang.shortName(name, "_wrap"));
            this.d_lw.println();
            this.d_lw.println("end module " + this.d_mang.shortName(name, "_impl"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new CodeGenerationException("UnsupportedEncodingException: " + uee.getMessage());
        }
    }

    public static void generateCode(Class cls, LanguageWriterForFortran writer, CodeSplicer splicer) throws CodeGenerationException, NoSuchAlgorithmException {
        ImplModule mod = new ImplModule(writer, splicer, cls);
        mod.generateCode();
    }
}

