/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ior;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IORSource {
    private static int s_longestBuiltin;
    private static final String s_deleteBuiltin;
    private static final String s_castBuiltin;
    SymbolID d_baseClass = null;
    SymbolID d_classInfo = null;
    SymbolID d_classInfoI = null;
    private LanguageWriterForC d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        IORSource source = new IORSource(writer);
        source.generateCode(symbol);
    }

    public IORSource(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol != null) {
            switch (symbol.getSymbolType()) {
                case 14: {
                    break;
                }
                case 12: 
                case 13: {
                    this.generateSource((Extendable)symbol);
                }
            }
        }
    }

    private void lookupSymbolIDs() {
        SymbolTable table = SymbolTable.getInstance();
        this.d_baseClass = table.lookupSymbol(BabelConfiguration.getBaseClass()).getSymbolID();
        this.d_classInfo = table.lookupSymbol(BabelConfiguration.getClassInfo()).getSymbolID();
        this.d_classInfoI = table.lookupSymbol(BabelConfiguration.getClassInfoI()).getSymbolID();
    }

    private void generateSource(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        Object baseClass = null;
        Object classInfo = null;
        Object classInfoI = null;
        String source = IOR.getSourceFile(id);
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(ext, source, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.printlnUnformatted("#include <stdlib.h>");
        this.d_writer.printlnUnformatted("#include <stddef.h>");
        this.d_writer.printlnUnformatted("#include <string.h>");
        this.d_writer.generateInclude(header, false);
        if (!ext.isAbstract()) {
            this.lookupSymbolIDs();
            this.d_writer.generateInclude(C.getImplHeaderFile(this.d_baseClass), true);
            this.d_writer.generateInclude(C.getHeaderFile(this.d_baseClass), true);
            this.d_writer.generateInclude(C.getHeaderFile(this.d_classInfo), true);
            this.d_writer.generateInclude(C.getHeaderFile(this.d_classInfoI), true);
        }
        this.d_writer.println();
        this.d_writer.printlnUnformatted("#ifndef NULL");
        this.d_writer.printlnUnformatted("#define NULL 0");
        this.d_writer.printlnUnformatted("#endif");
        this.d_writer.println();
        Class cls = null;
        if (!ext.isInterface()) {
            cls = (Class)ext;
        }
        this.generateStaticVariables(ext);
        if (cls != null) {
            this.generateExternalReferences(cls);
        }
        if (cls != null) {
            this.generateCastFunction(cls);
            this.generateDeleteFunction(cls);
            this.generateInitEPV(cls);
            this.generateInitSEPV(cls);
            this.generateStaticFunction(cls);
            this.generateInitClassInfo(cls);
            this.generateInitMetadata(cls);
            this.generateNewFunction(cls);
            this.generateInitFunction(cls);
            this.generateFiniFunction(cls);
            this.generateVersionFunction(cls);
            this.generateExternalFunc(ext);
        }
        this.generateRemoteCastFunction(ext);
        this.generateRemoteDeleteFunction(ext);
        this.generateRemoteMethodBodies(ext);
        this.generateRemoteInitEPV(ext);
        this.generateRemoteConstructor(ext);
    }

    private void comment(String s) {
        this.d_writer.writeComment(s, false);
    }

    private void generateStaticVariables(Extendable ext) {
        this.comment("Static variables to hold version of IOR");
        this.d_writer.println("static const int32_t s_IOR_MAJOR_VERSION = 0;");
        this.d_writer.println("static const int32_t s_IOR_MINOR_VERSION = 8;");
        if (!ext.isAbstract()) {
            this.comment("Static variable to hold shared ClassInfo interface.");
            this.d_writer.println("static " + C.getObjectName(this.d_classInfo) + " s_classInfo = NULL;");
            this.d_writer.println("static int s_classInfo_init = 1;");
            this.d_writer.println();
        }
        this.comment("Static variables for managing EPV initialization.");
        boolean has_static = ext.hasStaticMethod(true);
        if (!ext.isInterface()) {
            this.d_writer.println("static int s_method_initialized = 0;");
        }
        this.d_writer.println("static int s_remote_initialized = 0;");
        if (has_static) {
            this.d_writer.println("static int s_static_initialized = 0;");
        }
        this.d_writer.println();
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        String epv = IOR.getEPVName(id);
        String sepv = IOR.getSEPVName(id);
        if (!ext.isInterface()) {
            this.d_writer.print("static " + epv + " ");
            if (has_static) {
                this.d_writer.print(" ");
            }
            this.d_writer.println("s_new__" + lower + ";");
        }
        this.d_writer.print("static " + epv + " ");
        if (has_static) {
            this.d_writer.print(" ");
        }
        this.d_writer.println("s_rem__" + lower + ";");
        if (has_static) {
            this.d_writer.print("static " + sepv + " ");
            this.d_writer.println("s_stc__" + lower + ";");
        }
        this.d_writer.println();
        if (!ext.isInterface()) {
            Class cls = (Class)ext;
            Set parents = Utilities.getAllParents(cls);
            Set new_interfaces = Utilities.getUniqueInterfaceIDs(cls);
            if (!parents.isEmpty()) {
                ArrayList sorted = Utilities.sort(parents);
                Iterator i = sorted.iterator();
                while (i.hasNext()) {
                    SymbolID p_id = (SymbolID)i.next();
                    String p_name = IOR.getSymbolName(p_id);
                    String p_lower = p_name.toLowerCase();
                    String p_epv = "static " + IOR.getEPVName(p_id);
                    boolean is_old = !new_interfaces.contains(p_id);
                    this.d_writer.print(p_epv + " ");
                    if (is_old) {
                        this.d_writer.print(" ");
                    }
                    this.d_writer.println("s_new__" + p_lower + ";");
                    if (is_old) {
                        this.d_writer.print(p_epv + "* ");
                        this.d_writer.println("s_old__" + p_lower + ";");
                    }
                    this.d_writer.print(p_epv + " ");
                    if (is_old) {
                        this.d_writer.print(" ");
                    }
                    this.d_writer.println("s_rem__" + p_lower + ";");
                    this.d_writer.println();
                }
            }
        }
    }

    private void generateExternalReferences(Class cls) {
        this.comment("Declare EPV routines defined in the skeleton file.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("extern void " + IOR.getSetEPVName(id) + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(IOR.getEPVName(id) + "* epv);");
        this.d_writer.decreaseTabLevel();
        if (cls.hasStaticMethod(true)) {
            this.d_writer.println("extern void " + IOR.getSetSEPVName(id) + "(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(IOR.getSEPVName(id) + "* sepv);");
            this.d_writer.decreaseTabLevel();
        }
        this.d_writer.println();
    }

    private void generateCastFunction(Class cls) {
        this.comment("CAST: dynamic type casting support.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("static void* ior_" + IOR.getSymbolName(id) + '_' + s_castBuiltin + '(');
        this.d_writer.increaseTabLevel();
        this.d_writer.println(IOR.getObjectName(id) + "* self,");
        this.d_writer.println("const char* name)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("void* cast = NULL;");
        this.d_writer.println();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.generateCastLogic(cls, 0);
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCastLogic(Class cls, int level) {
        String self = "s" + String.valueOf(level);
        if (level > 0) {
            this.d_writer.print("} else ");
        }
        this.d_writer.println("if (!strcmp(name, \"" + cls.getFullName() + "\")) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("cast = (void*) " + self + ";");
        this.d_writer.decreaseTabLevel();
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            String fn = id.getFullName();
            String lower = IOR.getSymbolName(id).toLowerCase();
            this.d_writer.println("} else if (!strcmp(name, \"" + fn + "\")) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("cast = (void*) &" + self + "->d_" + lower + ";");
            this.d_writer.decreaseTabLevel();
        }
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.generateCastLogic(parent, level + 1);
        } else {
            this.d_writer.println("}");
        }
    }

    private void generateDeleteFunction(Class cls) {
        this.comment("DELETE: call destructor and free object memory.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void ior_" + name + '_' + s_deleteBuiltin + '(');
        this.d_writer.increaseTabLevel();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(IOR.getFiniName(id) + "(self);");
        this.d_writer.println("memset((void*)self, 0, sizeof(" + IOR.getObjectName(id) + "));");
        this.d_writer.println("free((void*) self);");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateInitEPV(Class cls) throws CodeGenerationException {
        this.comment("EPV: create method entry point vector (EPV) structure.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        this.d_writer.println("static void " + name + "__init_epv(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(object + "* self)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        if (cls.getParentClass() != null) {
            this.generateParentSelf(cls, 0, 0);
            this.d_writer.println();
        }
        ArrayList parents = Utilities.sort(Utilities.getAllParents(cls));
        this.aliasEPVs(cls, parents, false);
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.saveEPVs(parent, 1);
        }
        List methods = (List)cls.getNonstaticMethods(true);
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
        int j = 0;
        while (j < 4) {
            String mname = IOR.getBuiltinName(j);
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (0 == j || 1 == j) {
                this.d_writer.println(" = ior_" + name + '_' + mname + ';');
            } else {
                this.d_writer.println(" = NULL;");
            }
            ++j;
        }
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (parent != null && parent.hasMethodByLongName(mname, true)) {
                this.d_writer.print(" = ");
                this.d_writer.print(IOR.getCast(method, object + "*"));
                this.d_writer.println(" s1->d_epv->" + IOR.getVectorEntry(mname) + ";");
                continue;
            }
            this.d_writer.println(" = NULL;");
        }
        this.d_writer.println();
        this.d_writer.println(IOR.getSetEPVName(id) + "(epv);");
        this.d_writer.println();
        this.copyEPVs(parents);
        this.d_writer.println("s_method_initialized = 1;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateInitSEPV(Class cls) {
        if (cls.hasStaticMethod(true)) {
            int w;
            boolean includeParent;
            this.comment("SEPV: create the static entry point vector (SEPV).");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            int width = name.length();
            this.d_writer.println("static void " + name + "__init_sepv(void)");
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            Class parent = cls.getParentClass();
            SymbolID pid = null;
            boolean bl = includeParent = parent != null && parent.hasStaticMethod(true);
            if (includeParent && (w = IOR.getSymbolName(pid = parent.getSymbolID()).length()) > width) {
                width = w;
            }
            this.d_writer.printAligned(IOR.getSEPVName(id) + "*", width += "struct __sepv*".length());
            this.d_writer.println(" s = &s_stc__" + lower + ";");
            if (includeParent) {
                this.d_writer.printAligned(IOR.getSEPVName(pid) + "*", width);
                this.d_writer.println(" p = " + IOR.getStaticsName(pid) + "();");
            }
            this.d_writer.println();
            List methods = (List)cls.getStaticMethods(true);
            int mwidth = Utilities.getWidth(methods) + IOR.getVectorEntry("").length();
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                Method method = (Method)i.next();
                String mname = method.getLongMethodName();
                this.d_writer.print("s->");
                this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
                if (parent != null && parent.hasMethodByLongName(mname, true)) {
                    this.d_writer.println(" = p->" + IOR.getVectorEntry(mname) + ";");
                    continue;
                }
                this.d_writer.println(" = NULL;");
            }
            this.d_writer.println();
            this.d_writer.println(IOR.getSetSEPVName(id) + "(s);");
            this.d_writer.println();
            this.d_writer.println("s_static_initialized = 1;");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateStaticFunction(Class cls) {
        if (cls.hasStaticMethod(true)) {
            this.comment("STATIC: return static EPV structure for static methods.");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            this.d_writer.println(IOR.getSEPVName(id) + "*");
            this.d_writer.println(IOR.getStaticsName(id) + "(void)");
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("if (!s_static_initialized) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(name + "__init_sepv();");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println("return &s_stc__" + lower + ";");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitClassInfo(Class cls) {
        if (!cls.isAbstract()) {
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("static void initMetadata(" + IOR.getObjectName(cls.getSymbolID()) + "*);");
                this.d_writer.println();
            }
            this.comment("initClassInfo: create a ClassInfo interface if necessary.");
            this.d_writer.println("static void");
            this.d_writer.println("initClassInfo(" + C.getObjectName(this.d_classInfo) + " *info)");
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("if (s_classInfo_init) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(C.getObjectName(this.d_classInfoI) + " impl;");
            this.d_writer.println("s_classInfo_init = 0;");
            this.d_writer.println("impl = " + C.getFullMethodName(this.d_classInfoI, "_create") + "();");
            this.d_writer.println("s_classInfo = " + C.getFullMethodName(this.d_classInfo, "_cast") + "(impl);");
            this.d_writer.println("if (impl) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setName") + "(impl, \"" + cls.getFullName() + "\");");
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setIORVersion") + "(impl, s_IOR_MAJOR_VERSION, s_IOR_MINOR_VERSION);");
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("initMetadata(impl);");
            }
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println("if (s_classInfo) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("if (*info) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "deleteRef") + "(*info);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println("*info = s_classInfo;");
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "addRef") + "(*info);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitMetadata(Class cls) {
        if (!cls.isAbstract()) {
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.comment("initMetadata: store IOR version & class in SIDL.BaseClass's data");
            this.d_writer.println("static void");
            this.d_writer.println("initMetadata(" + object + "* self)");
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("if (self) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(C.getDataName(this.d_baseClass) + " *data = " + C.getDataGetName(this.d_baseClass) + "(" + C.getFullMethodName(this.d_baseClass, "_cast") + "(self));");
            this.d_writer.println("if (data) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("data->d_IOR_major_version = s_IOR_MAJOR_VERSION;");
            this.d_writer.println("data->d_IOR_minor_version = s_IOR_MINOR_VERSION;");
            this.d_writer.println("initClassInfo(&(data->d_classinfo));");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateNewFunction(Class cls) {
        if (!cls.isAbstract()) {
            this.comment("NEW: allocate object and initialize it.");
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.d_writer.println(object + "*");
            this.d_writer.println(IOR.getNewName(id) + "(void)");
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(object + "* self =");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("(" + object + "*) malloc(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("sizeof(" + object + "));");
            this.d_writer.decreaseTabLevel();
            this.d_writer.decreaseTabLevel();
            this.d_writer.println(IOR.getInitName(id) + "(self);");
            this.d_writer.println("initMetadata(self);");
            this.d_writer.println("return self;");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitFunction(Class cls) {
        this.comment("INIT: initialize a new instance of the class object.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getInitName(id) + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        Class parent = cls.getParentClass();
        if (parent != null) {
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getInitName(parent.getSymbolID()) + "(s1);");
            this.d_writer.println();
        }
        this.d_writer.println("if (!s_method_initialized) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(IOR.getSymbolName(id) + "__init_epv(s0);");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.fixEPVs(cls, 0, true);
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID iid = (SymbolID)i.next();
            String n = IOR.getSymbolName(iid).toLowerCase();
            this.d_writer.println("s0->d_" + n + ".d_object = self;");
            this.d_writer.println();
        }
        this.d_writer.println("s0->d_data = NULL;");
        this.d_writer.println();
        this.d_writer.println(IORSource.methodCall(cls, "self", IOR.getBuiltinName(2), ""));
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateFiniFunction(Class cls) {
        this.comment("FINI: deallocate a class instance (destructor).");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getFiniName(id) + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.d_writer.println(IORSource.methodCall(cls, "s0", IOR.getBuiltinName(3), ""));
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.d_writer.println();
            this.fixEPVs(parent, 1, false);
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getFiniName(parent.getSymbolID()) + "(s1);");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateVersionFunction(Class cls) {
        this.comment("VERSION: Return the version of the IOR used to generate this IOR.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.println(IOR.getVersionName(id) + "(int32_t *major, int32_t *minor)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("*major = s_IOR_MAJOR_VERSION;");
        this.d_writer.println("*minor = s_IOR_MINOR_VERSION;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateRemoteCastFunction(Extendable ext) {
        this.comment("REMOTE CAST: dynamic type casting for remote objects.");
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void* remote_" + name + '_' + s_castBuiltin + '(');
        this.d_writer.increaseTabLevel();
        if (ext.isInterface()) {
            this.d_writer.println("void* self,");
        } else {
            this.d_writer.println(IOR.getObjectName(id) + "* self,");
        }
        this.d_writer.println("const char* name)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("return NULL;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteDeleteFunction(Extendable ext) {
        this.comment("REMOTE DELETE: call the remote destructor for the object.");
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void remote_" + name + '_' + s_deleteBuiltin + '(');
        this.d_writer.increaseTabLevel();
        if (ext.isInterface()) {
            this.d_writer.println("void* self)");
        } else {
            this.d_writer.println(IOR.getObjectName(id) + "* self)");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("free((void*) self);");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteMethodBodies(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        Iterator m = ext.getNonstaticMethods(true).iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            String method_name = method.getLongMethodName();
            Type type = method.getReturnType();
            this.comment("REMOTE METHOD STUB:" + method_name);
            this.d_writer.println("static " + IOR.getReturnString(type));
            this.d_writer.println("remote_" + name + "_" + method_name + "(");
            this.d_writer.increaseTabLevel();
            boolean has_throws = !method.getThrows().isEmpty();
            ArrayList args = method.getArgumentList();
            if (ext.isInterface()) {
                this.d_writer.print("void* self");
            } else {
                this.d_writer.print(object + "* self");
            }
            if (args.size() > 0 || has_throws) {
                this.d_writer.println(",");
            }
            Iterator a = args.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                this.d_writer.print(IOR.getArgumentWithFormal(arg));
                if (!a.hasNext() && !has_throws) continue;
                this.d_writer.println(",");
            }
            if (has_throws) {
                this.d_writer.print(IOR.getExceptionType());
                this.d_writer.print("*_ex");
            }
            this.d_writer.println(")");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            switch (type.getType()) {
                case 0: {
                    break;
                }
                case 3: 
                case 5: {
                    this.d_writer.print(IOR.getReturnString(type));
                    this.d_writer.println(" _result;");
                    this.d_writer.println("_result.real = _result.imaginary = 0;");
                    this.d_writer.println("return _result;");
                    break;
                }
                case 15: {
                    this.d_writer.println("return (" + IOR.getReturnString(type) + ") 0;");
                    break;
                }
                case 9: 
                case 16: {
                    this.d_writer.println("return NULL;");
                    break;
                }
                default: {
                    this.d_writer.println("return 0;");
                }
            }
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateRemoteInitEPV(Extendable ext) throws CodeGenerationException {
        this.comment("REMOTE EPV: create remote entry point vectors (EPVs).");
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        this.d_writer.println("static void " + name + "__init_remote_epv(void)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        ArrayList parents = null;
        if (ext.isInterface()) {
            this.d_writer.print(IOR.getEPVName(id) + "*");
            this.d_writer.println(" epv = &s_rem__" + lower + ";");
            this.d_writer.println();
        } else {
            parents = Utilities.sort(Utilities.getAllParents((Class)ext));
            this.aliasEPVs((Class)ext, parents, true);
        }
        List methods = (List)ext.getNonstaticMethods(true);
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
        int numBuiltins = ext.isInterface() ? 2 : 4;
        int j = 0;
        while (j < numBuiltins) {
            String mname = IOR.getBuiltinName(j);
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (0 == j || 1 == j) {
                this.d_writer.println(" = remote_" + name + '_' + mname + ';');
            } else {
                this.d_writer.println(" = NULL;");
            }
            ++j;
        }
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            this.d_writer.println(" = remote_" + name + "_" + mname + ";");
        }
        if (parents != null) {
            this.d_writer.println();
            this.copyEPVs(parents);
        }
        this.d_writer.println("s_remote_initialized = 1;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteConstructor(Extendable ext) {
        this.comment("REMOTE: generate remote instance given URL string.");
        SymbolID id = ext.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        String object = IOR.getObjectName(id);
        this.d_writer.println(object + "*");
        this.d_writer.println(IOR.getRemoteName(id) + "(const char *url)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(object + "* self =");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("(" + object + "*) malloc(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("sizeof(" + object + "));");
        this.d_writer.decreaseTabLevel();
        this.d_writer.decreaseTabLevel();
        this.d_writer.println();
        if (!ext.isInterface()) {
            this.generateParentSelf((Class)ext, 0, 0);
            this.d_writer.println();
        }
        this.d_writer.println("if (!s_remote_initialized) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(name + "__init_remote_epv();");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        if (ext.isInterface()) {
            this.d_writer.println("self->d_epv    = &s_rem__" + lower + ";");
            this.d_writer.println("self->d_object = NULL; /* FIXME */");
            this.d_writer.println();
        } else {
            this.remoteEPVs((Class)ext, 0);
        }
        this.d_writer.println("return self;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateParentSelf(Class cls, int level, int width) {
        if (cls != null) {
            if (width == 0) {
                Class parent = cls;
                while (parent != null) {
                    int w = IOR.getObjectName(parent.getSymbolID()).length();
                    if (w > width) {
                        width = w;
                    }
                    parent = parent.getParentClass();
                }
            }
            SymbolID id = cls.getSymbolID();
            this.d_writer.printAligned(IOR.getObjectName(id) + "*", width + 1);
            this.d_writer.print(" s" + String.valueOf(level) + " = ");
            if (level == 0) {
                this.d_writer.println("self;");
            } else {
                this.d_writer.print("&s" + String.valueOf(level - 1) + "->d_");
                this.d_writer.println(IOR.getSymbolName(id).toLowerCase() + ";");
            }
            this.generateParentSelf(cls.getParentClass(), level + 1, width);
        }
    }

    private void fixEPVs(Class cls, int level, boolean is_new) {
        if (cls != null) {
            this.fixEPVs(cls.getParentClass(), level + 1, is_new);
            String self = "s" + String.valueOf(level);
            String news = is_new ? "new" : "old";
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            int width = Utilities.getWidth(ifce) + "d_.d_epv".length();
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.print(self + "->");
                this.d_writer.printAligned("d_" + n + ".d_epv", width);
                this.d_writer.print(" = ");
                if (is_new) {
                    this.d_writer.print("&");
                }
                this.d_writer.println("s_" + news + "__" + n + ";");
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.print(self + "->");
            this.d_writer.printAligned("d_epv", width);
            this.d_writer.print(" = ");
            if (is_new) {
                this.d_writer.print("&");
            }
            this.d_writer.println("s_" + news + "__" + lower + ";");
            this.d_writer.println();
        }
    }

    private void saveEPVs(Class cls, int level) {
        if (cls != null) {
            this.saveEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            int width = Utilities.getWidth(ifce);
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.print("s_old__" + n);
                this.d_writer.printSpaces(width - n.length());
                this.d_writer.println(" = " + self + "->d_" + n + ".d_epv;");
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.print("s_old__" + lower);
            this.d_writer.printSpaces(width - lower.length());
            this.d_writer.println(" = " + self + "->d_epv;");
            this.d_writer.println();
        }
    }

    private void remoteEPVs(Class cls, int level) {
        if (cls != null) {
            this.remoteEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.println(self + "->d_" + n + ".d_epv    = &s_rem__" + n + ";");
                this.d_writer.println(self + "->d_" + n + ".d_object = NULL; /* FIXME */");
                this.d_writer.println();
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.println(self + "->d_data = NULL; /* FIXME */");
            this.d_writer.println(self + "->d_epv  = &s_rem__" + lower + ";");
            this.d_writer.println();
        }
    }

    private void aliasEPVs(Class cls, Collection parents, boolean remote) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String epv = IOR.getEPVName(id);
        String prefix = remote ? "&s_rem__" : "&s_new__";
        int width = epv.length() + 1;
        int w = Utilities.getWidth(parents) + "struct __epv*".length();
        if (w > width) {
            width = w;
        }
        this.d_writer.printAligned(epv + "*", width);
        this.d_writer.println(" epv = " + prefix + name.toLowerCase() + ";");
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID sid = (SymbolID)i.next();
            String lower = IOR.getSymbolName(sid).toLowerCase();
            this.d_writer.printAligned(IOR.getEPVName(sid) + "*", width);
            this.d_writer.printAligned(" e" + String.valueOf(e++), 4);
            this.d_writer.println(" = " + prefix + lower + ";");
        }
        this.d_writer.println();
    }

    private void copyEPVs(Collection parents) throws CodeGenerationException {
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Extendable ext = (Extendable)Utilities.lookupSymbol(id);
            String name = IOR.getSymbolName(id);
            List methods = (List)ext.getNonstaticMethods(true);
            int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
            String self = null;
            self = ext.isInterface() ? "void*" : IOR.getObjectName(id) + "*";
            String estring = "e" + String.valueOf(e) + "->";
            String vecEntry = IOR.getVectorEntry(s_castBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.print(" = (void* (*)(" + self);
            this.d_writer.print(",const char*)) epv->");
            this.d_writer.print(vecEntry);
            this.d_writer.println(";");
            vecEntry = IOR.getVectorEntry(s_deleteBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.println(" = (void (*)(" + self + ")) epv->" + vecEntry + ";");
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                Method method = (Method)j.next();
                String mname = method.getLongMethodName();
                this.d_writer.print(estring);
                this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
                this.d_writer.print(" = " + IOR.getCast(method, self));
                this.d_writer.println(" epv->" + IOR.getVectorEntry(mname) + ";");
            }
            this.d_writer.println();
            ++e;
        }
    }

    private static String methodCall(Extendable ext, String var, String method, String args) {
        String result = "(*(" + var + "->d_epv->" + IOR.getVectorEntry(method) + "))(" + var;
        if (ext.isInterface()) {
            result = result + "->d_object";
        }
        result = result + args;
        result = result + ");";
        return result;
    }

    private void generateReplaceValue(Symbol symbol) {
        this.d_writer.println("if (result) {");
        this.d_writer.increaseTabLevel();
        if (symbol instanceof Extendable) {
            this.d_writer.println("if (value) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(IORSource.methodCall((Extendable)symbol, "value", "addRef", ""));
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println("if (*result) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(IORSource.methodCall((Extendable)symbol, "(*result)", "deleteRef", ""));
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
        }
        this.d_writer.println("*result = value;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    public static void generateExternalSignature(LanguageWriter lw, Symbol sym, String terminator) {
        SymbolID id = sym.getSymbolID();
        lw.beginBlockComment(false);
        lw.println("This function returns a pointer to a static structure of");
        lw.println("pointers to function entry points.  Its purpose is to provide");
        lw.println("one-stop shopping for loading DLLs.");
        lw.println("loading DLLs");
        lw.endBlockComment(false);
        lw.println("const " + IOR.getExternalName(id) + "*");
        lw.println(IOR.getExternalFunc(id) + "(void)" + terminator);
    }

    private void generateExternalFunc(Symbol sym) {
        SymbolID id = sym.getSymbolID();
        this.d_writer.println("static const " + IOR.getExternalName(id));
        this.d_writer.println("s_externalEntryPoints = {");
        this.d_writer.increaseTabLevel();
        if (sym instanceof Class) {
            Class cls = (Class)sym;
            if (!cls.isAbstract()) {
                this.d_writer.println(IOR.getNewName(id) + ",");
            }
            this.d_writer.println(IOR.getRemoteName(id) + ",");
            if (cls.hasStaticMethod(true)) {
                this.d_writer.println(IOR.getStaticsName(id) + ",");
            }
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("};");
        this.d_writer.println();
        IORSource.generateExternalSignature(this.d_writer, sym, "");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("return &s_externalEntryPoints;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    static {
        s_deleteBuiltin = IOR.getBuiltinName(1);
        s_castBuiltin = IOR.getBuiltinName(0);
        s_longestBuiltin = 0;
        int j = 0;
        while (j < 4) {
            String mname = IOR.getBuiltinName(j);
            if (mname.length() > s_longestBuiltin) {
                s_longestBuiltin = mname.length();
            }
            ++j;
        }
    }
}

