/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.python.Python;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;

public class PythonClientHeader {
    private Extendable d_ext = null;
    private LanguageWriterForC d_lw = null;
    private static int s_numMethods = 9;
    private String[] d_methodNames = null;
    private String[] d_methodPrototypes = null;
    private String[] d_methodReturn = null;

    public PythonClientHeader(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String iorType = IOR.getObjectName(id);
        String arrayType = IOR.getArrayName(id);
        this.d_ext = ext;
        this.d_methodNames = new String[s_numMethods];
        this.d_methodPrototypes = new String[s_numMethods];
        this.d_methodReturn = new String[s_numMethods];
        this.d_methodNames[0] = Python.getExtendableWrapper(this.d_ext);
        this.d_methodReturn[0] = "PyObject *";
        this.d_methodPrototypes[0] = "(" + iorType + " *sidlobj)";
        this.d_methodNames[1] = Python.getExtendableConverter(this.d_ext);
        this.d_methodReturn[1] = "int";
        this.d_methodPrototypes[1] = "(PyObject *obj, " + iorType + " **sidlobj)";
        this.d_methodNames[2] = Python.getBorrowArrayFromPython(new Type(id));
        this.d_methodReturn[2] = "int";
        this.d_methodPrototypes[2] = "(PyObject *obj, " + arrayType + " **sidlarray)";
        this.d_methodNames[3] = Python.getBorrowArrayFromSIDL(new Type(id));
        this.d_methodReturn[3] = "PyObject *";
        this.d_methodPrototypes[3] = "(" + arrayType + " *sidlarray)";
        this.d_methodNames[4] = Python.getDestroyArray(new Type(id));
        this.d_methodReturn[4] = "void";
        this.d_methodPrototypes[4] = "(" + arrayType + " *sidlarray)";
        this.d_methodNames[5] = Python.getExtendableBorrow(this.d_ext);
        this.d_methodReturn[5] = "PyObject *";
        this.d_methodPrototypes[5] = "(" + iorType + " *sidlobj)";
        this.d_methodNames[6] = Python.getExtendableDeref(this.d_ext);
        this.d_methodReturn[6] = "void";
        this.d_methodPrototypes[6] = "(" + iorType + " *sidlobj)";
        this.d_methodNames[7] = Python.getExtendableNewRef(this.d_ext);
        this.d_methodReturn[7] = "PyObject *";
        this.d_methodPrototypes[7] = "(" + iorType + " *sidlobj)";
        this.d_methodNames[8] = Python.getExtendableAddRef(this.d_ext);
        this.d_methodReturn[8] = "void";
        this.d_methodPrototypes[8] = "(" + iorType + " *sidlobj)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String guard = Python.getIncludeGuard(this.d_ext, "MODULE");
        try {
            this.d_lw = Python.createCHeader(this.d_ext, "Module", "expose a constructor for the Python wrapper");
            this.explainExtHeader();
            this.d_lw.openHeaderGuard(guard);
            this.d_lw.printlnUnformatted("#include <Python.h>");
            this.d_lw.printlnUnformatted("#include \"babel_config.h\"");
            this.d_lw.println();
            this.d_lw.openCxxExtern();
            this.addSharedDefs();
            this.d_lw.printUnformatted("#ifdef ");
            this.d_lw.printlnUnformatted(Python.getInternalGuard(this.d_ext));
            this.addInternalDecls();
            this.d_lw.printlnUnformatted("#else");
            this.addClientMacroDefs();
            this.d_lw.printlnUnformatted("#endif");
            this.d_lw.println();
            this.d_lw.closeCxxExtern();
            this.d_lw.println();
            this.d_lw.closeHeaderGuard();
            Object var3_2 = null;
            if (this.d_lw == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.d_lw == null) throw throwable;
            this.d_lw.close();
            this.d_lw = null;
            throw throwable;
        }
        this.d_lw.close();
        this.d_lw = null;
    }

    private boolean isException() throws CodeGenerationException {
        Symbol sym;
        if (this.d_ext instanceof Class && (sym = Utilities.lookupSymbol(BabelConfiguration.getBaseException())) != null) {
            SymbolID symID = sym.getSymbolID();
            return symID.equals(this.d_ext.getSymbolID()) || ((Class)this.d_ext).hasParentClass(symID, true);
        }
        return false;
    }

    private void addClientMacroDefs() throws CodeGenerationException {
        String apivar = Python.getAPIVarName(this.d_ext);
        this.d_lw.println();
        this.d_lw.print("static void **");
        this.d_lw.print(apivar);
        this.d_lw.println(";");
        this.d_lw.println();
        this.d_lw.disableLineBreak();
        int i = 0;
        while (i < s_numMethods) {
            this.d_lw.print("#define ");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.println(" \\");
            this.d_lw.print("  (*((");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.println("_RETURN (*) \\");
            this.d_lw.print("  ");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.println("_PROTO) \\");
            this.d_lw.print("  (");
            this.d_lw.print(apivar);
            this.d_lw.println(" \\");
            this.d_lw.print("  [");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.println("_NUM])))");
            this.d_lw.println();
            ++i;
        }
        if (this.isException()) {
            String exType = Python.getExceptionType(this.d_ext);
            this.d_lw.print("#define ");
            this.d_lw.print(exType);
            this.d_lw.println(" \\");
            this.d_lw.print("  ((PyObject *)(");
            this.d_lw.print(apivar);
            this.d_lw.print("[");
            this.d_lw.print(exType);
            this.d_lw.println("_NUM]))");
            this.d_lw.println();
        }
        this.d_lw.print("#define ");
        this.d_lw.print(Python.getExtendableImport(this.d_ext));
        this.d_lw.println("() \\");
        this.d_lw.println("{ \\");
        this.d_lw.print("  PyObject *module = PyImport_ImportModule(\"");
        this.d_lw.print(this.d_ext.getFullName());
        this.d_lw.println("\"); \\");
        this.d_lw.println("  if (module != NULL) { \\");
        this.d_lw.println("    PyObject *module_dict = PyModule_GetDict(module); \\");
        this.d_lw.println("    PyObject *c_api_object = \\");
        this.d_lw.println("      PyDict_GetItemString(module_dict, \"_C_API\"); \\");
        this.d_lw.println("    if (PyCObject_Check(c_api_object)) { \\");
        this.d_lw.print("      ");
        this.d_lw.print(apivar);
        this.d_lw.println(" = \\");
        this.d_lw.println("        (void **)PyCObject_AsVoidPtr(c_api_object); \\");
        this.d_lw.println("    } \\");
        this.d_lw.println("    Py_DECREF(module); \\");
        this.d_lw.println("  } \\");
        this.d_lw.println("}");
        this.d_lw.enableLineBreak();
        this.d_lw.println();
    }

    private void addInternalDecls() throws CodeGenerationException {
        this.d_lw.println();
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("This declaration is not for clients.");
        this.d_lw.endBlockComment(false);
        int i = 0;
        while (i < s_numMethods) {
            this.d_lw.print("static ");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.println("_RETURN");
            this.d_lw.println(this.d_methodNames[i]);
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.println("_PROTO;");
            this.d_lw.println();
            ++i;
        }
        if (this.isException()) {
            String exType = Python.getExceptionType(this.d_ext);
            this.d_lw.println("static PyObject *");
            this.d_lw.print(exType);
            this.d_lw.println(";");
            this.d_lw.println();
        }
    }

    private void addSharedDefs() throws CodeGenerationException {
        this.d_lw.println();
        this.d_lw.writeCommentLine("Forward declaration of IOR structure");
        this.d_lw.print(IOR.getObjectName(this.d_ext.getSymbolID()));
        this.d_lw.println(";");
        this.d_lw.print(IOR.getArrayName(this.d_ext.getSymbolID()));
        this.d_lw.println(";");
        this.d_lw.println();
        this.d_lw.disableLineBreak();
        int i = 0;
        while (i < s_numMethods) {
            this.d_lw.print("#define ");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.print("_NUM ");
            this.d_lw.println(Integer.toString(i));
            this.d_lw.print("#define ");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.print("_RETURN ");
            this.d_lw.println(this.d_methodReturn[i]);
            this.d_lw.print("#define ");
            this.d_lw.print(this.d_methodNames[i]);
            this.d_lw.print("_PROTO ");
            this.d_lw.println(this.d_methodPrototypes[i]);
            this.d_lw.println();
            ++i;
        }
        if (this.isException()) {
            this.d_lw.print("#define ");
            this.d_lw.print(Python.getExceptionType(this.d_ext));
            this.d_lw.print("_NUM ");
            this.d_lw.println(Integer.toString(i++));
            this.d_lw.println();
        }
        this.d_lw.print("#define ");
        this.d_lw.print(Python.getAPIVarName(this.d_ext));
        this.d_lw.print("_NUM ");
        this.d_lw.println(Integer.toString(i));
        this.d_lw.enableLineBreak();
        this.d_lw.println();
    }

    private void explainExtHeader() throws CodeGenerationException {
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL");
        this.d_lw.println("COMPILER. DO NOT EDIT THIS!");
        this.d_lw.println();
        this.d_lw.println("External clients need an entry point to wrap a pointer");
        this.d_lw.print("to an instance of ");
        this.d_lw.print(this.d_ext.getFullName());
        this.d_lw.println(".");
        this.d_lw.println("This header files defines two methods that such clients");
        this.d_lw.println("will need.");
        this.d_lw.print("    ");
        this.d_lw.println(Python.getExtendableImport(this.d_ext));
        this.d_lw.println("        This should be called in the client's init");
        this.d_lw.println("        module method.");
        this.d_lw.print("    ");
        this.d_lw.println(Python.getExtendableWrapper(this.d_ext));
        this.d_lw.println("        This will wrap an IOR in a Python object.");
        if (this.isException()) {
            this.d_lw.println("This object can be used as an exception. It exports");
            this.d_lw.println("a Python exception type that may be needed as well.");
            this.d_lw.print("    ");
            this.d_lw.println(Python.getExceptionType(this.d_ext));
            this.d_lw.println("        A Python exception type corresponding to");
            this.d_lw.println("        this object type.");
            this.d_lw.println("Here is the pattern for throwing an exception:");
            this.d_lw.print("  PyObject *obj = ");
            this.d_lw.print(Python.getExtendableWrapper(this.d_ext));
            this.d_lw.println("(ex);");
            this.d_lw.print("  PyErr_SetObject(");
            this.d_lw.print(Python.getExceptionType(this.d_ext));
            this.d_lw.println(", obj);");
            this.d_lw.println("  Py_XDECREF(obj);");
        }
        this.d_lw.endBlockComment(false);
    }
}

