/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.python.Python;
import gov.llnl.babel.backend.python.TranslateArguments;
import gov.llnl.babel.backend.writers.LanguageWriterForPython;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PythonServerPySource {
    private LanguageWriterForPython d_lw = null;
    private CodeSplicer d_splicer = null;
    private Class d_cls = null;

    public PythonServerPySource(Class cls) {
        this.d_cls = cls;
    }

    private void addSplicerBlock(String name, boolean addPass) {
        if (this.d_splicer.hasSymbol(name)) {
            this.d_splicer.outputSymbolEdits(name, this.d_lw.getPrintWriter());
        } else {
            this.d_lw.writeCommentLine(CodeSplicer.getBeginString(name));
            this.d_lw.writeCommentLine("Put your code here...");
            if (addPass) {
                this.d_lw.println("pass");
            }
            this.d_lw.writeCommentLine(CodeSplicer.getEndString(name));
        }
    }

    private void importReferences() {
        Iterator i = this.d_cls.getSymbolReferences().iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            this.d_lw.println("import " + id.getFullName());
        }
        this.d_lw.println();
    }

    private void addDocComment(Comment comment) {
        String[] text;
        if (comment != null && (text = comment.getComment()) != null && text.length > 0) {
            this.d_lw.println("\"\"\"\\");
            int i = 0;
            while (i < text.length) {
                this.d_lw.printlnUnformatted(LanguageWriterForPython.toPythonString(text[i]));
                ++i;
            }
            this.d_lw.printlnUnformatted("\"\"\"");
        }
    }

    private void addExpectedIncomingComment(List argList) {
        if (argList.size() > 0) {
            Iterator args = argList.iterator();
            this.d_lw.beginBlockComment(false);
            this.d_lw.println("SIDL EXPECTED INCOMING TYPES");
            this.d_lw.println("============================");
            while (args.hasNext()) {
                Argument arg = (Argument)args.next();
                if (2 == arg.getMode()) continue;
                this.d_lw.println(arg.getType().getTypeString() + " " + arg.getFormalName());
            }
            this.d_lw.endBlockComment(false);
        }
    }

    private void addExpectedReturnComment(Type returnType, List argList) {
        List returnTypes = TranslateArguments.extractOut(returnType, argList);
        int size = returnTypes.size();
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("SIDL EXPECTED RETURN VALUE(s)");
        this.d_lw.println("=============================");
        if (size > 0) {
            Iterator args;
            if (size > 1) {
                args = returnTypes.iterator();
                this.d_lw.print("(" + ((Argument)args.next()).getFormalName());
                while (args.hasNext()) {
                    this.d_lw.print(", " + ((Argument)args.next()).getFormalName());
                }
                this.d_lw.println(")");
            }
            args = returnTypes.iterator();
            while (args.hasNext()) {
                Argument arg = (Argument)args.next();
                this.d_lw.println(arg.getType().getTypeString() + " " + arg.getFormalName());
            }
        } else {
            this.d_lw.writeCommentLine("None");
        }
        this.d_lw.endBlockComment(false);
    }

    private void writeMethodImpl(Method m) {
        ArrayList argList = m.getArgumentList();
        boolean needComma = false;
        Iterator args = argList.iterator();
        this.d_lw.print("def " + m.getLongMethodName() + "(");
        if (3 != m.getDefinitionModifier()) {
            this.d_lw.print("self");
            needComma = true;
        }
        while (args.hasNext()) {
            Argument arg = (Argument)args.next();
            if (2 == arg.getMode()) continue;
            if (needComma) {
                this.d_lw.print(", ");
            } else {
                needComma = true;
            }
            this.d_lw.print(arg.getFormalName());
        }
        this.d_lw.println("):");
        this.d_lw.increaseTabLevel();
        this.addExpectedIncomingComment(argList);
        this.addExpectedReturnComment(m.getReturnType(), argList);
        this.addDocComment(m.getComment());
        this.addSplicerBlock(m.getLongMethodName(), true);
        this.d_lw.decreaseTabLevel();
        this.d_lw.println();
    }

    private void writeStaticMethods() {
        Iterator i = this.d_cls.getStaticMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            this.writeMethodImpl(m);
        }
    }

    private void writeClass() {
        this.d_lw.println("class " + this.d_cls.getSymbolID().getShortName() + ":");
        this.d_lw.increaseTabLevel();
        this.addDocComment(this.d_cls.getComment());
        this.d_lw.println();
        this.d_lw.writeCommentLine("All calls to SIDL methods should use __IORself");
        this.d_lw.println();
        this.d_lw.println("def __init__(self, IORself):");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("self.__IORself = IORself");
        this.addSplicerBlock("__init__", false);
        this.d_lw.decreaseTabLevel();
        this.d_lw.println();
        Iterator i = this.d_cls.getNonstaticMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.writeMethodImpl(m);
        }
        this.d_lw.decreaseTabLevel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generateCode() throws CodeGenerationException {
        try {
            block5: {
                try {
                    String filename = Python.implFilename(this.d_cls);
                    this.d_splicer = Python.getPySplicer(this.d_cls, filename);
                    this.d_lw = Python.createPyWriter(this.d_cls, filename, "Implementation of SIDL class " + this.d_cls.getFullName() + " in Python.");
                    this.addSplicerBlock("_initial", false);
                    this.d_lw.println();
                    this.importReferences();
                    if (this.d_cls.hasStaticMethod(false)) {
                        this.addSplicerBlock("_before_static", false);
                        this.d_lw.println();
                        this.writeStaticMethods();
                    }
                    this.addSplicerBlock("_before_type", false);
                    this.d_lw.println();
                    this.writeClass();
                    this.addSplicerBlock("_final", false);
                    if (!this.d_splicer.hasUnusedSymbolEdits()) break block5;
                    this.d_lw.println();
                    this.d_lw.println("pass");
                    this.d_lw.beginBlockComment(true);
                    this.d_lw.println("================= BEGIN UNREFERENCED METHOD(S) ================");
                    this.d_lw.println("The following code segment(s) belong to unreferenced method(s).");
                    this.d_lw.println("This can result from a method rename/removal in the SIDL file.");
                    this.d_lw.println("Move or remove the code in order to compile cleanly.");
                    this.d_lw.endBlockComment(true);
                    this.d_splicer.outputUnusedSymbolEdits(this.d_lw.getPrintWriter());
                    this.d_lw.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
                }
                catch (IOException ioe) {
                    throw new CodeGenerationException("Unable to get code splicer");
                }
            }
            Object var3_3 = null;
            if (this.d_lw == null) return;
            this.d_lw.close();
            this.d_lw = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this.d_lw == null) throw throwable;
            this.d_lw.close();
            this.d_lw = null;
            throw throwable;
        }
    }
}

