/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.BuildGenerator;
import gov.llnl.babel.backend.FileListener;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForPython;
import gov.llnl.babel.symbols.SymbolID;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SetupGenerator
implements BuildGenerator,
FileListener {
    private Map d_mod2csrc = new HashMap();
    private Set d_pymodules = new TreeSet();
    private Set d_headers = new TreeSet();
    private Set d_packages = new TreeSet();

    private void writeList(LanguageWriter lw, String heading, Iterator i) {
        lw.println(heading + " = [");
        lw.increaseTabLevel();
        while (i.hasNext()) {
            lw.print("'" + i.next().toString() + "'");
            lw.println(i.hasNext() ? "," : "");
        }
        lw.decreaseTabLevel();
        lw.println("],");
    }

    private void processArgs(LanguageWriter lw) {
        lw.println();
        lw.println("inc_re = compile('^--include-dirs=(.*)$')");
        lw.println("lib_re = compile('^--library-dirs=(.*)$')");
        lw.println("old_argv = sys.argv");
        lw.println("sys.argv = []");
        lw.println("inc_dirs = ['.']");
        lw.println("lib_dirs = []");
        lw.println();
        lw.println("for i in old_argv:");
        lw.increaseTabLevel();
        lw.println("m = inc_re.match(i)");
        lw.println("if (m):");
        lw.increaseTabLevel();
        lw.println("if (len(m.group(1))): inc_dirs.append(m.group(1))");
        lw.decreaseTabLevel();
        lw.println("else:");
        lw.increaseTabLevel();
        lw.println("m = lib_re.match(i)");
        lw.println("if (m):");
        lw.increaseTabLevel();
        lw.println("if (len(m.group(1))): lib_dirs.append(m.group(1))");
        lw.decreaseTabLevel();
        lw.println("else:");
        lw.increaseTabLevel();
        lw.println("sys.argv.append(i)");
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
        lw.decreaseTabLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createAll() throws IOException {
        File od = new File(BabelConfiguration.getInstance().getOutputDirectory());
        File setup = new File(od, "setup.py");
        FileWriter fw = null;
        od.mkdirs();
        try {
            fw = new FileWriter(setup);
            LanguageWriterForPython lw = new LanguageWriterForPython(new PrintWriter(fw));
            lw.printlnUnformatted("#! /usr/bin/env python");
            lw.println("# Build file for Python modules");
            lw.println("import sys");
            lw.println("from re import compile");
            lw.println("from distutils.core import setup, Extension");
            this.processArgs(lw);
            lw.println("setup(name='babel',");
            lw.increaseTabLevel();
            lw.println("include_dirs=inc_dirs,");
            this.writeList(lw, "headers", this.d_headers.iterator());
            this.writeList(lw, "packages", this.d_packages.iterator());
            lw.println("ext_modules = [");
            lw.increaseTabLevel();
            Iterator i = this.d_mod2csrc.keySet().iterator();
            while (i.hasNext()) {
                String module = (String)i.next();
                Set files = (Set)this.d_mod2csrc.get(module);
                lw.println("Extension('" + module + "',");
                lw.increaseTabLevel();
                lw.print("[");
                Iterator j = files.iterator();
                while (j.hasNext()) {
                    lw.print("\"" + j.next().toString() + "\"");
                    lw.println(j.hasNext() ? "," : "");
                }
                lw.println("],");
                lw.println("library_dirs=lib_dirs,");
                lw.print("libraries=[\"sidl\"])");
                lw.println(i.hasNext() ? "," : "");
                lw.decreaseTabLevel();
            }
            lw.decreaseTabLevel();
            lw.println("])");
            lw.decreaseTabLevel();
            Object var10_9 = null;
            if (null == fw) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null == fw) throw throwable;
            fw.close();
            throw throwable;
        }
        fw.close();
    }

    private Set getCSources(String module) {
        TreeSet result = (TreeSet)this.d_mod2csrc.get(module);
        if (null == result) {
            result = new TreeSet();
            this.d_mod2csrc.put(module, result);
        }
        return result;
    }

    private static String join(String dir, String file) {
        StringBuffer buf = new StringBuffer(dir.length() + file.length());
        String outputDir = BabelConfiguration.getInstance().getOutputDirectory();
        if (!".".equals(outputDir) && dir.startsWith(outputDir) && ((dir = dir.substring(outputDir.length())).startsWith(File.separator) || dir.startsWith("/"))) {
            dir = dir.substring(1);
        }
        if (File.separatorChar != '/') {
            dir = dir.replace(File.separatorChar, '/');
        }
        return buf.append(dir).append(file).toString();
    }

    public void newFile(SymbolID id, int type, String role, String dir, String name) {
        String module = id.getFullName();
        if ("PYMOD_HDRS".equals(role)) {
            this.d_headers.add(SetupGenerator.join(dir, name));
        } else if ("PYMOD_SRCS".equals(role)) {
            Set files = this.getCSources(module);
            files.add(SetupGenerator.join(dir, name));
        } else if ("PYTHONSRC".equals(role)) {
            if (11 != type) {
                this.d_pymodules.add(module + "_Impl");
            } else {
                this.d_pymodules.add(module);
            }
        } else if ("PYTHONADMIN".equals(role)) {
            this.d_packages.add(module);
        }
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("python");
        return result;
    }
}

