/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.config;

import gov.llnl.babel.config.InvalidConfiguration;
import gov.llnl.babel.config.Metadata;
import gov.llnl.babel.config.Profile;
import gov.llnl.babel.xml.ElementIterator;
import gov.llnl.babel.xml.XMLUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Configuration {
    private HashMap d_profiles = new HashMap();
    private Metadata d_metadata = null;

    public Set getLanguages() {
        return this.d_profiles.keySet();
    }

    public Set getProfileNames(String language) {
        HashMap profiles = (HashMap)this.d_profiles.get(language);
        return profiles == null ? null : profiles.keySet();
    }

    public Profile getProfile(String language, String profile_name) {
        HashMap profiles = (HashMap)this.d_profiles.get(language);
        return profiles == null ? null : profiles.get(profile_name);
    }

    public Map getConfiguration(String language, String profile_name) {
        Profile profile = this.getProfile(language, profile_name);
        return profile == null ? null : profile.getConfiguration();
    }

    public void setMetadataDescription(String URI2) throws IOException, SAXException {
        this.d_metadata = new Metadata(URI2);
    }

    public void setMetadataDescription(Metadata metadata) {
        this.d_metadata = metadata;
    }

    public void validateProfile(Profile profile) throws InvalidConfiguration {
        if (this.d_metadata != null) {
            String language = profile.getLanguage();
            Set valid_languages = this.d_metadata.getValidLanguages();
            if (!valid_languages.contains(language)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Language ");
                buffer.append("\"" + language + "\"");
                buffer.append(" is not supported (Supported languages:");
                this.appendSetStrings(valid_languages, buffer);
                buffer.append(")");
                throw new InvalidConfiguration(buffer.toString());
            }
            Map config = profile.getConfiguration();
            Set<Object> options = config == null ? new HashSet() : config.keySet();
            HashSet valid_options = this.d_metadata.getValidOptions(language);
            if (valid_options == null) {
                valid_options = new HashSet();
            }
            Iterator<Object> o = options.iterator();
            while (o.hasNext()) {
                String option = (String)o.next();
                if (!valid_options.contains(option)) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Option ");
                    buffer.append("\"" + option + "\"");
                    buffer.append(" is not supported (Supported options:");
                    this.appendSetStrings(valid_options, buffer);
                    buffer.append(")");
                    throw new InvalidConfiguration(buffer.toString());
                }
                String parameter = (String)config.get(option);
                Set valid_parameters = this.d_metadata.getValidOptionParameters(language, option);
                if (valid_parameters.contains(parameter)) continue;
                StringBuffer buffer = new StringBuffer();
                buffer.append("Parameter ");
                buffer.append("\"" + parameter + "\"");
                buffer.append(" is not supported for option ");
                buffer.append("\"" + option + "\"");
                buffer.append(" (Supported parameters:");
                this.appendSetStrings(valid_parameters, buffer);
                buffer.append(")");
                throw new InvalidConfiguration(buffer.toString());
            }
            Iterator o2 = valid_options.iterator();
            while (o2.hasNext()) {
                String valid = (String)o2.next();
                if (options.contains(valid)) continue;
                StringBuffer buffer = new StringBuffer();
                buffer.append("Option ");
                buffer.append("\"" + valid + "\"");
                buffer.append(" is not specified (Required options:");
                this.appendSetStrings(valid_options, buffer);
                buffer.append(")");
                throw new InvalidConfiguration(buffer.toString());
            }
        }
    }

    private void appendSetStrings(Set set, StringBuffer buffer) {
        if (set == null || set.isEmpty()) {
            buffer.append(" none");
        } else {
            Iterator i = set.iterator();
            while (i.hasNext()) {
                buffer.append(" \"" + (String)i.next() + "\"");
            }
        }
    }

    public void readConfiguration(String uri) throws IOException, InvalidConfiguration {
        Document document = null;
        try {
            document = XMLUtilities.parse(uri);
        }
        catch (SAXException ex) {
            throw new InvalidConfiguration("Error while parsing XML configuration file: " + ex.getMessage());
        }
        if (document == null) {
            throw new InvalidConfiguration("Empty XML configuration document");
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            throw new InvalidConfiguration("No root element in XML configuration document");
        }
        if (!"Configuration".equals(root.getTagName())) {
            throw new InvalidConfiguration("Incorrect root element in XML configuration document");
        }
        ElementIterator languages = new ElementIterator(root, "Language");
        while (languages.hasNext()) {
            HashMap<String, Profile> profile_map;
            Element language = (Element)languages.next();
            String language_name = language.getAttribute("name");
            HashMap<String, String> configuration = new HashMap<String, String>();
            Element option = XMLUtilities.lookupElement(language, "Options");
            if (option != null) {
                ElementIterator selections = new ElementIterator(option, "Selection");
                while (selections.hasNext()) {
                    Element selection = (Element)selections.next();
                    String option_name = selection.getAttribute("option");
                    String value_name = selection.getAttribute("value");
                    configuration.put(option_name, value_name);
                }
            }
            if ((profile_map = (HashMap<String, Profile>)this.d_profiles.get(language_name)) == null) {
                profile_map = new HashMap<String, Profile>();
            }
            ElementIterator profiles = new ElementIterator(language, "Profile");
            while (profiles.hasNext()) {
                Element comp;
                Element arch;
                Element profile = (Element)profiles.next();
                String profile_name = profile.getAttribute("name");
                Profile new_profile = new Profile(profile_name, language_name);
                new_profile.setConfiguration(configuration);
                Element desc = XMLUtilities.lookupElement(profile, "Description");
                if (desc != null) {
                    String summary = desc.getAttribute("summary");
                    String htmldescr = XMLUtilities.formatChildren(desc);
                    new_profile.setSummary(summary);
                    new_profile.setDescription(htmldescr);
                }
                if ((arch = XMLUtilities.lookupElement(profile, "Architecture")) != null) {
                    String cpu = arch.getAttribute("cpu");
                    String os = arch.getAttribute("os");
                    String release = arch.getAttribute("release");
                    new_profile.setCPU(cpu);
                    new_profile.setOS(os);
                    new_profile.setOSRelease(release);
                }
                if ((comp = XMLUtilities.lookupElement(profile, "Compiler")) != null) {
                    String compiler_name = comp.getAttribute("name");
                    String compiler_vers = comp.getAttribute("version");
                    new_profile.setCompilerName(compiler_name);
                    new_profile.setCompilerVersion(compiler_vers);
                }
                this.validateProfile(new_profile);
                profile_map.put(profile_name, new_profile);
            }
            this.d_profiles.put(language_name, profile_map);
        }
    }
}

