/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.xml;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.parsers.xml.DTDManager;
import gov.llnl.babel.parsers.xml.StringXML;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.xml.XMLUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolToDOM {
    private static final String EOL = "\n";
    private static final String INDENT = "   ";
    private Document d_document;
    private int d_indent;

    public static Document convert(Symbol symbol) {
        SymbolToDOM sym2dom = new SymbolToDOM(symbol);
        return sym2dom.getDocument();
    }

    public static String convertToString(Symbol symbol) {
        return XMLUtilities.getXMLString(SymbolToDOM.convert(symbol));
    }

    public SymbolToDOM(Symbol symbol) {
        DOMImplementation dom = XMLUtilities.createDOMImplementation();
        DocumentType doctype = dom.createDocumentType("Symbol", "-//CCA//SIDL Symbol DTD v1.1//EN", "SIDL.dtd");
        this.d_document = dom.createDocument(null, "Symbol", doctype);
        if (symbol != null) {
            this.d_indent = 0;
            Element docsymbol = this.d_document.getDocumentElement();
            switch (symbol.getSymbolType()) {
                case 12: {
                    this.convertClass((Class)symbol, docsymbol);
                    break;
                }
                case 11: {
                    this.convertEnumeration((Enumeration)symbol, docsymbol);
                    break;
                }
                case 13: {
                    this.convertInterface((Interface)symbol, docsymbol);
                    break;
                }
                case 14: {
                    this.convertPackage((Package)symbol, docsymbol);
                }
            }
            docsymbol.appendChild(this.d_document.createTextNode(EOL));
        }
    }

    public Document getDocument() {
        return this.d_document;
    }

    private void convertClass(Class cls, Node parent) {
        this.convertSymbolID(cls.getSymbolID(), parent);
        this.convertMetadata(cls.getMetadata(), parent);
        this.convertComment(cls.getComment(), parent);
        Element class_element = this.createElement("Class");
        class_element.setAttribute("abstract", String.valueOf(cls.isAbstract()));
        Element extends_element = this.createElement("Extends");
        if (cls.getParentClass() != null) {
            this.convertSymbolID(cls.getParentClass().getSymbolID(), extends_element);
        }
        this.appendChild(extends_element, class_element);
        Element implementsblock_element = this.createElement("ImplementsBlock");
        Collection parents = cls.getParentInterfaces(false);
        Iterator p = parents.iterator();
        while (p.hasNext()) {
            Interface i = (Interface)p.next();
            this.convertSymbolID(i.getSymbolID(), implementsblock_element);
        }
        this.appendChild(implementsblock_element, class_element);
        Element all_classes_element = this.createElement("AllParentClasses");
        Class parent_class = cls.getParentClass();
        while (parent_class != null) {
            this.convertSymbolID(parent_class.getSymbolID(), all_classes_element);
            parent_class = parent_class.getParentClass();
        }
        this.appendChild(all_classes_element, class_element);
        Element all_interfaces_element = this.createElement("AllParentInterfaces");
        Collection allparents = cls.getParentInterfaces(true);
        Iterator p2 = allparents.iterator();
        while (p2.hasNext()) {
            Interface i = (Interface)p2.next();
            this.convertSymbolID(i.getSymbolID(), all_interfaces_element);
        }
        this.appendChild(all_interfaces_element, class_element);
        Element methodblock_element = this.createElement("MethodsBlock");
        Iterator m = cls.getMethods(false).iterator();
        while (m.hasNext()) {
            this.convertMethod((Method)m.next(), methodblock_element);
        }
        this.appendChild(methodblock_element, class_element);
        this.appendChild(class_element, parent);
    }

    private void convertEnumeration(Enumeration e, Node parent) {
        this.convertSymbolID(e.getSymbolID(), parent);
        this.convertMetadata(e.getMetadata(), parent);
        this.convertComment(e.getComment(), parent);
        Element enumeration_element = this.createElement("Enumeration");
        Iterator i = e.getIterator();
        while (i.hasNext()) {
            String n = (String)i.next();
            Element enumerator_element = this.createElement("Enumerator");
            enumerator_element.setAttribute("name", n);
            enumerator_element.setAttribute("value", String.valueOf(e.getEnumeratorValue(n)));
            enumerator_element.setAttribute("fromuser", String.valueOf(e.definedByUser(n)));
            Comment ecmt = e.getEnumeratorComment(n);
            if (ecmt != null && !ecmt.isEmpty()) {
                this.convertComment(ecmt, enumerator_element);
            }
            this.appendChild(enumerator_element, enumeration_element);
        }
        this.appendChild(enumeration_element, parent);
    }

    private void convertInterface(Interface ifc, Node parent) {
        this.convertSymbolID(ifc.getSymbolID(), parent);
        this.convertMetadata(ifc.getMetadata(), parent);
        this.convertComment(ifc.getComment(), parent);
        Element interface_element = this.createElement("Interface");
        Element extendsblock_element = this.createElement("ExtendsBlock");
        Collection parents = ifc.getParentInterfaces(false);
        Iterator p = parents.iterator();
        while (p.hasNext()) {
            Interface i = (Interface)p.next();
            this.convertSymbolID(i.getSymbolID(), extendsblock_element);
        }
        this.appendChild(extendsblock_element, interface_element);
        Element all_interfaces_element = this.createElement("AllParentInterfaces");
        Collection allparents = ifc.getParentInterfaces(true);
        Iterator p2 = allparents.iterator();
        while (p2.hasNext()) {
            Interface i = (Interface)p2.next();
            this.convertSymbolID(i.getSymbolID(), all_interfaces_element);
        }
        this.appendChild(all_interfaces_element, interface_element);
        Element methodblock_element = this.createElement("MethodsBlock");
        Iterator m = ifc.getMethods(false).iterator();
        while (m.hasNext()) {
            this.convertMethod((Method)m.next(), methodblock_element);
        }
        this.appendChild(methodblock_element, interface_element);
        this.appendChild(interface_element, parent);
    }

    private void convertPackage(Package p, Node parent) {
        this.convertSymbolID(p.getSymbolID(), parent);
        this.convertMetadata(p.getMetadata(), parent);
        this.convertComment(p.getComment(), parent);
        Element package_element = this.createElement("Package");
        package_element.setAttribute("final", p.getFinal() ? "true" : "false");
        Collection children = p.getOrderedSymbolReferences();
        Map map = p.getSymbols();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            SymbolID entry = (SymbolID)i.next();
            Integer intValue = (Integer)map.get(entry);
            Element packagesymbol_element = this.createElement("PackageSymbol");
            packagesymbol_element.setAttribute("name", entry.getShortName());
            packagesymbol_element.setAttribute("type", StringXML.toSymbolXML(intValue));
            packagesymbol_element.setAttribute("version", entry.getVersion().getVersionString());
            this.appendChild(packagesymbol_element, package_element);
        }
        this.appendChild(package_element, parent);
    }

    private void convertComment(Comment c, Node parent) {
        Element comment_element = null;
        if (c.isEmpty()) {
            comment_element = this.createElement("Comment");
        } else {
            String[] lines = c.getComment();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<Comment>");
            int i = 0;
            while (i < lines.length) {
                buffer.append(EOL);
                buffer.append(lines[i]);
                ++i;
            }
            buffer.append("</Comment>");
            Document document = XMLUtilities.validateXML("-//CCA//SIDL Comment DTD v1.0//EN", "comment.dtd", DTDManager.getInstance(), "Comment", buffer.toString());
            if (document != null) {
                Element root = document.getDocumentElement();
                comment_element = (Element)XMLUtilities.cloneDOM(root, this.d_document);
                ++this.d_indent;
            }
            if (comment_element == null) {
                comment_element = this.createElement("Comment");
                Text text = this.d_document.createTextNode("");
                int i2 = 0;
                while (i2 < lines.length) {
                    text.appendData(EOL);
                    text.appendData(lines[i2]);
                    ++i2;
                }
                comment_element.appendChild(text);
            }
        }
        this.appendChild(comment_element, parent);
    }

    private void convertMetadata(Metadata m, Node parent) {
        Element metadata_element = this.createElement("Metadata");
        if (BabelConfiguration.getInstance().suppressTimestamps()) {
            metadata_element.setAttribute("date", "20010101 00:00:00 GMT");
        } else {
            metadata_element.setAttribute("date", m.getDateAsString());
        }
        Set entries = m.getMetadataDatabase().entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Element data_element = this.createElement("MetadataEntry");
            data_element.setAttribute("key", (String)entry.getKey());
            data_element.setAttribute("value", (String)entry.getValue());
            this.appendChild(data_element, metadata_element);
        }
        this.appendChild(metadata_element, parent);
    }

    private void convertMethod(Method m, Node parent) {
        Element method_element = this.createElement("Method");
        method_element.setAttribute("shortname", m.getShortMethodName());
        method_element.setAttribute("extension", m.getNameExtension());
        method_element.setAttribute("copy", String.valueOf(m.isReturnCopy()));
        method_element.setAttribute("definition", StringXML.toDefXML(m.getDefinitionModifier()));
        method_element.setAttribute("communication", StringXML.toComXML(m.getCommunicationModifier()));
        this.convertComment(m.getComment(), method_element);
        this.convertType(m.getReturnType(), method_element);
        Element arglist_element = this.createElement("ArgumentList");
        ArrayList args = m.getArgumentList();
        int a = 0;
        while (a < args.size()) {
            this.convertArgument((Argument)args.get(a), arglist_element);
            ++a;
        }
        this.appendChild(arglist_element, method_element);
        Element throwslist_element = this.createElement("ThrowsList");
        Iterator t = m.getThrows().iterator();
        while (t.hasNext()) {
            this.convertSymbolID((SymbolID)t.next(), throwslist_element);
        }
        this.appendChild(throwslist_element, method_element);
        this.appendChild(method_element, parent);
    }

    private void convertArgument(Argument arg, Node parent) {
        Element arg_element = this.createElement("Argument");
        arg_element.setAttribute("copy", String.valueOf(arg.isCopy()));
        arg_element.setAttribute("mode", StringXML.toModeXML(arg.getMode()));
        arg_element.setAttribute("name", arg.getFormalName());
        this.convertType(arg.getType(), arg_element);
        this.appendChild(arg_element, parent);
    }

    private void convertType(Type type, Node parent) {
        Element type_element = this.createElement("Type");
        int typeid = type.getType();
        type_element.setAttribute("type", StringXML.toTypeXML(typeid));
        if (typeid == 15) {
            this.convertSymbolID(type.getSymbolID(), type_element);
        } else if (typeid == 16) {
            Element array_element = this.createElement("Array");
            array_element.setAttribute("dim", String.valueOf(type.getArrayDimension()));
            array_element.setAttribute("order", StringXML.toOrderXML(type.getArrayOrder()));
            this.convertType(type.getArrayType(), array_element);
            this.appendChild(array_element, type_element);
        }
        this.appendChild(type_element, parent);
    }

    private void convertSymbolID(SymbolID id, Node parent) {
        Element symbol_element = this.createElement("SymbolName");
        symbol_element.setAttribute("name", id.getFullName());
        symbol_element.setAttribute("version", id.getVersion().getVersionString());
        this.appendChild(symbol_element, parent);
    }

    private String getIndentString() {
        StringBuffer indent = new StringBuffer();
        indent.append(EOL);
        int i = 0;
        while (i < this.d_indent) {
            indent.append(INDENT);
            ++i;
        }
        return indent.toString();
    }

    private Element createElement(String name) {
        ++this.d_indent;
        return this.d_document.createElement(name);
    }

    private void appendChild(Element child, Node parent) {
        String indent = this.getIndentString();
        parent.appendChild(this.d_document.createTextNode(indent));
        if (child.hasChildNodes()) {
            child.appendChild(this.d_document.createTextNode(indent));
        }
        parent.appendChild(child);
        --this.d_indent;
    }

    static {
        EOL = EOL;
        INDENT = INDENT;
    }
}

