/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Method
implements Cloneable {
    public static final int NORMAL = 0;
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int STATIC = 3;
    public static final int LOCAL = 1;
    public static final int ONEWAY = 2;
    public static final String[] s_def_mod;
    public static final String[] s_comm_mod;
    private ArrayList d_arguments = new ArrayList();
    private Comment d_comment = null;
    private int d_communication_modifier = 0;
    private int d_definition_modifier = 0;
    private String d_short_name = null;
    private String d_extension = null;
    private String d_long_name = null;
    private HashSet d_references = new HashSet();
    private HashSet d_basicarrays = new HashSet();
    private boolean d_return_copy = false;
    private Type d_return_type = null;
    private HashSet d_throws = new HashSet();

    public Method cloneMethod() {
        Method m = null;
        try {
            m = (Method)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
        return m;
    }

    public void addArgument(Argument arg) {
        this.d_arguments.add(arg);
        this.addTypeReferences(arg.getType());
    }

    public ArrayList getArgumentList() {
        return this.d_arguments;
    }

    public void setComment(Comment comment) {
        this.d_comment = comment;
    }

    public Comment getComment() {
        return this.d_comment;
    }

    public void setCommunicationModifier(int modifier) {
        this.d_communication_modifier = modifier;
    }

    public int getCommunicationModifier() {
        return this.d_communication_modifier;
    }

    public String getCommunicationModifierString() {
        return s_comm_mod[this.d_communication_modifier];
    }

    public void setDefinitionModifier(int modifier) {
        this.d_definition_modifier = modifier;
    }

    public int getDefinitionModifier() {
        return this.d_definition_modifier;
    }

    public String getDefinitionModifier(boolean is_interface) {
        String mod = null;
        if (!is_interface || this.d_definition_modifier == 0) {
            mod = s_def_mod[this.d_definition_modifier];
        }
        return mod;
    }

    public boolean isAbstract() {
        return this.d_definition_modifier == 1;
    }

    public boolean isFinal() {
        return this.d_definition_modifier == 2;
    }

    public boolean isStatic() {
        return this.d_definition_modifier == 3;
    }

    public boolean hasArrayOrderSpec() {
        if (this.d_return_type.hasArrayOrderSpec()) {
            return true;
        }
        Iterator i = this.d_arguments.iterator();
        while (i.hasNext()) {
            if (!((Argument)i.next()).hasArrayOrderSpec()) continue;
            return true;
        }
        return false;
    }

    public void setMethodName(String shortName, String extension) {
        this.d_short_name = shortName;
        this.d_extension = extension;
        this.d_long_name = shortName + extension;
    }

    public void setMethodName(String shortName) {
        this.setMethodName(shortName, "");
    }

    public String getShortMethodName() {
        return this.d_short_name;
    }

    public String getNameExtension() {
        return this.d_extension;
    }

    public String getLongMethodName() {
        return this.d_long_name;
    }

    public void setReturnCopy(boolean copy) {
        this.d_return_copy = copy;
    }

    public boolean isReturnCopy() {
        return this.d_return_copy;
    }

    public void setReturnType(Type type) {
        this.d_return_type = type;
        this.addTypeReferences(type);
    }

    public Type getReturnType() {
        return this.d_return_type;
    }

    public void addThrows(SymbolID id) {
        this.d_throws.add(id);
        this.d_references.add(id);
    }

    public Set getThrows() {
        return this.d_throws;
    }

    public Set getSymbolReferences() {
        return this.d_references;
    }

    public Set getBasicArrays() {
        return this.d_basicarrays;
    }

    public String getReturnType(String parent_pkg) {
        StringBuffer result = new StringBuffer();
        String rtype = this.d_return_type.getTypeString();
        if (parent_pkg != null) {
            result.append(SymbolUtilities.getSymbolName(rtype, parent_pkg));
        } else {
            result.append(rtype);
        }
        return result.toString();
    }

    public String getSignaturePreface(boolean is_interface, String parent_pkg) {
        StringBuffer preface = new StringBuffer();
        String dmod = this.getDefinitionModifier(is_interface);
        if (dmod != null) {
            preface.append(dmod + " ");
        }
        if (this.d_return_copy) {
            preface.append("copy ");
        }
        preface.append(this.getReturnType(parent_pkg));
        preface.append(" ");
        preface.append(this.d_short_name);
        if (this.d_extension != null && this.d_extension != "") {
            preface.append(" [");
            preface.append(this.d_extension);
            preface.append("] ");
        }
        return preface.toString();
    }

    public String getSignature(boolean is_interface, String parent_pkg) {
        StringBuffer signature = new StringBuffer();
        signature.append(this.getSignaturePreface(is_interface, parent_pkg));
        signature.append("(");
        Iterator a = this.d_arguments.iterator();
        while (a.hasNext()) {
            signature.append(((Argument)a.next()).getArgumentString());
            if (!a.hasNext()) continue;
            signature.append(", ");
        }
        signature.append(") " + this.getCommunicationModifierString());
        if (!this.d_throws.isEmpty()) {
            signature.append(" throws ");
            Iterator t = this.d_throws.iterator();
            while (t.hasNext()) {
                SymbolID sid = (SymbolID)t.next();
                String fname = sid.getFullName();
                if (parent_pkg != null) {
                    signature.append(SymbolUtilities.getSymbolName(fname, parent_pkg));
                } else {
                    signature.append(fname);
                }
                if (!t.hasNext()) continue;
                signature.append(", ");
            }
        }
        return signature.toString();
    }

    public String getSignature() {
        return this.getSignature(false, null);
    }

    public boolean sameSignature(Method m) {
        if (this.d_communication_modifier != m.d_communication_modifier) {
            return false;
        }
        if (!this.d_short_name.equals(m.d_short_name)) {
            return false;
        }
        if (!this.d_extension.equals(m.d_extension)) {
            return false;
        }
        if (this.d_return_copy != m.d_return_copy) {
            return false;
        }
        if (this.d_return_type == null ? m.d_return_type != null : !this.d_return_type.equals(m.d_return_type)) {
            return false;
        }
        if (this.d_throws.size() != m.d_throws.size()) {
            return false;
        }
        Iterator i = this.d_throws.iterator();
        while (i.hasNext()) {
            if (m.d_throws.contains(i.next())) continue;
            return false;
        }
        return this.sameArguments(m);
    }

    public boolean sameBaseSignature(Method m) {
        if (!this.d_short_name.equals(m.d_short_name)) {
            return false;
        }
        return this.sameArguments(m);
    }

    private boolean sameArguments(Method m) {
        int size = this.d_arguments.size();
        if (size != m.d_arguments.size()) {
            return false;
        }
        int a = 0;
        while (a < size) {
            if (!this.d_arguments.get(a).equals(m.d_arguments.get(a))) {
                return false;
            }
            ++a;
        }
        return true;
    }

    private void addTypeReferences(Type type) {
        if (type != null) {
            if (type.getType() == 15) {
                this.d_references.add(type.getSymbolID());
            } else if (type.getType() == 16) {
                type = type.getArrayType();
                this.addTypeReferences(type);
                if (type.getType() >= 1 && type.getType() <= 10) {
                    Version v = new Version();
                    v.appendVersionNumber(0);
                    this.d_basicarrays.add(new SymbolID("SIDL." + type.getTypeString(), v));
                }
            }
        }
    }

    static {
        NORMAL = 0;
        ABSTRACT = 1;
        FINAL = 2;
        STATIC = 3;
        LOCAL = 1;
        ONEWAY = 2;
        s_def_mod = new String[]{"", "abstract", "final", "static"};
        s_comm_mod = new String[]{"", "local", "oneway"};
    }
}

