/*
 * Decompiled with CFR 0.152.
 */
package SIDL;

import SIDL.Sfun;
import gov.llnl.sidl.BaseArray;
import gov.llnl.sidl.BaseClass;
import java.io.Serializable;

public class DoubleComplex
implements Serializable,
Cloneable {
    private double re;
    private double im;
    static final long serialVersionUID = -633126172485117692L;
    public static String suffix;
    private static final long negZeroBits;

    public DoubleComplex(DoubleComplex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public DoubleComplex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public DoubleComplex(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public DoubleComplex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    private boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean equals(DoubleComplex z) {
        if (this.isNaN() && z.isNaN()) {
            return true;
        }
        return this.re == z.re && this.im == z.im;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DoubleComplex) {
            return this.equals((DoubleComplex)obj);
        }
        return false;
    }

    public int hashCode() {
        long re_bits = Double.doubleToLongBits(this.re);
        long im_bits = Double.doubleToLongBits(this.im);
        return (int)(re_bits ^ im_bits ^ (re_bits ^ im_bits) >> 32);
    }

    public double real() {
        return this.re;
    }

    public double imag() {
        return this.im;
    }

    public void set(double real, double imag) {
        this.re = real;
        this.im = imag;
    }

    public static double real(DoubleComplex z) {
        return z.re;
    }

    public static double imag(DoubleComplex z) {
        return z.im;
    }

    public static DoubleComplex negative(DoubleComplex z) {
        return new DoubleComplex(-z.re, -z.im);
    }

    public static DoubleComplex conjugate(DoubleComplex z) {
        return new DoubleComplex(z.re, -z.im);
    }

    public static DoubleComplex plus(DoubleComplex x, DoubleComplex y) {
        return new DoubleComplex(x.re + y.re, x.im + y.im);
    }

    public static DoubleComplex plus(DoubleComplex x, double y) {
        return new DoubleComplex(x.re + y, x.im);
    }

    public static DoubleComplex plus(double x, DoubleComplex y) {
        return new DoubleComplex(x + y.re, y.im);
    }

    public DoubleComplex plus(DoubleComplex y) {
        return new DoubleComplex(this.re + y.re, this.im + y.im);
    }

    public DoubleComplex plus(double y) {
        return new DoubleComplex(this.re + y, this.im);
    }

    public DoubleComplex plusReverse(double x) {
        return new DoubleComplex(this.re + x, this.im);
    }

    public static DoubleComplex minus(DoubleComplex x, DoubleComplex y) {
        return new DoubleComplex(x.re - y.re, x.im - y.im);
    }

    public static DoubleComplex minus(DoubleComplex x, double y) {
        return new DoubleComplex(x.re - y, x.im);
    }

    public static DoubleComplex minus(double x, DoubleComplex y) {
        return new DoubleComplex(x - y.re, -y.im);
    }

    public DoubleComplex minus(DoubleComplex y) {
        return new DoubleComplex(this.re - y.re, this.im - y.im);
    }

    public DoubleComplex minus(double y) {
        return new DoubleComplex(this.re - y, this.im);
    }

    public DoubleComplex minusReverse(double x) {
        return new DoubleComplex(x - this.re, -this.im);
    }

    public static DoubleComplex times(DoubleComplex x, DoubleComplex y) {
        DoubleComplex t = new DoubleComplex(x.re * y.re - x.im * y.im, x.re * y.im + x.im * y.re);
        if (Double.isNaN(t.re) && Double.isNaN(t.im)) {
            DoubleComplex.timesNaN(x, y, t);
        }
        return t;
    }

    private static double copysign(double a, double b) {
        double abs = Math.abs(a);
        return b < 0.0 ? -abs : abs;
    }

    private static void timesNaN(DoubleComplex x, DoubleComplex y, DoubleComplex t) {
        boolean recalc = false;
        double a = x.re;
        double b = x.im;
        double c = y.re;
        double d = y.im;
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            a = DoubleComplex.copysign(Double.isInfinite(a) ? 1.0 : 0.0, a);
            b = DoubleComplex.copysign(Double.isInfinite(b) ? 1.0 : 0.0, b);
            if (Double.isNaN(c)) {
                c = DoubleComplex.copysign(0.0, c);
            }
            if (Double.isNaN(d)) {
                d = DoubleComplex.copysign(0.0, d);
            }
            recalc = true;
        }
        if (Double.isInfinite(c) || Double.isInfinite(d)) {
            a = DoubleComplex.copysign(Double.isInfinite(c) ? 1.0 : 0.0, c);
            b = DoubleComplex.copysign(Double.isInfinite(d) ? 1.0 : 0.0, d);
            if (Double.isNaN(a)) {
                a = DoubleComplex.copysign(0.0, a);
            }
            if (Double.isNaN(b)) {
                b = DoubleComplex.copysign(0.0, b);
            }
            recalc = true;
        }
        if (!recalc && (Double.isInfinite(a * c) || Double.isInfinite(b * d) || Double.isInfinite(a * d) || Double.isInfinite(b * c))) {
            if (Double.isNaN(a)) {
                a = DoubleComplex.copysign(0.0, a);
            }
            if (Double.isNaN(b)) {
                b = DoubleComplex.copysign(0.0, b);
            }
            if (Double.isNaN(c)) {
                c = DoubleComplex.copysign(0.0, c);
            }
            if (Double.isNaN(d)) {
                d = DoubleComplex.copysign(0.0, d);
            }
            recalc = true;
        }
        if (recalc) {
            t.re = Double.POSITIVE_INFINITY * (a * c - b * d);
            t.im = Double.POSITIVE_INFINITY * (a * d + b * c);
        }
    }

    public static DoubleComplex times(DoubleComplex x, double y) {
        return new DoubleComplex(x.re * y, x.im * y);
    }

    public static DoubleComplex times(double x, DoubleComplex y) {
        return new DoubleComplex(x * y.re, x * y.im);
    }

    public DoubleComplex times(DoubleComplex y) {
        return DoubleComplex.times(this, y);
    }

    public DoubleComplex times(double y) {
        return new DoubleComplex(this.re * y, this.im * y);
    }

    public DoubleComplex timesReverse(double x) {
        return new DoubleComplex(x * this.re, x * this.im);
    }

    private static boolean isFinite(double x) {
        return !Double.isInfinite(x) && !Double.isNaN(x);
    }

    public static DoubleComplex over(DoubleComplex x, DoubleComplex y) {
        double a = x.re;
        double b = x.im;
        double c = y.re;
        double d = y.im;
        double scale = Math.max(Math.abs(c), Math.abs(d));
        boolean isScaleFinite = DoubleComplex.isFinite(scale);
        if (isScaleFinite) {
            c /= scale;
            d /= scale;
        }
        double den = c * c + d * d;
        DoubleComplex z = new DoubleComplex((a * c + b * d) / den, (b * c - a * d) / den);
        if (isScaleFinite) {
            z.re /= scale;
            z.im /= scale;
        }
        if (Double.isNaN(z.re) && Double.isNaN(z.im)) {
            if (!(den != 0.0 || Double.isNaN(a) && Double.isNaN(b))) {
                double s = DoubleComplex.copysign(Double.POSITIVE_INFINITY, c);
                z.re = s * a;
                z.im = s * b;
            } else if ((Double.isInfinite(a) || Double.isInfinite(b)) && DoubleComplex.isFinite(c) && DoubleComplex.isFinite(d)) {
                a = DoubleComplex.copysign(Double.isInfinite(a) ? 1.0 : 0.0, a);
                b = DoubleComplex.copysign(Double.isInfinite(b) ? 1.0 : 0.0, b);
                z.re = Double.POSITIVE_INFINITY * (a * c + b * d);
                z.im = Double.POSITIVE_INFINITY * (b * c - a * d);
            } else if (Double.isInfinite(scale) && DoubleComplex.isFinite(a) && DoubleComplex.isFinite(b)) {
                c = DoubleComplex.copysign(Double.isInfinite(c) ? 1.0 : 0.0, c);
                d = DoubleComplex.copysign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                z.re = 0.0 * (a * c + b * d);
                z.im = 0.0 * (b * c - a * d);
            }
        }
        return z;
    }

    public static DoubleComplex over(DoubleComplex x, double y) {
        return new DoubleComplex(x.re / y, x.im / y);
    }

    public static DoubleComplex over(double x, DoubleComplex y) {
        return y.overReverse(x);
    }

    public DoubleComplex over(DoubleComplex y) {
        return DoubleComplex.over(this, y);
    }

    public DoubleComplex over(double y) {
        return DoubleComplex.over(this, y);
    }

    public DoubleComplex overReverse(double x) {
        DoubleComplex z;
        if (Math.abs(this.re) > Math.abs(this.im)) {
            double t = this.im / this.re;
            double den = this.re + this.im * t;
            z = new DoubleComplex(x / den, -x * t / den);
        } else {
            double t = this.re / this.im;
            double den = this.im + this.re * t;
            z = new DoubleComplex(x * t / den, -x / den);
        }
        return z;
    }

    public static double abs(DoubleComplex z) {
        double x = Math.abs(z.re);
        double y = Math.abs(z.im);
        if (Double.isInfinite(x) || Double.isInfinite(y)) {
            return Double.POSITIVE_INFINITY;
        }
        if (x + y == 0.0) {
            return 0.0;
        }
        if (x > y) {
            return x * Math.sqrt(1.0 + (y /= x) * y);
        }
        return y * Math.sqrt((x /= y) * x + 1.0);
    }

    public static double argument(DoubleComplex z) {
        return Math.atan2(z.im, z.re);
    }

    public static DoubleComplex sqrt(DoubleComplex z) {
        DoubleComplex result = new DoubleComplex();
        if (Double.isInfinite(z.im)) {
            result.re = Double.POSITIVE_INFINITY;
            result.im = z.im;
        } else if (Double.isNaN(z.re)) {
            result.im = Double.NaN;
            result.re = Double.NaN;
        } else if (Double.isNaN(z.im)) {
            if (Double.isInfinite(z.re)) {
                if (z.re > 0.0) {
                    result.re = z.re;
                    result.im = z.im;
                } else {
                    result.re = z.im;
                    result.im = Double.POSITIVE_INFINITY;
                }
            } else {
                result.im = Double.NaN;
                result.re = Double.NaN;
            }
        } else {
            double t = DoubleComplex.abs(z);
            if (Math.abs(z.re) <= Math.abs(z.im)) {
                result.re = Math.sqrt(0.5 * (t + z.re));
                result.im = Math.sqrt(0.5 * (t - z.re));
            } else if (z.re > 0.0) {
                result.re = t + z.re;
                result.im = Math.abs(z.im) * Math.sqrt(0.5 / result.re);
                result.re = Math.sqrt(0.5 * result.re);
            } else {
                result.im = t - z.re;
                result.re = Math.abs(z.im) * Math.sqrt(0.5 / result.im);
                result.im = Math.sqrt(0.5 * result.im);
            }
            if (z.im < 0.0) {
                result.im = -result.im;
            }
        }
        return result;
    }

    public static DoubleComplex exp(DoubleComplex z) {
        DoubleComplex result = new DoubleComplex();
        double r = Math.exp(z.re);
        double cosa = Math.cos(z.im);
        double sina = Math.sin(z.im);
        if (Double.isInfinite(z.im) || Double.isNaN(z.im) || Math.abs(cosa) > 1.0) {
            sina = Double.NaN;
            cosa = Double.NaN;
        }
        if (Double.isInfinite(z.re) || Double.isInfinite(r)) {
            if (z.re < 0.0) {
                r = 0.0;
                if (Double.isInfinite(z.im) || Double.isNaN(z.im)) {
                    sina = 0.0;
                    cosa = 0.0;
                } else {
                    cosa /= Double.POSITIVE_INFINITY;
                    sina /= Double.POSITIVE_INFINITY;
                }
            } else {
                r = z.re;
                if (Double.isNaN(z.im)) {
                    cosa = 1.0;
                }
            }
        }
        if (z.im == 0.0) {
            result.re = r;
            result.im = z.im;
        } else {
            result.re = r * cosa;
            result.im = r * sina;
        }
        return result;
    }

    public static DoubleComplex log(DoubleComplex z) {
        DoubleComplex result = new DoubleComplex();
        if (Double.isNaN(z.re)) {
            result.re = result.im = z.re;
            if (Double.isInfinite(z.im)) {
                result.re = Double.POSITIVE_INFINITY;
            }
        } else if (Double.isNaN(z.im)) {
            result.re = result.im = z.im;
            if (Double.isInfinite(z.re)) {
                result.re = Double.POSITIVE_INFINITY;
            }
        } else {
            result.re = Math.log(DoubleComplex.abs(z));
            result.im = DoubleComplex.argument(z);
        }
        return result;
    }

    public static DoubleComplex sin(DoubleComplex z) {
        DoubleComplex iz = new DoubleComplex(-z.im, z.re);
        DoubleComplex s = DoubleComplex.sinh(iz);
        double re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static DoubleComplex cos(DoubleComplex z) {
        return DoubleComplex.cosh(new DoubleComplex(-z.im, z.re));
    }

    public static DoubleComplex tan(DoubleComplex z) {
        DoubleComplex iz = new DoubleComplex(-z.im, z.re);
        DoubleComplex s = DoubleComplex.tanh(iz);
        double re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static DoubleComplex asin(DoubleComplex z) {
        DoubleComplex result = new DoubleComplex();
        double r = DoubleComplex.abs(z);
        if (Double.isInfinite(r)) {
            boolean infiniteX = Double.isInfinite(z.re);
            boolean infiniteY = Double.isInfinite(z.im);
            if (infiniteX) {
                double pi2 = 1.5707963267948966;
                double d = result.re = z.re > 0.0 ? pi2 : -pi2;
                if (infiniteY) {
                    result.re /= 2.0;
                }
            } else if (infiniteY) {
                result.re = z.re / Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(z.im)) {
                result.im = -z.re;
                result.re = z.im;
            } else {
                result.im = z.im * Double.POSITIVE_INFINITY;
            }
            return result;
        }
        if (Double.isNaN(r)) {
            result.im = Double.NaN;
            result.re = Double.NaN;
            if (z.re == 0.0) {
                result.re = z.re;
            }
        } else if (r < 2.58095E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if (z.re == 0.0) {
            result.re = 0.0;
            result.im = Sfun.asinh(z.im);
        } else if (r <= 0.1) {
            DoubleComplex z2 = DoubleComplex.times(z, z);
            int i = 1;
            while (i <= 8) {
                double twoi = 2 * (8 - i) + 1;
                result = DoubleComplex.times(DoubleComplex.times(result, z2), twoi / (twoi + 1.0));
                result.re += 1.0 / twoi;
                ++i;
            }
            result = result.times(z);
        } else {
            DoubleComplex w = z.im < 0.0 ? DoubleComplex.negative(z) : z;
            DoubleComplex sqzp1 = DoubleComplex.sqrt(DoubleComplex.plus(w, 1.0));
            if (sqzp1.im < 0.0) {
                sqzp1 = DoubleComplex.negative(sqzp1);
            }
            DoubleComplex sqzm1 = DoubleComplex.sqrt(DoubleComplex.minus(w, 1.0));
            result = DoubleComplex.log(DoubleComplex.plus(w, DoubleComplex.times(sqzp1, sqzm1)));
            double rx = result.re;
            result.re = 1.5707963267948966 + result.im;
            result.im = -rx;
        }
        if (result.re > 1.5707963267948966) {
            result.re = Math.PI - result.re;
            result.im = -result.im;
        }
        if (result.re < -1.5707963267948966) {
            result.re = -Math.PI - result.re;
            result.im = -result.im;
        }
        if (z.im < 0.0) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    public static DoubleComplex acos(DoubleComplex z) {
        DoubleComplex result = new DoubleComplex();
        double r = DoubleComplex.abs(z);
        if (Double.isInfinite(z.re) && Double.isNaN(z.im)) {
            result.re = Double.NaN;
            result.im = Double.NEGATIVE_INFINITY;
        } else if (Double.isInfinite(r)) {
            result.re = Math.atan2(Math.abs(z.im), z.re);
            result.im = z.im * Double.NEGATIVE_INFINITY;
        } else if (r == 0.0) {
            result.re = 1.5707963267948966;
            result.im = -z.im;
        } else {
            result = DoubleComplex.minus(1.5707963267948966, DoubleComplex.asin(z));
        }
        return result;
    }

    public static DoubleComplex atan(DoubleComplex z) {
        DoubleComplex result = new DoubleComplex();
        double r = DoubleComplex.abs(z);
        if (Double.isInfinite(r)) {
            double pi2 = 1.5707963267948966;
            double im = Double.isNaN(z.im) ? 0.0 : z.im;
            result.re = z.re < 0.0 ? -pi2 : pi2;
            result.im = (double)(im < 0.0 ? -1 : 1) / Double.POSITIVE_INFINITY;
            if (Double.isNaN(z.re)) {
                result.re = z.re;
            }
        } else if (Double.isNaN(r)) {
            result.im = Double.NaN;
            result.re = Double.NaN;
            if (z.im == 0.0) {
                result.im = z.im;
            }
        } else if (r < 1.82501E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if (r < 0.1) {
            DoubleComplex z2 = DoubleComplex.times(z, z);
            int k = 0;
            while (k < 17) {
                DoubleComplex temp = DoubleComplex.times(z2, result);
                int twoi = 2 * (17 - k) - 1;
                result.re = 1.0 / (double)twoi - temp.re;
                result.im = -temp.im;
                ++k;
            }
            result = result.times(z);
        } else if (r < 9.0072E15) {
            double r2 = r * r;
            result.re = 0.5 * Math.atan2(2.0 * z.re, 1.0 - r2);
            result.im = 0.25 * Math.log((r2 + 2.0 * z.im + 1.0) / (r2 - 2.0 * z.im + 1.0));
        } else {
            result.re = z.re < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return result;
    }

    public static DoubleComplex sinh(DoubleComplex z) {
        DoubleComplex result;
        double coshx = Sfun.cosh(z.re);
        double sinhx = Sfun.sinh(z.re);
        double cosy = Math.cos(z.im);
        double siny = Math.sin(z.im);
        boolean infiniteX = Double.isInfinite(coshx);
        boolean infiniteY = Double.isInfinite(z.im);
        if (z.im == 0.0) {
            result = new DoubleComplex(Sfun.sinh(z.re));
        } else {
            result = new DoubleComplex(sinhx * cosy, coshx * siny);
            if (infiniteY) {
                result.im = Double.NaN;
                if (z.re == 0.0) {
                    result.re = 0.0;
                }
            }
            if (infiniteX) {
                result.re = z.re * cosy;
                result.im = z.re * siny;
                if (z.im == 0.0) {
                    result.im = 0.0;
                }
                if (infiniteY) {
                    result.re = z.im;
                }
            }
        }
        return result;
    }

    public static DoubleComplex cosh(DoubleComplex z) {
        if (z.im == 0.0) {
            return new DoubleComplex(Sfun.cosh(z.re));
        }
        double coshx = Sfun.cosh(z.re);
        double sinhx = Sfun.sinh(z.re);
        double cosy = Math.cos(z.im);
        double siny = Math.sin(z.im);
        boolean infiniteX = Double.isInfinite(coshx);
        boolean infiniteY = Double.isInfinite(z.im);
        DoubleComplex result = new DoubleComplex(coshx * cosy, sinhx * siny);
        if (infiniteY) {
            result.re = Double.NaN;
        }
        if (z.re == 0.0) {
            result.im = 0.0;
        } else if (infiniteX) {
            result.re = z.re * cosy;
            result.im = z.re * siny;
            if (z.im == 0.0) {
                result.im = 0.0;
            }
            if (Double.isNaN(z.im)) {
                result.re = z.re;
            } else if (infiniteY) {
                result.re = z.im;
            }
        }
        return result;
    }

    public static DoubleComplex tanh(DoubleComplex z) {
        double sinh2x = Sfun.sinh(2.0 * z.re);
        if (z.im == 0.0) {
            return new DoubleComplex(Sfun.tanh(z.re));
        }
        if (sinh2x == 0.0) {
            return new DoubleComplex(0.0, Math.tan(z.im));
        }
        double cosh2x = Sfun.cosh(2.0 * z.re);
        double cos2y = Math.cos(2.0 * z.im);
        double sin2y = Math.sin(2.0 * z.im);
        boolean infiniteX = Double.isInfinite(cosh2x);
        if (Double.isInfinite(z.im) || Double.isNaN(z.im)) {
            sin2y = Double.NaN;
            cos2y = Double.NaN;
        }
        if (infiniteX) {
            return new DoubleComplex(z.re > 0.0 ? 1.0 : -1.0);
        }
        double den = cosh2x + cos2y;
        return new DoubleComplex(sinh2x / den, sin2y / den);
    }

    public static DoubleComplex pow(DoubleComplex z, double x) {
        double absz = DoubleComplex.abs(z);
        DoubleComplex result = new DoubleComplex();
        if (absz == 0.0) {
            result = z;
        } else {
            double a = DoubleComplex.argument(z);
            double e = Math.pow(absz, x);
            result.re = e * Math.cos(x * a);
            result.im = e * Math.sin(x * a);
        }
        return result;
    }

    public static DoubleComplex asinh(DoubleComplex z) {
        DoubleComplex miz = new DoubleComplex(z.im, -z.re);
        DoubleComplex result = DoubleComplex.asin(miz);
        double rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static DoubleComplex acosh(DoubleComplex z) {
        DoubleComplex result = DoubleComplex.acos(z);
        double rx = -result.im;
        result.im = result.re;
        result.re = rx;
        if (result.re < 0.0 || DoubleComplex.isNegZero(result.re)) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    private static boolean isNegZero(double x) {
        return Double.doubleToLongBits(x) == negZeroBits;
    }

    public static DoubleComplex atanh(DoubleComplex z) {
        DoubleComplex miz = new DoubleComplex(z.im, -z.re);
        DoubleComplex result = DoubleComplex.atan(miz);
        double rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static DoubleComplex pow(DoubleComplex x, DoubleComplex y) {
        return DoubleComplex.exp(DoubleComplex.times(y, DoubleComplex.log(x)));
    }

    public String toString() {
        if (this.im == 0.0) {
            return String.valueOf(this.re);
        }
        if (this.re == 0.0) {
            return String.valueOf(this.im) + suffix;
        }
        String sign = this.im < 0.0 ? "" : "+";
        return String.valueOf(this.re) + sign + String.valueOf(this.im) + suffix;
    }

    public static DoubleComplex valueOf(String s) throws NumberFormatException {
        String input = s.trim();
        int iBeginNumber = 0;
        DoubleComplex z = new DoubleComplex();
        int state = 0;
        int sign = 1;
        boolean haveRealPart = false;
        int k = 0;
        while (k < input.length()) {
            char ch = input.charAt(k);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 0 || state == 1) {
                        state = 2;
                        break;
                    }
                    if (state != 4) break;
                    state = 5;
                    break;
                }
                case '+': 
                case '-': {
                    int n = sign = ch == '+' ? 1 : -1;
                    if (state == 0) {
                        state = 1;
                        break;
                    }
                    if (state == 4) {
                        state = 5;
                        break;
                    }
                    if (!haveRealPart) {
                        z.re = Double.valueOf(input.substring(iBeginNumber, k));
                        haveRealPart = true;
                        iBeginNumber = k;
                        state = 1;
                        break;
                    }
                    throw new NumberFormatException(input);
                }
                case '.': {
                    if (state == 0 || state == 1 || state == 2) {
                        state = 3;
                        break;
                    }
                    throw new NumberFormatException(input);
                }
                case 'I': 
                case 'J': 
                case 'i': 
                case 'j': {
                    if (k + 1 != input.length()) {
                        throw new NumberFormatException(input);
                    }
                    if (state == 0 || state == 1) {
                        z.im = sign;
                        return z;
                    }
                    if (state == 2 || state == 3 || state == 5) {
                        z.im = Double.valueOf(input.substring(iBeginNumber, k));
                        return z;
                    }
                    throw new NumberFormatException(input);
                }
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    if (state == 2 || state == 3) {
                        state = 4;
                        break;
                    }
                    throw new NumberFormatException(input);
                }
                default: {
                    throw new NumberFormatException(input);
                }
            }
            ++k;
        }
        if (!haveRealPart) {
            z.re = Double.valueOf(input);
            return z;
        }
        throw new NumberFormatException(input);
    }

    static {
        serialVersionUID = -633126172485117692L;
        suffix = "i";
        negZeroBits = Double.doubleToLongBits(-0.0);
    }

    public static class Array4
    extends Array {
        public Array4() {
        }

        protected Array4(long array, boolean owner) {
            super(array, owner);
        }

        public Array4(int l0, int l1, int l2, int l3, int u0, int u1, int u2, int u3) {
            super(4, new int[]{l0, l1, l2, l3}, new int[]{u0, u1, u2, u3});
        }

        public Array4(int s0, int s1, int s2, int s3) {
            super(4, new int[]{0, 0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1});
        }

        public Array4(DoubleComplex[][][][] array) {
            this.set(array);
        }

        public DoubleComplex _get(int i, int j, int k, int l) {
            return this._get(i, j, k, l);
        }

        public DoubleComplex get(int i, int j, int k, int l) {
            this.checkBounds(i, j, k, l);
            return this._get(i, j, k, l);
        }

        public void reallocate(int l0, int l1, int l2, int l3, int u0, int u1, int u2, int u3) {
            this.reallocate(4, new int[]{l0, l1, l2, l3}, new int[]{u0, u1, u2, l3});
        }

        public void _set(int i, int j, int k, int l, DoubleComplex value) {
            this._set(i, j, k, l, value);
        }

        public void set(int i, int j, int k, int l, DoubleComplex value) {
            this.checkBounds(i, j, k, l);
            this._set(i, j, k, l, value);
        }

        public DoubleComplex[][][][] get() {
            DoubleComplex[][][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(4);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                int l3 = this._lower(3);
                int u3 = this._upper(3);
                array = new DoubleComplex[u0 - l0 + 1][][][];
                int i = l0;
                while (i <= u0) {
                    array[i] = new DoubleComplex[u1 - l1 + 1][][];
                    int j = l1;
                    while (j <= u1) {
                        array[i][j] = new DoubleComplex[u2 - l2 + 1][];
                        int k = l2;
                        while (k <= u2) {
                            array[i][j][k] = new DoubleComplex[u3 - l3 + 1];
                            int l = l3;
                            while (l <= u3) {
                                array[i - l0][j - l1][k - l2][l - l3] = this._get(i, j, k, l);
                                ++l;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return array;
        }

        public void set(DoubleComplex[][][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                int s3 = array[0][0][0].length - 1;
                this.reallocate(0, 0, 0, 0, s0, s1, s2, s3);
                int i = 0;
                while (i <= s0) {
                    int j = 0;
                    while (j <= s1) {
                        int k = 0;
                        while (k <= s1) {
                            int l = 0;
                            while (l <= s2) {
                                this._set(i, j, k, l, array[i][j][k][l]);
                                ++l;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static class Array3
    extends Array {
        public Array3() {
        }

        protected Array3(long array, boolean owner) {
            super(array, owner);
        }

        public Array3(int l0, int l1, int l2, int u0, int u1, int u2) {
            super(3, new int[]{l0, l1, l2}, new int[]{u0, u1, u2});
        }

        public Array3(int s0, int s1, int s2) {
            super(3, new int[]{0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1});
        }

        public Array3(DoubleComplex[][][] array) {
            this.set(array);
        }

        public DoubleComplex _get(int i, int j, int k) {
            return this._get(i, j, k, 0);
        }

        public DoubleComplex get(int i, int j, int k) {
            this.checkBounds(i, j, k);
            return this._get(i, j, k, 0);
        }

        public void reallocate(int l0, int l1, int l2, int u0, int u1, int u2) {
            this.reallocate(3, new int[]{l0, l1, l2}, new int[]{u0, u1, u2});
        }

        public void _set(int i, int j, int k, DoubleComplex value) {
            this._set(i, j, k, 0, value);
        }

        public void set(int i, int j, int k, DoubleComplex value) {
            this.checkBounds(i, j, k);
            this._set(i, j, k, 0, value);
        }

        public DoubleComplex[][][] get() {
            DoubleComplex[][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(3);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                array = new DoubleComplex[u0 - l0 + 1][][];
                int i = l0;
                while (i <= u0) {
                    array[i] = new DoubleComplex[u1 - l1 + 1][];
                    int j = l1;
                    while (j <= u1) {
                        array[i][j] = new DoubleComplex[u2 - l2 + 1];
                        int k = l2;
                        while (k <= u2) {
                            array[i - l0][j - l1][k - l2] = this._get(i, j, k);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return array;
        }

        public void set(DoubleComplex[][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                this.reallocate(0, 0, 0, s0, s1, s2);
                int i = 0;
                while (i <= s0) {
                    int j = 0;
                    while (j <= s1) {
                        int k = 0;
                        while (k <= s1) {
                            this._set(i, j, k, array[i][j][k]);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static class Array2
    extends Array {
        public Array2() {
        }

        protected Array2(long array, boolean owner) {
            super(array, owner);
        }

        public Array2(int l0, int l1, int u0, int u1) {
            super(2, new int[]{l0, l1}, new int[]{u0, u1});
        }

        public Array2(int s0, int s1) {
            super(2, new int[]{0, 0}, new int[]{s0 - 1, s1 - 1});
        }

        public Array2(DoubleComplex[][] array) {
            this.set(array);
        }

        public DoubleComplex _get(int i, int j) {
            return this._get(i, j, 0, 0);
        }

        public DoubleComplex get(int i, int j) {
            this.checkBounds(i, j);
            return this._get(i, j, 0, 0);
        }

        public void reallocate(int l0, int l1, int u0, int u1) {
            this.reallocate(2, new int[]{l0, l1}, new int[]{u0, u1});
        }

        public void _set(int i, int j, DoubleComplex value) {
            this._set(i, j, 0, 0, value);
        }

        public void set(int i, int j, DoubleComplex value) {
            this.checkBounds(i, j);
            this._set(i, j, 0, 0, value);
        }

        public DoubleComplex[][] get() {
            DoubleComplex[][] array = null;
            if (!this.isNull()) {
                this.checkDimension(2);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                array = new DoubleComplex[u0 - l0 + 1][];
                int i = l0;
                while (i <= u0) {
                    array[i] = new DoubleComplex[u1 - l1 + 1];
                    int j = l1;
                    while (j <= u1) {
                        array[i - l0][j - l1] = this._get(i, j);
                        ++j;
                    }
                    ++i;
                }
            }
            return array;
        }

        public void set(DoubleComplex[][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                this.reallocate(0, 0, s0, s1);
                int i = 0;
                while (i <= s0) {
                    int j = 0;
                    while (j <= s1) {
                        this._set(i, j, array[i][j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static class Array1
    extends Array {
        public Array1() {
        }

        protected Array1(long array, boolean owner) {
            super(array, owner);
        }

        public Array1(int l0, int u0) {
            super(1, new int[]{l0}, new int[]{u0});
        }

        public Array1(int s0) {
            super(1, new int[]{0}, new int[]{s0 - 1});
        }

        public Array1(DoubleComplex[] array) {
            this.set(array);
        }

        public DoubleComplex _get(int i) {
            return this._get(i, 0, 0, 0);
        }

        public DoubleComplex get(int i) {
            this.checkBounds(i);
            return this._get(i, 0, 0, 0);
        }

        public void reallocate(int l0, int u0) {
            this.reallocate(1, new int[]{l0}, new int[]{u0});
        }

        public void _set(int i, DoubleComplex value) {
            this._set(i, 0, 0, 0, value);
        }

        public void set(int i, DoubleComplex value) {
            this.checkBounds(i);
            this._set(i, 0, 0, 0, value);
        }

        public DoubleComplex[] get() {
            DoubleComplex[] array = null;
            if (!this.isNull()) {
                this.checkDimension(1);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                array = new DoubleComplex[u0 - l0 + 1];
                int i = l0;
                while (i <= u0) {
                    array[i - l0] = this._get(i);
                    ++i;
                }
            }
            return array;
        }

        public void set(DoubleComplex[] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                this.reallocate(0, s0);
                int i = 0;
                while (i <= s0) {
                    this._set(i, array[i]);
                    ++i;
                }
            }
        }
    }

    public static class Array
    extends BaseArray {
        public Array() {
        }

        protected Array(long array, boolean owner) {
            super(array, owner);
        }

        public Array(int dim, int[] lower, int[] upper) {
            this.reallocate(dim, lower, upper);
        }

        public native int _dim();

        public native int _lower(int var1);

        public native int _upper(int var1);

        public native DoubleComplex _get(int var1, int var2, int var3, int var4);

        public native void _set(int var1, int var2, int var3, int var4, DoubleComplex var5);

        public native void _destroy();

        public native void _reallocate(int var1, int[] var2, int[] var3);

        static {
            BaseClass._registerNatives("SIDL.DoubleComplex");
        }
    }

    public static class Holder {
        private DoubleComplex d_obj;

        public Holder() {
            this.d_obj = null;
        }

        public Holder(DoubleComplex obj) {
            this.d_obj = obj;
        }

        public void set(DoubleComplex obj) {
            this.d_obj = obj;
        }

        public DoubleComplex get() {
            return this.d_obj;
        }
    }
}

