/*
 * Decompiled with CFR 0.152.
 */
package SIDL;

import SIDL.Sfun;
import gov.llnl.sidl.BaseArray;
import gov.llnl.sidl.BaseClass;
import java.io.Serializable;

public class FloatComplex
implements Serializable,
Cloneable {
    private float re;
    private float im;
    static final long serialVersionUID = -633126172485117692L;
    public static String suffix;
    private static final float PI = (float)Math.PI;
    private static final int negZeroBits;

    public FloatComplex(FloatComplex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public FloatComplex(float re, float im) {
        this.re = re;
        this.im = im;
    }

    public FloatComplex(float re) {
        this.re = re;
        this.im = 0.0f;
    }

    public FloatComplex() {
        this.re = 0.0f;
        this.im = 0.0f;
    }

    private boolean isNaN() {
        return Float.isNaN(this.re) || Float.isNaN(this.im);
    }

    public boolean equals(FloatComplex z) {
        if (this.isNaN() && z.isNaN()) {
            return true;
        }
        return this.re == z.re && this.im == z.im;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FloatComplex) {
            return this.equals((FloatComplex)obj);
        }
        return false;
    }

    public int hashCode() {
        int re_bits = Float.floatToIntBits(this.re);
        int im_bits = Float.floatToIntBits(this.im);
        return re_bits ^ im_bits;
    }

    public void set(float real, float imag) {
        this.re = real;
        this.im = imag;
    }

    public float real() {
        return this.re;
    }

    public float imag() {
        return this.im;
    }

    public static float real(FloatComplex z) {
        return z.re;
    }

    public static float imag(FloatComplex z) {
        return z.im;
    }

    public static FloatComplex negative(FloatComplex z) {
        return new FloatComplex(-z.re, -z.im);
    }

    public static FloatComplex conjugate(FloatComplex z) {
        return new FloatComplex(z.re, -z.im);
    }

    public static FloatComplex plus(FloatComplex x, FloatComplex y) {
        return new FloatComplex(x.re + y.re, x.im + y.im);
    }

    public static FloatComplex plus(FloatComplex x, float y) {
        return new FloatComplex(x.re + y, x.im);
    }

    public static FloatComplex plus(float x, FloatComplex y) {
        return new FloatComplex(x + y.re, y.im);
    }

    public FloatComplex plus(FloatComplex y) {
        return new FloatComplex(this.re + y.re, this.im + y.im);
    }

    public FloatComplex plus(float y) {
        return new FloatComplex(this.re + y, this.im);
    }

    public FloatComplex plusReverse(float x) {
        return new FloatComplex(this.re + x, this.im);
    }

    public static FloatComplex minus(FloatComplex x, FloatComplex y) {
        return new FloatComplex(x.re - y.re, x.im - y.im);
    }

    public static FloatComplex minus(FloatComplex x, float y) {
        return new FloatComplex(x.re - y, x.im);
    }

    public static FloatComplex minus(float x, FloatComplex y) {
        return new FloatComplex(x - y.re, -y.im);
    }

    public FloatComplex minus(FloatComplex y) {
        return new FloatComplex(this.re - y.re, this.im - y.im);
    }

    public FloatComplex minus(float y) {
        return new FloatComplex(this.re - y, this.im);
    }

    public FloatComplex minusReverse(float x) {
        return new FloatComplex(x - this.re, -this.im);
    }

    public static FloatComplex times(FloatComplex x, FloatComplex y) {
        FloatComplex t = new FloatComplex(x.re * y.re - x.im * y.im, x.re * y.im + x.im * y.re);
        if (Float.isNaN(t.re) && Float.isNaN(t.im)) {
            FloatComplex.timesNaN(x, y, t);
        }
        return t;
    }

    private static float copysign(float a, float b) {
        float abs = Math.abs(a);
        return b < 0.0f ? -abs : abs;
    }

    private static void timesNaN(FloatComplex x, FloatComplex y, FloatComplex t) {
        boolean recalc = false;
        float a = x.re;
        float b = x.im;
        float c = y.re;
        float d = y.im;
        if (Float.isInfinite(a) || Float.isInfinite(b)) {
            a = FloatComplex.copysign(Float.isInfinite(a) ? 1.0f : 0.0f, a);
            b = FloatComplex.copysign(Float.isInfinite(b) ? 1.0f : 0.0f, b);
            if (Float.isNaN(c)) {
                c = FloatComplex.copysign(0.0f, c);
            }
            if (Float.isNaN(d)) {
                d = FloatComplex.copysign(0.0f, d);
            }
            recalc = true;
        }
        if (Float.isInfinite(c) || Float.isInfinite(d)) {
            a = FloatComplex.copysign(Float.isInfinite(c) ? 1.0f : 0.0f, c);
            b = FloatComplex.copysign(Float.isInfinite(d) ? 1.0f : 0.0f, d);
            if (Float.isNaN(a)) {
                a = FloatComplex.copysign(0.0f, a);
            }
            if (Float.isNaN(b)) {
                b = FloatComplex.copysign(0.0f, b);
            }
            recalc = true;
        }
        if (!recalc && (Float.isInfinite(a * c) || Float.isInfinite(b * d) || Float.isInfinite(a * d) || Float.isInfinite(b * c))) {
            if (Float.isNaN(a)) {
                a = FloatComplex.copysign(0.0f, a);
            }
            if (Float.isNaN(b)) {
                b = FloatComplex.copysign(0.0f, b);
            }
            if (Float.isNaN(c)) {
                c = FloatComplex.copysign(0.0f, c);
            }
            if (Float.isNaN(d)) {
                d = FloatComplex.copysign(0.0f, d);
            }
            recalc = true;
        }
        if (recalc) {
            t.re = Float.POSITIVE_INFINITY * (a * c - b * d);
            t.im = Float.POSITIVE_INFINITY * (a * d + b * c);
        }
    }

    public static FloatComplex times(FloatComplex x, float y) {
        return new FloatComplex(x.re * y, x.im * y);
    }

    public static FloatComplex times(float x, FloatComplex y) {
        return new FloatComplex(x * y.re, x * y.im);
    }

    public FloatComplex times(FloatComplex y) {
        return FloatComplex.times(this, y);
    }

    public FloatComplex times(float y) {
        return new FloatComplex(this.re * y, this.im * y);
    }

    public FloatComplex timesReverse(float x) {
        return new FloatComplex(x * this.re, x * this.im);
    }

    private static boolean isFinite(float x) {
        return !Float.isInfinite(x) && !Float.isNaN(x);
    }

    public static FloatComplex over(FloatComplex x, FloatComplex y) {
        float a = x.re;
        float b = x.im;
        float c = y.re;
        float d = y.im;
        float scale = Math.max(Math.abs(c), Math.abs(d));
        boolean isScaleFinite = FloatComplex.isFinite(scale);
        if (isScaleFinite) {
            c /= scale;
            d /= scale;
        }
        float den = c * c + d * d;
        FloatComplex z = new FloatComplex((a * c + b * d) / den, (b * c - a * d) / den);
        if (isScaleFinite) {
            z.re /= scale;
            z.im /= scale;
        }
        if (Float.isNaN(z.re) && Float.isNaN(z.im)) {
            if (!(den != 0.0f || Float.isNaN(a) && Float.isNaN(b))) {
                float s = FloatComplex.copysign(Float.POSITIVE_INFINITY, c);
                z.re = s * a;
                z.im = s * b;
            } else if ((Float.isInfinite(a) || Float.isInfinite(b)) && FloatComplex.isFinite(c) && FloatComplex.isFinite(d)) {
                a = FloatComplex.copysign(Float.isInfinite(a) ? 1.0f : 0.0f, a);
                b = FloatComplex.copysign(Float.isInfinite(b) ? 1.0f : 0.0f, b);
                z.re = Float.POSITIVE_INFINITY * (a * c + b * d);
                z.im = Float.POSITIVE_INFINITY * (b * c - a * d);
            } else if (Float.isInfinite(scale) && FloatComplex.isFinite(a) && FloatComplex.isFinite(b)) {
                c = FloatComplex.copysign(Float.isInfinite(c) ? 1.0f : 0.0f, c);
                d = FloatComplex.copysign(Float.isInfinite(d) ? 1.0f : 0.0f, d);
                z.re = 0.0f * (a * c + b * d);
                z.im = 0.0f * (b * c - a * d);
            }
        }
        return z;
    }

    public static FloatComplex over(FloatComplex x, float y) {
        return new FloatComplex(x.re / y, x.im / y);
    }

    public static FloatComplex over(float x, FloatComplex y) {
        return y.overReverse(x);
    }

    public FloatComplex over(FloatComplex y) {
        return FloatComplex.over(this, y);
    }

    public FloatComplex over(float y) {
        return FloatComplex.over(this, y);
    }

    public FloatComplex overReverse(float x) {
        FloatComplex z;
        if (Math.abs(this.re) > Math.abs(this.im)) {
            float t = this.im / this.re;
            float den = this.re + this.im * t;
            z = new FloatComplex(x / den, -x * t / den);
        } else {
            float t = this.re / this.im;
            float den = this.im + this.re * t;
            z = new FloatComplex(x * t / den, -x / den);
        }
        return z;
    }

    public static float abs(FloatComplex z) {
        float x = Math.abs(z.re);
        float y = Math.abs(z.im);
        if (Float.isInfinite(x) || Float.isInfinite(y)) {
            return Float.POSITIVE_INFINITY;
        }
        if (x + y == 0.0f) {
            return 0.0f;
        }
        if (x > y) {
            return x * (float)Math.sqrt(1.0f + (y /= x) * y);
        }
        return y * (float)Math.sqrt((x /= y) * x + 1.0f);
    }

    public static float argument(FloatComplex z) {
        return (float)Math.atan2(z.im, z.re);
    }

    public static FloatComplex sqrt(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        if (Float.isInfinite(z.im)) {
            result.re = Float.POSITIVE_INFINITY;
            result.im = z.im;
        } else if (Float.isNaN(z.re)) {
            result.im = Float.NaN;
            result.re = Float.NaN;
        } else if (Float.isNaN(z.im)) {
            if (Float.isInfinite(z.re)) {
                if (z.re > 0.0f) {
                    result.re = z.re;
                    result.im = z.im;
                } else {
                    result.re = z.im;
                    result.im = Float.POSITIVE_INFINITY;
                }
            } else {
                result.im = Float.NaN;
                result.re = Float.NaN;
            }
        } else {
            float t = FloatComplex.abs(z);
            if (Math.abs(z.re) <= Math.abs(z.im)) {
                result.re = (float)Math.sqrt(0.5 * (double)(t + z.re));
                result.im = (float)Math.sqrt(0.5 * (double)(t - z.re));
            } else if (z.re > 0.0f) {
                result.re = t + z.re;
                result.im = Math.abs(z.im) * (float)Math.sqrt(0.5 / (double)result.re);
                result.re = (float)Math.sqrt(0.5 * (double)result.re);
            } else {
                result.im = t - z.re;
                result.re = Math.abs(z.im) * (float)Math.sqrt(0.5 / (double)result.im);
                result.im = (float)Math.sqrt(0.5 * (double)result.im);
            }
            if (z.im < 0.0f) {
                result.im = -result.im;
            }
        }
        return result;
    }

    public static FloatComplex exp(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = (float)Math.exp(z.re);
        float cosa = (float)Math.cos(z.im);
        float sina = (float)Math.sin(z.im);
        if (Float.isInfinite(z.im) || Float.isNaN(z.im) || Math.abs(cosa) > 1.0f) {
            sina = Float.NaN;
            cosa = Float.NaN;
        }
        if (Float.isInfinite(z.re) || Float.isInfinite(r)) {
            if (z.re < 0.0f) {
                r = 0.0f;
                if (Float.isInfinite(z.im) || Float.isNaN(z.im)) {
                    sina = 0.0f;
                    cosa = 0.0f;
                } else {
                    cosa /= Float.POSITIVE_INFINITY;
                    sina /= Float.POSITIVE_INFINITY;
                }
            } else {
                r = z.re;
                if (Float.isNaN(z.im)) {
                    cosa = 1.0f;
                }
            }
        }
        if ((double)z.im == 0.0) {
            result.re = r;
            result.im = z.im;
        } else {
            result.re = r * cosa;
            result.im = r * sina;
        }
        return result;
    }

    public static FloatComplex log(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        if (Float.isNaN(z.re)) {
            result.re = result.im = z.re;
            if (Float.isInfinite(z.im)) {
                result.re = Float.POSITIVE_INFINITY;
            }
        } else if (Float.isNaN(z.im)) {
            result.re = result.im = z.im;
            if (Float.isInfinite(z.re)) {
                result.re = Float.POSITIVE_INFINITY;
            }
        } else {
            result.re = (float)Math.log(FloatComplex.abs(z));
            result.im = FloatComplex.argument(z);
        }
        return result;
    }

    public static FloatComplex sin(FloatComplex z) {
        FloatComplex iz = new FloatComplex(-z.im, z.re);
        FloatComplex s = FloatComplex.sinh(iz);
        float re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static FloatComplex cos(FloatComplex z) {
        return FloatComplex.cosh(new FloatComplex(-z.im, z.re));
    }

    public static FloatComplex tan(FloatComplex z) {
        FloatComplex iz = new FloatComplex(-z.im, z.re);
        FloatComplex s = FloatComplex.tanh(iz);
        float re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static FloatComplex asin(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = FloatComplex.abs(z);
        if (Float.isInfinite(r)) {
            boolean infiniteX = Float.isInfinite(z.re);
            boolean infiniteY = Float.isInfinite(z.im);
            if (infiniteX) {
                float pi2 = 1.5707964f;
                float f = result.re = z.re > 0.0f ? pi2 : -pi2;
                if (infiniteY) {
                    result.re /= 2.0f;
                }
            } else if (infiniteY) {
                result.re = z.re / Float.POSITIVE_INFINITY;
            }
            if (Float.isNaN(z.im)) {
                result.im = -z.re;
                result.re = z.im;
            } else {
                result.im = z.im * Float.POSITIVE_INFINITY;
            }
            return result;
        }
        if (Float.isNaN(r)) {
            result.im = Float.NaN;
            result.re = Float.NaN;
            if (z.re == 0.0f) {
                result.re = z.re;
            }
        } else if ((double)r < 2.58095E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if (z.re == 0.0f) {
            result.re = 0.0f;
            result.im = (float)Sfun.asinh(z.im);
        } else if (r <= 0.1f) {
            FloatComplex z2 = FloatComplex.times(z, z);
            int i = 1;
            while (i <= 8) {
                float twoi = 2.0f * (8.0f - (float)i) + 1.0f;
                result = FloatComplex.times(FloatComplex.times(result, z2), twoi / (twoi + 1.0f));
                result.re += 1.0f / twoi;
                ++i;
            }
            result = result.times(z);
        } else {
            FloatComplex w = z.im < 0.0f ? FloatComplex.negative(z) : z;
            FloatComplex sqzp1 = FloatComplex.sqrt(FloatComplex.plus(w, 1.0f));
            if (sqzp1.im < 0.0f) {
                sqzp1 = FloatComplex.negative(sqzp1);
            }
            FloatComplex sqzm1 = FloatComplex.sqrt(FloatComplex.minus(w, 1.0f));
            result = FloatComplex.log(FloatComplex.plus(w, FloatComplex.times(sqzp1, sqzm1)));
            float rx = result.re;
            result.re = 1.5707964f + result.im;
            result.im = -rx;
        }
        if (result.re > 1.5707964f) {
            result.re = (float)Math.PI - result.re;
            result.im = -result.im;
        }
        if (result.re < -1.5707964f) {
            result.re = (float)(-Math.PI) - result.re;
            result.im = -result.im;
        }
        if (z.im < 0.0f) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    public static FloatComplex acos(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = FloatComplex.abs(z);
        if (Float.isInfinite(z.re) && Float.isNaN(z.im)) {
            result.re = Float.NaN;
            result.im = Float.NEGATIVE_INFINITY;
        } else if (Float.isInfinite(r)) {
            result.re = (float)Math.atan2(Math.abs(z.im), z.re);
            result.im = z.im * Float.NEGATIVE_INFINITY;
        } else if (r == 0.0f) {
            result.re = 1.5707964f;
            result.im = -z.im;
        } else {
            result = FloatComplex.minus(1.5707964f, FloatComplex.asin(z));
        }
        return result;
    }

    public static FloatComplex atan(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = FloatComplex.abs(z);
        if (Float.isInfinite(r)) {
            float pi2 = 1.5707964f;
            float im = Float.isNaN(z.im) ? 0.0f : z.im;
            result.re = z.re < 0.0f ? -pi2 : pi2;
            result.im = (float)(im < 0.0f ? -1 : 1) / Float.POSITIVE_INFINITY;
            if (Float.isNaN(z.re)) {
                result.re = z.re;
            }
        } else if (Float.isNaN(r)) {
            result.im = Float.NaN;
            result.re = Float.NaN;
            if (z.im == 0.0f) {
                result.im = z.im;
            }
        } else if ((double)r < 1.82501E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if ((double)r < 0.1) {
            FloatComplex z2 = FloatComplex.times(z, z);
            int k = 0;
            while (k < 17) {
                FloatComplex temp = FloatComplex.times(z2, result);
                int twoi = 2 * (17 - k) - 1;
                result.re = 1.0f / (float)twoi - temp.re;
                result.im = -temp.im;
                ++k;
            }
            result = result.times(z);
        } else if ((double)r < 9.0072E15) {
            float r2 = r * r;
            result.re = 0.5f * (float)Math.atan2(2.0f * z.re, 1.0 - (double)r2);
            result.im = 0.25f * (float)Math.log((r2 + 2.0f * z.im + 1.0f) / (r2 - 2.0f * z.im + 1.0f));
        } else {
            result.re = z.re < 0.0f ? -1.5707964f : 1.5707964f;
        }
        return result;
    }

    public static FloatComplex sinh(FloatComplex z) {
        FloatComplex result;
        float coshx = (float)Sfun.cosh(z.re);
        float sinhx = (float)Sfun.sinh(z.re);
        float cosy = (float)Math.cos(z.im);
        float siny = (float)Math.sin(z.im);
        boolean infiniteX = Float.isInfinite(coshx);
        boolean infiniteY = Float.isInfinite(z.im);
        if (z.im == 0.0f) {
            result = new FloatComplex((float)Sfun.sinh(z.re));
        } else {
            result = new FloatComplex(sinhx * cosy, coshx * siny);
            if (infiniteY) {
                result.im = Float.NaN;
                if (z.re == 0.0f) {
                    result.re = 0.0f;
                }
            }
            if (infiniteX) {
                result.re = z.re * cosy;
                result.im = z.re * siny;
                if (z.im == 0.0f) {
                    result.im = 0.0f;
                }
                if (infiniteY) {
                    result.re = z.im;
                }
            }
        }
        return result;
    }

    public static FloatComplex cosh(FloatComplex z) {
        if (z.im == 0.0f) {
            return new FloatComplex((float)Sfun.cosh(z.re));
        }
        float coshx = (float)Sfun.cosh(z.re);
        float sinhx = (float)Sfun.sinh(z.re);
        float cosy = (float)Math.cos(z.im);
        float siny = (float)Math.sin(z.im);
        boolean infiniteX = Float.isInfinite(coshx);
        boolean infiniteY = Float.isInfinite(z.im);
        FloatComplex result = new FloatComplex(coshx * cosy, sinhx * siny);
        if (infiniteY) {
            result.re = Float.NaN;
        }
        if (z.re == 0.0f) {
            result.im = 0.0f;
        } else if (infiniteX) {
            result.re = z.re * cosy;
            result.im = z.re * siny;
            if (z.im == 0.0f) {
                result.im = 0.0f;
            }
            if (Float.isNaN(z.im)) {
                result.re = z.re;
            } else if (infiniteY) {
                result.re = z.im;
            }
        }
        return result;
    }

    public static FloatComplex tanh(FloatComplex z) {
        float sinh2x = (float)Sfun.sinh(2.0f * z.re);
        if (z.im == 0.0f) {
            return new FloatComplex((float)Sfun.tanh(z.re));
        }
        if (sinh2x == 0.0f) {
            return new FloatComplex(0.0f, (float)Math.tan(z.im));
        }
        float cosh2x = (float)Sfun.cosh(2.0 * (double)z.re);
        float cos2y = (float)Math.cos(2.0 * (double)z.im);
        float sin2y = (float)Math.sin(2.0 * (double)z.im);
        boolean infiniteX = Float.isInfinite(cosh2x);
        if (Float.isInfinite(z.im) || Float.isNaN(z.im)) {
            sin2y = Float.NaN;
            cos2y = Float.NaN;
        }
        if (infiniteX) {
            return new FloatComplex(z.re > 0.0f ? 1.0f : -1.0f);
        }
        float den = cosh2x + cos2y;
        return new FloatComplex(sinh2x / den, sin2y / den);
    }

    public static FloatComplex pow(FloatComplex z, float x) {
        float absz = FloatComplex.abs(z);
        FloatComplex result = new FloatComplex();
        if ((double)absz == 0.0) {
            result = z;
        } else {
            float a = FloatComplex.argument(z);
            float e = (float)Math.pow(absz, x);
            result.re = e * (float)Math.cos(x * a);
            result.im = e * (float)Math.sin(x * a);
        }
        return result;
    }

    public static FloatComplex asinh(FloatComplex z) {
        FloatComplex miz = new FloatComplex(z.im, -z.re);
        FloatComplex result = FloatComplex.asin(miz);
        float rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static FloatComplex acosh(FloatComplex z) {
        FloatComplex result = FloatComplex.acos(z);
        float rx = -result.im;
        result.im = result.re;
        result.re = rx;
        if (result.re < 0.0f || FloatComplex.isNegZero(result.re)) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    private static boolean isNegZero(float x) {
        return Float.floatToIntBits(x) == negZeroBits;
    }

    public static FloatComplex atanh(FloatComplex z) {
        FloatComplex miz = new FloatComplex(z.im, -z.re);
        FloatComplex result = FloatComplex.atan(miz);
        float rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static FloatComplex pow(FloatComplex x, FloatComplex y) {
        return FloatComplex.exp(FloatComplex.times(y, FloatComplex.log(x)));
    }

    public String toString() {
        if ((double)this.im == 0.0) {
            return String.valueOf(this.re);
        }
        if ((double)this.re == 0.0) {
            return String.valueOf(this.im) + suffix;
        }
        String sign = (double)this.im < 0.0 ? "" : "+";
        return String.valueOf(this.re) + sign + String.valueOf(this.im) + suffix;
    }

    public static FloatComplex valueOf(String s) throws NumberFormatException {
        String input = s.trim();
        int iBeginNumber = 0;
        FloatComplex z = new FloatComplex();
        int state = 0;
        int sign = 1;
        boolean haveRealPart = false;
        int k = 0;
        while (k < input.length()) {
            char ch = input.charAt(k);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 0 || state == 1) {
                        state = 2;
                        break;
                    }
                    if (state != 4) break;
                    state = 5;
                    break;
                }
                case '+': 
                case '-': {
                    int n = sign = ch == '+' ? 1 : -1;
                    if (state == 0) {
                        state = 1;
                        break;
                    }
                    if (state == 4) {
                        state = 5;
                        break;
                    }
                    if (!haveRealPart) {
                        z.re = Float.valueOf(input.substring(iBeginNumber, k)).floatValue();
                        haveRealPart = true;
                        iBeginNumber = k;
                        state = 1;
                        break;
                    }
                    throw new NumberFormatException(input);
                }
                case '.': {
                    if (state == 0 || state == 1 || state == 2) {
                        state = 3;
                        break;
                    }
                    throw new NumberFormatException(input);
                }
                case 'I': 
                case 'J': 
                case 'i': 
                case 'j': {
                    if (k + 1 != input.length()) {
                        throw new NumberFormatException(input);
                    }
                    if (state == 0 || state == 1) {
                        z.im = sign;
                        return z;
                    }
                    if (state == 2 || state == 3 || state == 5) {
                        z.im = Float.valueOf(input.substring(iBeginNumber, k)).floatValue();
                        return z;
                    }
                    throw new NumberFormatException(input);
                }
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    if (state == 2 || state == 3) {
                        state = 4;
                        break;
                    }
                    throw new NumberFormatException(input);
                }
                default: {
                    throw new NumberFormatException(input);
                }
            }
            ++k;
        }
        if (!haveRealPart) {
            z.re = Float.valueOf(input).floatValue();
            return z;
        }
        throw new NumberFormatException(input);
    }

    static {
        serialVersionUID = -633126172485117692L;
        suffix = "i";
        PI = (float)Math.PI;
        negZeroBits = Float.floatToIntBits(-0.0f);
    }

    public static class Array4
    extends Array {
        public Array4() {
        }

        protected Array4(long array, boolean owner) {
            super(array, owner);
        }

        public Array4(int l0, int l1, int l2, int l3, int u0, int u1, int u2, int u3) {
            super(4, new int[]{l0, l1, l2, l3}, new int[]{u0, u1, u2, u3});
        }

        public Array4(int s0, int s1, int s2, int s3) {
            super(4, new int[]{0, 0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1});
        }

        public Array4(FloatComplex[][][][] array) {
            this.set(array);
        }

        public FloatComplex _get(int i, int j, int k, int l) {
            return this._get(i, j, k, l);
        }

        public FloatComplex get(int i, int j, int k, int l) {
            this.checkBounds(i, j, k, l);
            return this._get(i, j, k, l);
        }

        public void reallocate(int l0, int l1, int l2, int l3, int u0, int u1, int u2, int u3) {
            this.reallocate(4, new int[]{l0, l1, l2, l3}, new int[]{u0, u1, u2, l3});
        }

        public void _set(int i, int j, int k, int l, FloatComplex value) {
            this._set(i, j, k, l, value);
        }

        public void set(int i, int j, int k, int l, FloatComplex value) {
            this.checkBounds(i, j, k, l);
            this._set(i, j, k, l, value);
        }

        public FloatComplex[][][][] get() {
            FloatComplex[][][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(4);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                int l3 = this._lower(3);
                int u3 = this._upper(3);
                array = new FloatComplex[u0 - l0 + 1][][][];
                int i = l0;
                while (i <= u0) {
                    array[i] = new FloatComplex[u1 - l1 + 1][][];
                    int j = l1;
                    while (j <= u1) {
                        array[i][j] = new FloatComplex[u2 - l2 + 1][];
                        int k = l2;
                        while (k <= u2) {
                            array[i][j][k] = new FloatComplex[u3 - l3 + 1];
                            int l = l3;
                            while (l <= u3) {
                                array[i - l0][j - l1][k - l2][l - l3] = this._get(i, j, k, l);
                                ++l;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return array;
        }

        public void set(FloatComplex[][][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                int s3 = array[0][0][0].length - 1;
                this.reallocate(0, 0, 0, 0, s0, s1, s2, s3);
                int i = 0;
                while (i <= s0) {
                    int j = 0;
                    while (j <= s1) {
                        int k = 0;
                        while (k <= s1) {
                            int l = 0;
                            while (l <= s2) {
                                this._set(i, j, k, l, array[i][j][k][l]);
                                ++l;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static class Array3
    extends Array {
        public Array3() {
        }

        protected Array3(long array, boolean owner) {
            super(array, owner);
        }

        public Array3(int l0, int l1, int l2, int u0, int u1, int u2) {
            super(3, new int[]{l0, l1, l2}, new int[]{u0, u1, u2});
        }

        public Array3(int s0, int s1, int s2) {
            super(3, new int[]{0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1});
        }

        public Array3(FloatComplex[][][] array) {
            this.set(array);
        }

        public FloatComplex _get(int i, int j, int k) {
            return this._get(i, j, k, 0);
        }

        public FloatComplex get(int i, int j, int k) {
            this.checkBounds(i, j, k);
            return this._get(i, j, k, 0);
        }

        public void reallocate(int l0, int l1, int l2, int u0, int u1, int u2) {
            this.reallocate(3, new int[]{l0, l1, l2}, new int[]{u0, u1, u2});
        }

        public void _set(int i, int j, int k, FloatComplex value) {
            this._set(i, j, k, 0, value);
        }

        public void set(int i, int j, int k, FloatComplex value) {
            this.checkBounds(i, j, k);
            this._set(i, j, k, 0, value);
        }

        public FloatComplex[][][] get() {
            FloatComplex[][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(3);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                array = new FloatComplex[u0 - l0 + 1][][];
                int i = l0;
                while (i <= u0) {
                    array[i] = new FloatComplex[u1 - l1 + 1][];
                    int j = l1;
                    while (j <= u1) {
                        array[i][j] = new FloatComplex[u2 - l2 + 1];
                        int k = l2;
                        while (k <= u2) {
                            array[i - l0][j - l1][k - l2] = this._get(i, j, k);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return array;
        }

        public void set(FloatComplex[][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                this.reallocate(0, 0, 0, s0, s1, s2);
                int i = 0;
                while (i <= s0) {
                    int j = 0;
                    while (j <= s1) {
                        int k = 0;
                        while (k <= s1) {
                            this._set(i, j, k, array[i][j][k]);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static class Array2
    extends Array {
        public Array2() {
        }

        protected Array2(long array, boolean owner) {
            super(array, owner);
        }

        public Array2(int l0, int l1, int u0, int u1) {
            super(2, new int[]{l0, l1}, new int[]{u0, u1});
        }

        public Array2(int s0, int s1) {
            super(2, new int[]{0, 0}, new int[]{s0 - 1, s1 - 1});
        }

        public Array2(FloatComplex[][] array) {
            this.set(array);
        }

        public FloatComplex _get(int i, int j) {
            return this._get(i, j, 0, 0);
        }

        public FloatComplex get(int i, int j) {
            this.checkBounds(i, j);
            return this._get(i, j, 0, 0);
        }

        public void reallocate(int l0, int l1, int u0, int u1) {
            this.reallocate(2, new int[]{l0, l1}, new int[]{u0, u1});
        }

        public void _set(int i, int j, FloatComplex value) {
            this._set(i, j, 0, 0, value);
        }

        public void set(int i, int j, FloatComplex value) {
            this.checkBounds(i, j);
            this._set(i, j, 0, 0, value);
        }

        public FloatComplex[][] get() {
            FloatComplex[][] array = null;
            if (!this.isNull()) {
                this.checkDimension(2);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                array = new FloatComplex[u0 - l0 + 1][];
                int i = l0;
                while (i <= u0) {
                    array[i] = new FloatComplex[u1 - l1 + 1];
                    int j = l1;
                    while (j <= u1) {
                        array[i - l0][j - l1] = this._get(i, j);
                        ++j;
                    }
                    ++i;
                }
            }
            return array;
        }

        public void set(FloatComplex[][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                this.reallocate(0, 0, s0, s1);
                int i = 0;
                while (i <= s0) {
                    int j = 0;
                    while (j <= s1) {
                        this._set(i, j, array[i][j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static class Array1
    extends Array {
        public Array1() {
        }

        protected Array1(long array, boolean owner) {
            super(array, owner);
        }

        public Array1(int l0, int u0) {
            super(1, new int[]{l0}, new int[]{u0});
        }

        public Array1(int s0) {
            super(1, new int[]{0}, new int[]{s0 - 1});
        }

        public Array1(FloatComplex[] array) {
            this.set(array);
        }

        public FloatComplex _get(int i) {
            return this._get(i, 0, 0, 0);
        }

        public FloatComplex get(int i) {
            this.checkBounds(i);
            return this._get(i, 0, 0, 0);
        }

        public void reallocate(int l0, int u0) {
            this.reallocate(1, new int[]{l0}, new int[]{u0});
        }

        public void _set(int i, FloatComplex value) {
            this._set(i, 0, 0, 0, value);
        }

        public void set(int i, FloatComplex value) {
            this.checkBounds(i);
            this._set(i, 0, 0, 0, value);
        }

        public FloatComplex[] get() {
            FloatComplex[] array = null;
            if (!this.isNull()) {
                this.checkDimension(1);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                array = new FloatComplex[u0 - l0 + 1];
                int i = l0;
                while (i <= u0) {
                    array[i - l0] = this._get(i);
                    ++i;
                }
            }
            return array;
        }

        public void set(FloatComplex[] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                this.reallocate(0, s0);
                int i = 0;
                while (i <= s0) {
                    this._set(i, array[i]);
                    ++i;
                }
            }
        }
    }

    public static class Array
    extends BaseArray {
        public Array() {
        }

        protected Array(long array, boolean owner) {
            super(array, owner);
        }

        public Array(int dim, int[] lower, int[] upper) {
            this.reallocate(dim, lower, upper);
        }

        public native int _dim();

        public native int _lower(int var1);

        public native int _upper(int var1);

        public native FloatComplex _get(int var1, int var2, int var3, int var4);

        public native void _set(int var1, int var2, int var3, int var4, FloatComplex var5);

        public native void _destroy();

        public native void _reallocate(int var1, int[] var2, int[] var3);

        static {
            BaseClass._registerNatives("SIDL.FloatComplex");
        }
    }

    public static class Holder {
        private FloatComplex d_obj;

        public Holder() {
            this.d_obj = null;
        }

        public Holder(FloatComplex obj) {
            this.d_obj = obj;
        }

        public void set(FloatComplex obj) {
            this.d_obj = obj;
        }

        public FloatComplex get() {
            return this.d_obj;
        }
    }
}

