//
// File:        RepositoryTest.java
// Package:     gov.llnl.babel.repository
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Id: RepositoryTest.java,v 1.3 2002/08/20 16:55:32 epperly Exp $
// Description: unit test for the repository package
//
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.repository;

import gov.llnl.babel.parsers.xml.SymbolToDOM;
import gov.llnl.babel.repository.Repository;
import gov.llnl.babel.repository.RepositoryException;
import gov.llnl.babel.repository.RepositoryFactory;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Version;

/**
 * Class <code>RepositoryTest</code> is a simple unit test for the repository
 * routines.  It may be called with either two or three arguments.  The first
 * argument is always the URI of the repository (either a file path or a URL
 * with username and password).  The second argument is always a symbol name.
 * The optional third argument is the symbol version.  The specified symbol
 * will be read from the repository and displayed on standard out.
 */
public class RepositoryTest {
   /**
    * Method <code>main</code> is the entry point for the unit test.
    * See the class documentation for calling arguments.
    */
   public static void main(String argv[]) {
      /*
       * Check that we are called with two or three command line arguments.
       */
      if ((argv.length != 2) && (argv.length != 3)) {
         System.err.println(
            "usage: gov.llnl.babel.repository.RepositoryTest " +
            "repository-URI symbol-name [symbol-version]");
         System.exit(1);
      }

      /*
       * Create a repository using the repository URI.
       */
      Repository repository = null;
      try {
         String r = argv[0];
         repository = RepositoryFactory.getInstance().createRepository(r);
      } catch (RepositoryException ex) {
	 System.err.println("Babel: Error: RepositoryException");
         System.err.println(ex.getMessage());
         System.exit(1);
      }
      SymbolTable.getInstance().addSymbolResolver(repository);

      /*
       * Read the symbol from the repository.
       */
      Symbol symbol = null;
      if (argv.length == 2) {
         symbol = repository.lookupSymbol(argv[1]);
      } else {
         try {
            SymbolID id = new SymbolID(argv[1], new Version(argv[2]));
            symbol = repository.lookupSymbol(id);
         } catch (NumberFormatException ex) {
	    System.err.println("Babel: Error: NumberFormatException");
            System.err.println(ex.getMessage());
            System.exit(1);
         }
      }

      /*
       * Print out symbol information to standard output.
       */
      if (symbol == null) {
         System.out.println("Symbol not found in repository");
      } else {
         System.out.println(SymbolToDOM.convertToString(symbol));
      }
   }
}
