!
!     File:       HelloDriver.F90
!     Copyright:  (c) 2003 The Regents of the University of California
!     Release:    $Name: release-0-8-8 $
!     Revision:   @(#) $Revision: 1.3 $
!     Date:       $Date: 2003/04/07 15:06:35 $
!     Description:Simple CCA Hello World F90 client
!
!
#include "decaf_Framework_fAbbrev.h"
#include "SIDL_BaseException_fAbbrev.h"
#include "gov_cca_TypeMap_fAbbrev.h"
#include "gov_cca_Port_fAbbrev.h"
#include "gov_cca_ports_GoPort_fAbbrev.h"
#include "gov_cca_ComponentID_fAbbrev.h"
#include "gov_cca_ConnectionID_fAbbrev.h"

program HelloDriver
  use decaf_Framework
  use SIDL_BaseException
  use gov_cca_TypeMap
  use gov_cca_Port
  use gov_cca_ports_GoPort
  use gov_cca_ComponentID
  use gov_cca_ConnectionID
  
  type(decaf_Framework_t) :: decaf
  type(gov_cca_ComponentID_t) :: server, client
  type(gov_cca_Port_t) :: port
  type(gov_cca_ports_GoPort_t) :: goPort
  integer(selected_int_kind(9)) :: retval
  type(SIDL_BaseException_t) :: ex
  type(gov_cca_TypeMap_t) :: properties
  type(gov_cca_ConnectionID_t) :: connectionID

  call new(decaf)

  call createTypeMap( decaf, properties, ex )
  if (not_null(ex)) then
     write(*,*) 'createTypeMap threw an exception'
     stop
  end if

  call createInstance(decaf, 'HelloServerInstance', 'HelloServer.Component', &
       properties, server, ex)
  if (not_null(ex)) then
     write(*,*) 'createInstance(server) threw an exception'
     stop
  end if
  
  call createInstance(decaf, 'HelloClientInstance', 'HelloClient.Component', &
       properties,  client, ex)
  if (not_null(ex)) then
     write(*,*) 'createInstance(client) threw an exception'
     stop
  end if
  call deleteRef(properties)
  
  call connect(decaf, client, 'HelloServer', &
       server, 'HelloServer', connectionID, ex)
  if (not_null(ex)) then
     write(*,*) 'connect threw an exception'
     stop
  end if
  call deleteRef(connectionID)

  call lookupPort(decaf, client, 'GoPort', port)
  call cast(port, goPort)
  call go(goPort, retval)
  call deleteRef(goPort)

  call destroyInstance(decaf, server, 0.0, ex)
  call destroyInstance(decaf, client, 0.0, ex)

! remove remaining references
  call deleteRef(server)
  call deleteRef(client)
  call deleteRef(decaf)
end program HelloDriver
