
#include <iostream>
using namespace std;
#include "Args.hh"

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " <<  #AAA << endl; \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  end_part( part_no, unsupported, &final_result );

int main(int argc, char **argv) { 
  int result = pass; 
  int final_result = pass;
  int part_no = 0;
  string language = "";
  cout << "NPARTS -1" << endl;
  if (argc == 2) {
    language = argv[1];
  }
  
  { // bool 
     bool out;
     bool inout = true;
    Args::Cbool obj = Args::Cbool::_create();
 
    MYASSERT( obj.returnback( ) == true );
    MYASSERT( obj.passin( true ) == true );
    MYASSERT( obj.passout( out ) == true && out == true );
    MYASSERT( obj.passinout( inout ) == true && inout == false );
    MYASSERT( obj.passeverywhere( true, out, inout ) == true &&
	      out == true && inout == true );    
  } 

  { // char 
    char out;
    char inout = 'A';
    Args::Cchar obj = Args::Cchar::_create();
 
    MYASSERT( obj.returnback( ) == '3' );
    MYASSERT( obj.passin( '3' ) == true );
    MYASSERT( obj.passout( out ) == true && out == '3' );
    MYASSERT( obj.passinout( inout ) == true && inout == 'a' );
    MYASSERT( obj.passeverywhere( '3', out, inout ) == '3' &&
	      out == '3' && inout == 'A' );
  }


  { // int 
    int32_t out;
    int32_t inout = 3;
    Args::Cint obj = Args::Cint::_create();
 
    MYASSERT( obj.returnback( ) == 3 );
    MYASSERT( obj.passin( 3 ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3 );
    MYASSERT( obj.passinout( inout ) == true && inout == -3 );
    MYASSERT( obj.passeverywhere( 3, out, inout ) == 3 &&
	      out == 3 && inout == 3 );
  }


  { // long 
    int64_t out;
    int64_t inout = 3L;
    Args::Clong obj = Args::Clong::_create();
 
    MYASSERT( obj.returnback( ) == 3L );
    MYASSERT( obj.passin( 3L ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3L );
    MYASSERT( obj.passinout( inout ) == true && inout == -3L );
    MYASSERT( obj.passeverywhere( 3L, out, inout ) == 3L &&
	      out == 3L && inout == 3L );
  }


  { // float 
    float out;
    float inout = 3.1F;
    Args::Cfloat obj = Args::Cfloat::_create();
 
    cout << "COMMENT: obj.returnback() == " << obj.returnback() << endl;
    MYASSERT( obj.returnback( ) == 3.1F );
    MYASSERT( obj.passin( 3.1F ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3.1F );
    MYASSERT( obj.passinout( inout ) == true && inout == -3.1F );
    MYASSERT( obj.passeverywhere( 3.1F, out, inout ) == 3.1F &&
	      out == 3.1F && inout == 3.1F );
  }


  { // double 
    double out;
    double inout = 3.14;
    Args::Cdouble obj = Args::Cdouble::_create();
 
    MYASSERT( obj.returnback( ) == 3.14 );
    MYASSERT( obj.passin( 3.14 ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3.14 );
    MYASSERT( obj.passinout( inout ) == true && inout == -3.14 );
    MYASSERT( obj.passeverywhere( 3.14, out, inout ) == 3.14 &&
	      out == 3.14 && inout == 3.14 );
  }


  { // fcomplex 
    complex<float> retval;
    complex<float> in( 3.1F, 3.1F );
    complex<float> out;
    complex<float> inout( 3.1F, 3.1F );
    Args::Cfcomplex obj = Args::Cfcomplex::_create();
 
    cout << "COMMENT: retval = obj.returnback( );" << endl;
    retval = obj.returnback( ); 
    MYASSERT( retval.real() == 3.1F && retval.imag() == 3.1F);
    MYASSERT( obj.passin( in ) == true );

    MYASSERT( obj.passout( out ) == true && 
	      out.real() == 3.1F && out.imag() == 3.1F );
    MYASSERT( obj.passinout( inout ) == true && 
	      inout.real() == 3.1F && inout.imag() == -3.1F );
    cout << "COMMENT: retval = obj.passeverywhere( in, out, inout );" << endl;
    retval = obj.passeverywhere( in, out, inout );
    MYASSERT( retval.real() == 3.1F && retval.imag() == 3.1F &&
	      out.real() == 3.1F && out.imag() == 3.1F && 
	      inout.real() == 3.1F && inout.imag() == 3.1F );
  }


  { // dcomplex 
    complex<double> retval;
    complex<double> in( 3.14, 3.14 );
    complex<double> out;
    complex<double> inout( 3.14, 3.14 );
    Args::Cdcomplex obj = Args::Cdcomplex::_create();
 
    cout << "COMMENT: retval = obj.returnback( );" << endl;
    retval = obj.returnback( );
    MYASSERT( retval.real() == 3.14 && retval.imag() == 3.14);
    MYASSERT( obj.passin( in ) == true );
    MYASSERT( obj.passout( out ) == true && 
	      out.real() == 3.14 && out.imag() == 3.14 );
    MYASSERT( obj.passinout( inout ) == true && 
	      inout.real() == 3.14 && inout.imag() == -3.14 );
    cout << "COMMENT: retval = obj.passeverywhere( in, out, inout );" << endl;
    retval = obj.passeverywhere( in, out, inout );
    MYASSERT( retval.real() == 3.14 && retval.imag() == 3.14 &&
	      out.real() == 3.14 && out.imag() == 3.14 && 
	      inout.real() == 3.14 && inout.imag() == 3.14 );

  }

  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

