// 
// File:        ArgsTest.java
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.4 $
// Date:        $Date: 2002/02/14 19:48:11 $
// Description: argument regression test case for Java calling other languages
// 

/**
 * The following class runs the argument regression test cases for Java.
 */
public class ArgsTest {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Check the results of the test case.
   */
  private static void check(int expected, boolean pass, String test) {
    System.out.println("PART " + String.valueOf(++s_part));
    System.out.println("COMMENT " + test);
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (expected == UNSUPPORTED) {
      System.out.println(s_results[expected]);
      if (s_result == PASS) {
        s_result = XFAIL;
      }
    } else if (expected == PASS) {
      System.out.println(s_results[pass ? PASS : FAIL]);
      if (!pass) {
        s_result = FAIL;
      }
    } else if (expected == XFAIL) {
      System.out.println(s_results[pass ? XPASS : XFAIL]);
      if (pass) {
        s_result = FAIL;
      } else if (s_result > XFAIL) {
        s_result = XFAIL;
      }
    }
  }

  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    try {
      /*
       * Begin the test
       */
      System.out.println("NPARTS -1");

      s_part   = 0;
      s_result = PASS;

      /*
       * Boolean arguments
       */
      if (true) {
        Args.Cbool obj = new Args.Cbool();

        SIDL.Boolean.Holder out   = new SIDL.Boolean.Holder(false);
        SIDL.Boolean.Holder inout = new SIDL.Boolean.Holder(true);

        check(PASS,
              (obj.returnback() == true),
             "(obj.returnback() == true)");
        check(PASS,
              (obj.passin(true) == true),
             "(obj.passin(true) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == true),
             "(obj.passout(out) == true && out.get() == true)");
        check(PASS,
              (obj.passinout(inout) == true && inout.get() == false),
             "(obj.passinout(inout) == true && inout.get() == false)");
        check(PASS,
              (obj.passeverywhere(true, out, inout) == true
            && out.get() == true
            && inout.get() == true),
             "(obj.passeverywhere(true, out, inout) == true"
        + " && out.get() == true"
        + " && inout.get() == true)");
      }

      /*
       * Character arguments
       */
      if (true) {
        Args.Cchar obj = new Args.Cchar();

        SIDL.Character.Holder out   = new SIDL.Character.Holder();
        SIDL.Character.Holder inout = new SIDL.Character.Holder('A');

        check(PASS,
              (obj.returnback() == '3'),
             "(obj.returnback() == '3')");
        check(PASS,
              (obj.passin('3') == true),
             "(obj.passin('3') == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == '3'),
             "(obj.passout(out) == true && out.get() == '3')");
        check(PASS,
              (obj.passinout(inout) == true && inout.get() == 'a'),
             "(obj.passinout(inout) == true && inout.get() == 'a')");
        check(PASS,
              (obj.passeverywhere('3', out, inout) == '3' 
            && out.get() == '3'
            && inout.get() == 'A'),
             "(obj.passeverywhere('3', out, inout) == '3'"
        + " && out.get() == '3'"
        + " && inout.get() == 'A')");
      }

      /*
       * Integer arguments
       */
      if (true) {
        Args.Cint obj = new Args.Cint();

        SIDL.Integer.Holder out   = new SIDL.Integer.Holder();
        SIDL.Integer.Holder inout = new SIDL.Integer.Holder(3);

        check(PASS,
              (obj.returnback() == 3),
             "(obj.returnback() == 3)");
        check(PASS,
              (obj.passin(3) == true),
             "(obj.passin(3) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == 3),
             "(obj.passout(out) == true && out.get() == 3)");
        check(PASS,
              (obj.passinout(inout) == true && inout.get() == -3),
             "(obj.passinout(inout) == true && inout.get() == -3)");
        check(PASS,
              (obj.passeverywhere(3, out, inout) == 3 
            && out.get() == 3
            && inout.get() == 3),
             "(obj.passeverywhere(3, out, inout) == 3"
        + " && out.get() == 3"
        + " && inout.get() == 3)");
      }

      /*
       * Long arguments
       */
      if (true) {
        Args.Clong obj = new Args.Clong();

        SIDL.Long.Holder out   = new SIDL.Long.Holder();
        SIDL.Long.Holder inout = new SIDL.Long.Holder(3);

        check(PASS,
              (obj.returnback() == 3),
             "(obj.returnback() == 3)");
        check(PASS,
              (obj.passin(3) == true),
             "(obj.passin(3) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == 3),
             "(obj.passout(out) == true && out.get() == 3)");
        check(PASS,
              (obj.passinout(inout) == true && inout.get() == -3),
             "(obj.passinout(inout) == true && inout.get() == -3)");
        check(PASS,
              (obj.passeverywhere(3, out, inout) == 3 
            && out.get() == 3
            && inout.get() == 3),
             "(obj.passeverywhere(3, out, inout) == 3"
        + " && out.get() == 3"
        + " && inout.get() == 3)");
      }

      /*
       * Float arguments
       */
      if (true) {
        Args.Cfloat obj = new Args.Cfloat();

        SIDL.Float.Holder out   = new SIDL.Float.Holder();
        SIDL.Float.Holder inout = new SIDL.Float.Holder(3.1F);

        check(PASS,
              (obj.returnback() == 3.1F),
             "(obj.returnback() == 3.1F)");
        check(PASS,
              (obj.passin(3.1F) == true),
             "(obj.passin(3.1F) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == 3.1F),
             "(obj.passout(out) == true && out.get() == 3.1F)");
        check(PASS,
              (obj.passinout(inout) == true && inout.get() == -3.1F),
             "(obj.passinout(inout) == true && inout.get() == -3.1F)");
        check(PASS,
              (obj.passeverywhere(3.1F, out, inout) == 3.1F
            && out.get() == 3.1F
            && inout.get() == 3.1F),
             "(obj.passeverywhere(3.1F, out, inout) == 3.1F"
        + " && out.get() == 3.1F"
        + " && inout.get() == 3.1F)");
      }

      /*
       * Double arguments
       */
      if (true) {
        Args.Cdouble obj = new Args.Cdouble();

        SIDL.Double.Holder out   = new SIDL.Double.Holder();
        SIDL.Double.Holder inout = new SIDL.Double.Holder(3.14);

        check(PASS,
              (obj.returnback() == 3.14),
             "(obj.returnback() == 3.14)");
        check(PASS,
              (obj.passin(3.14) == true),
             "(obj.passin(3.14) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == 3.14),
             "(obj.passout(out) == true && out.get() == 3.14)");
        check(PASS,
              (obj.passinout(inout) == true && inout.get() == -3.14),
             "(obj.passinout(inout) == true && inout.get() == -3.14)");
        check(PASS,
              (obj.passeverywhere(3.14, out, inout) == 3.14
            && out.get() == 3.14
            && inout.get() == 3.14),
             "(obj.passeverywhere(3.14, out, inout) == 3.14"
        + " && out.get() == 3.14"
        + " && inout.get() == 3.1)");
      }

      /*
       * FComplex arguments
       */
      if (true) {
        Args.Cfcomplex obj = new Args.Cfcomplex();

        SIDL.FloatComplex retval       = null;
        SIDL.FloatComplex in           = new SIDL.FloatComplex(3.1F, 3.1F);
        SIDL.FloatComplex.Holder out   = new SIDL.FloatComplex.Holder();
        SIDL.FloatComplex.Holder inout = new SIDL.FloatComplex.Holder(
                                           new SIDL.FloatComplex(3.1F, 3.1F));

        check(PASS,
              ((retval = obj.returnback()) != null
            && retval.real() == 3.1F && retval.imag() == 3.1F),
             "((retval = obj.returnback()) != null)"
        + " && (retval.real() == 3.1F) && (retval.imag() == 3.1F))");
        check(PASS,
              (obj.passin(in) == true),
             "(obj.passin(in) == true)");
        check(PASS,
              (obj.passout(out) == true
            && out.get().real() == 3.1F && out.get().imag() == 3.1F),
             "(obj.passout(out) == true"
        + " && out.get().real() == 3.1F && out.get().imag() == 3.1F)");
        check(PASS,
              (obj.passinout(inout) == true
            && inout.get().real() == 3.1F && inout.get().imag() == -3.1F),
             "(obj.passinout(inout) == true"
        + " && inout.get().real() == 3.1F && inout.get().imag() == -3.1F)");
        check(PASS,
              ((retval = obj.passeverywhere(in, out, inout)) != null
            && retval.real() == 3.1F && retval.imag() == 3.1F
            && out.get().real() == 3.1F && out.get().imag() == 3.1F
            && inout.get().real() == 3.1F && inout.get().imag() == 3.1F),
             "((retval = obj.passeverywhere(in, out, inout)) != null"
        + " && retval.real() == 3.1F && retval.imag() == 3.1F"
        + " && out.get().real() == 3.1F && out.get().imag() == 3.1F"
        + " && inout.get().real() == 3.1F && inout.get().imag() == 3.1F)");
      }

      /*
       * DComplex arguments
       */
      if (true) {
        Args.Cdcomplex obj = new Args.Cdcomplex();

        SIDL.DoubleComplex retval       = null;
        SIDL.DoubleComplex in           = new SIDL.DoubleComplex(3.14, 3.14);
        SIDL.DoubleComplex.Holder out   = new SIDL.DoubleComplex.Holder();
        SIDL.DoubleComplex.Holder inout = new SIDL.DoubleComplex.Holder(
                                            new SIDL.DoubleComplex(3.14, 3.14));

        check(PASS,
              ((retval = obj.returnback()) != null
            && retval.real() == 3.14 && retval.imag() == 3.14),
             "((retval = obj.returnback()) != null)"
        + " && (retval.real() == 3.14) && (retval.imag() == 3.14))");
        check(PASS,
              (obj.passin(in) == true),
             "(obj.passin(in) == true)");
        check(PASS,
              (obj.passout(out) == true
            && out.get().real() == 3.14 && out.get().imag() == 3.14),
             "(obj.passout(out) == true"
        + " && out.get().real() == 3.14 && out.get().imag() == 3.14)");
        check(PASS,
              (obj.passinout(inout) == true
            && inout.get().real() == 3.14 && inout.get().imag() == -3.14),
             "(obj.passinout(inout) == true"
        + " && inout.get().real() == 3.14 && inout.get().imag() == -3.14)");
        check(PASS,
              ((retval = obj.passeverywhere(in, out, inout)) != null
            && retval.real() == 3.14 && retval.imag() == 3.14
            && out.get().real() == 3.14 && out.get().imag() == 3.14
            && inout.get().real() == 3.14 && inout.get().imag() == 3.14),
             "((retval = obj.passeverywhere(in, out, inout)) != null"
        + " && retval.real() == 3.14 && retval.imag() == 3.14"
        + " && out.get().real() == 3.14 && out.get().imag() == 3.14"
        + " && inout.get().real() == 3.14 && inout.get().imag() == 3.14)");
      }

      /*
       * Output final test results
       */

      System.out.println("TEST_RESULT " + s_results[s_result]);

      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */

    /*
     * Catch any unexpected exceptions and return a test failure
     */
    } catch (Throwable ex) {
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}
