!
! File:       arraytests.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Release:    $Name: release-0-8-8 $
! Revision:   @(#) $Revision: 1.4 $
! Date:       $Date: 2003/10/03 15:52:29 $
! Description:Exercise the FORTRAN interface
!
!
#include "ArrayTest_ArrayOps_fAbbrev.h"
#include "SIDL_bool_fAbbrev.h"
#include "SIDL_char_fAbbrev.h"
#include "SIDL_dcomplex_fAbbrev.h"
#include "SIDL_double_fAbbrev.h"
#include "SIDL_fcomplex_fAbbrev.h"
#include "SIDL_float_fAbbrev.h"
#include "SIDL_int_fAbbrev.h"
#include "SIDL_long_fAbbrev.h"
#include "SIDL_string_fAbbrev.h"

subroutine starttest(number)
  integer (selected_int_kind(9)) :: number
!    implicit none
  write (6, 100) number
100 format ('PART ', I4)
end subroutine starttest

subroutine reporttest(test, number, pass, fail, xfail, python)
  integer (kind=selected_int_kind(9)) :: number, pass, fail, xfail
  logical                             :: test, python
!    implicit none
  if (test) then
     write (6, 100) number, 'PASS'
     pass = pass + 1
  else
     if (python) then
        write (6, 100) number, 'XFAIL'
        xfail = xfail + 1
     else
        write (6, 100) number, 'FAIL'
        fail = fail + 1
     endif
  endif
100 format ('RESULT', 1x, i2, 1x, A5)
  number = number + 1
end subroutine reporttest

logical function my_isprime(num)
  integer (selected_int_kind(18)) :: num
!    implicit none
  integer (selected_int_kind(18)) :: i
  i = 3
  do while (i*i .le. num)
     if (mod(num,i) .eq. 0) then
        my_isprime = .false.
        return
     endif
     i = i + 1
  enddo
  my_isprime = .true.
  return
end function my_isprime


integer (selected_int_kind(18)) function my_nextprime(prev)
  integer (selected_int_kind(18)) :: prev
!    implicit none
  logical :: my_isprime
  if (prev .le. 1) then
     my_nextprime = 2
     return
  endif
  if (prev .eq. 2) then
     my_nextprime = 3
     return
  endif
  prev = prev + 2
  do while (.not. my_isprime(prev))
     prev = prev + 2
  enddo
  my_nextprime = prev
  return
end function my_nextprime

subroutine my_force_float(f)
  real(selected_real_kind(6,37)) :: f
  return
end subroutine my_force_float

subroutine my_force_fcomplex(f)
  complex(selected_real_kind(6,37)) :: f
  return
end subroutine my_force_fcomplex

subroutine checkBoolArrays(test, pass, fail, xfail, python)
  use SIDL_bool_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_bool_1d) :: barray
  
  call set_null(barray)

  call starttest(test)
  call createBool(217,barray)
  call reporttest(not_null(barray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseBool(barray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(barray)

  call set_null(barray)

  call makeBool(218, barray)

  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseBool(barray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(barray)

  call set_null(barray)

  call makeBool(9, barray)
  call starttest(test)
  call reverseBool(barray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  call deleteRef(barray)

  call set_null(barray)

  call starttest(test)
  call makeBool(-1, barray)
  call reporttest(is_null(barray), test, pass, fail, xfail, python)
  
  if (not_null(barray)) then
     call deleteRef(barray)
  endif
  
end subroutine CheckBoolArrays

subroutine CheckCharArrays(test, pass, fail, xfail, python)
  use SIDL_char_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_char_1d) :: carray

  call set_null(carray)

  call starttest(test)
  call createChar(217,carray)
  call reporttest(not_null(carray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseChar(carray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(carray)

  call set_null(carray)

  call makeChar(218, carray)

  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseChar(carray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(carray)

  call set_null(carray)

  call makeChar(9, carray)
  call starttest(test)
  call reverseChar(carray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(carray)

  call set_null(carray)

  call starttest(test)
  call makeChar(-1, carray)
  call reporttest(is_null(carray), test, pass, fail, xfail, python)
  
  if (not_null(carray)) then
     call deleteRef(carray)
  endif
  
end subroutine CheckCharArrays

subroutine CheckIntArrays(test, pass, fail, xfail, python)
  use SIDL_int_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_int_1d) :: iarray

  call set_null(iarray)

  call starttest(test)
  call createInt(217,iarray)
  call reporttest(not_null(iarray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseInt(iarray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(iarray)

  call set_null(iarray)

  call makeInt(218, iarray)

  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseInt(iarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(iarray)

  call set_null(iarray)

  call makeInt(9, iarray)
  call starttest(test)
  call reverseInt(iarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(iarray)

  call set_null(iarray)

  call starttest(test)
  call makeInt(-1, iarray)
  call reporttest(is_null(iarray), test, pass, fail, xfail, python)
  
  if (not_null(iarray)) then
     call deleteRef(iarray)
  endif
  
end subroutine CheckIntArrays

subroutine CheckLongArrays(test, pass, fail, xfail, python)
  use SIDL_long_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_long_1d) :: larray

  call set_null(larray)

  call starttest(test)
  call createLong(217,larray)
  call reporttest(not_null(larray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseLong(larray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(larray)

  call set_null(larray)

  call makeLong(218, larray)

  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseLong(larray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(larray)

  call set_null(larray)

  call makeLong(9, larray)
  call starttest(test)
  call reverseLong(larray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(larray)

  call set_null(larray)

  call starttest(test)
  call makeLong(-1, larray)
  call reporttest(is_null(larray), test, pass, fail, xfail, python)
  
  if (not_null(larray)) then
     call deleteRef(larray)
  endif
  
end subroutine CheckLongArrays

subroutine CheckStringArrays(test, pass, fail, xfail, python)
  use SIDL_string_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_string_1d) :: sarray

  call set_null(sarray)

  call starttest(test)
  call createString(217,sarray)
  call reporttest(not_null(sarray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseString(sarray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(sarray)

  call set_null(sarray)

  call makeString(218, sarray)

  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseString(sarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(sarray)

  call set_null(sarray)

  call makeString(9, sarray)
  call starttest(test)
  call reverseString(sarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(sarray)

  call set_null(sarray)

  call starttest(test)
  call makeString(-1, sarray)
  call reporttest(is_null(sarray), test, pass, fail, xfail, python)
  
  if (not_null(sarray)) then
     call deleteRef(sarray)
  endif
  
end subroutine CheckStringArrays

subroutine CheckDoubleArrays(test, pass, fail, xfail, python)
  use SIDL_double_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_double_1d) :: darray

  call set_null(darray)

  call starttest(test)
  call createDouble(217,darray)
  call reporttest(not_null(darray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseDouble(darray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(darray)

  call set_null(darray)

  call makeDouble(218, darray)

  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseDouble(darray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(darray)

  call set_null(darray)

  call makeDouble(9, darray)
  call starttest(test)
  call reverseDouble(darray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(darray)

  call set_null(darray)

  call starttest(test)
  call makeDouble(-1, darray)
  call reporttest(is_null(darray), test, pass, fail, xfail, python)
  
  if (not_null(darray)) then
     call deleteRef(darray)
  endif
  
end subroutine CheckDoubleArrays

subroutine CheckFloatArrays(test, pass, fail, xfail, python)
  use SIDL_float_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_float_1d) :: farray

  call set_null(farray)

  call starttest(test)
  call createFloat(217,farray)
  call reporttest(not_null(farray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseFloat(farray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(farray)

  call set_null(farray)

  call makeFloat(218, farray)

  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseFloat(farray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(farray)

  call set_null(farray)

  call makeFloat(9, farray)
  call starttest(test)
  call reverseFloat(farray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(farray)

  call set_null(farray)

  call starttest(test)
  call makeFloat(-1, farray)
  call reporttest(is_null(farray), test, pass, fail, xfail, python)
  
  if (not_null(farray)) then
     call deleteRef(farray)
  endif
  
end subroutine CheckFloatArrays

subroutine CheckFcomplexArrays(test, pass, fail, xfail, python)
  use SIDL_fcomplex_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_fcomplex_1d) :: fcarray

  call set_null(fcarray)

  call starttest(test)
  call createFcomplex(217,fcarray)
  call reporttest(not_null(fcarray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseFcomplex(fcarray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(fcarray)

  call set_null(fcarray)

  call makeFcomplex(218, fcarray)

  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseFcomplex(fcarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(fcarray)

  call set_null(fcarray)

  call makeFcomplex(9, fcarray)
  call starttest(test)
  call reverseFcomplex(fcarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(fcarray)

  call set_null(fcarray)

  call starttest(test)
  call makeFcomplex(-1, fcarray)
  call reporttest(is_null(fcarray), test, pass, fail, xfail, python)
  
  if (not_null(fcarray)) then
     call deleteRef(fcarray)
  endif
  
end subroutine CheckFcomplexArrays

subroutine CheckDcomplexArrays(test, pass, fail, xfail, python)
  use SIDL_dcomplex_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(SIDL_dcomplex_1d) :: dcarray

  call set_null(dcarray)

  call starttest(test)
  call createDcomplex(217,dcarray)
  call reporttest(not_null(dcarray), test, pass, fail, xfail, python)

  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseDcomplex(dcarray, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call deleteRef(dcarray)

  call set_null(dcarray)

  call makeDcomplex(218, dcarray)

  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call reverseDcomplex(dcarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)
  
  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  
  call deleteRef(dcarray)

  call set_null(dcarray)

  call makeDcomplex(9, dcarray)
  call starttest(test)
  call reverseDcomplex(dcarray, .false., retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(.not. retval, test, pass, fail, xfail, python)
  call deleteRef(dcarray)

  call set_null(dcarray)

  call starttest(test)
  call makeDcomplex(-1, dcarray)
  call reporttest(is_null(dcarray), test, pass, fail, xfail, python)
  
  if (not_null(dcarray)) then
     call deleteRef(dcarray)
  endif
  
end subroutine CheckDcomplexArrays

subroutine check2DoubleArrays(test, pass, fail, xfail,python)
  use SIDL_double_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test, pass, fail, xfail
  logical, intent(in) :: python
!    implicit none
  integer :: i, j
  logical ::  retval
  real(selected_real_kind(15,307)) :: tmp
  type(SIDL_double_2d) :: darray
  call starttest(test)
  call create2Double(17,35,darray)
  call reporttest(not_null(darray), test, pass, fail, xfail, python)

  call starttest(test)
  call check2Double(darray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)

  call starttest(test)
  do i = 0, 16
     do j = 0, 34
        darray%d_data(i,j) = 2.0**(i-j)
     enddo
  enddo
  call check2Double(darray, retval)
  call reporttest(retval, test, pass, fail, xfail, python)


  call deleteRef(darray)
  call set_null(darray)

  call starttest(test)
  call create2Double(-1, -1, darray)
  call reporttest(is_null(darray), test, pass, fail, xfail, python)

  
end subroutine check2DoubleArrays


program arraytests
  integer (selected_int_kind(9)) :: test, pass, fail, xfail
  character (len=80)             :: language
  logical                        :: ispython
  language = ' '
  if (IArgc() .eq. 1) then
     call GetArg(1, language)
  endif
  ispython = language .eq. 'Python'
  test = 1
  pass = 0
  xfail = 0
  fail = 0

  write(6,120) 85

  write(6,110) 'Boolean tests'
  call CheckBoolArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'Char tests'
  call CheckCharArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'Int tests'
  call CheckIntArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'Long tests'
  call CheckLongArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'String tests'
  call CheckStringArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'Double tests'
  call CheckDoubleArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'Float tests'
  call CheckFloatArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'Fcomplex tests'
  call CheckFcomplexArrays(test, pass, fail, xfail, ispython)

  write(6,110) 'Dcomplex tests'
  call CheckDcomplexArrays(test, pass, fail, xfail, ispython)

  write (6, 110) '2D double tests'
  call Check2DoubleArrays(test, pass, fail, xfail, ispython)

  if (fail .eq. 0) then
     if (pass .eq. 85 .and. xfail .eq. 0) then
        write(6, 100) 'PASS'
     else
        write(6, 100) 'XFAIL'
     endif
  else
     write(6, 100) 'FAIL'
  endif
  
100 format ('TEST_RESULT', 1x, a5)
110 format ('COMMENT:', 1x, a20)
120 format ('NPARTS', 1x, i4)
end program arraytests
