!
! File:       exceptionclient.F90
! Copyright:  (c) 2001-2002 The Regents of the University of California
! Release:    $Name: release-0-8-8 $
! Revision:   @(#) $Revision: 1.6 $
! Date:       $Date: 2003/02/07 18:51:16 $
! Description:Simple F90 exception test client
!
!
#include "SIDL_BaseException_fAbbrev.h"
#include "ExceptionTest_Fib_fAbbrev.h"

subroutine starttest(number)
  implicit none
  integer (selected_int_kind(9)) :: number
  write (6, 100) number
100 format ('PART ', I4)
end subroutine starttest

subroutine reporttest(test, number, pass, fail)
  implicit none
  integer (selected_int_kind(9)) :: number, pass, fail
  logical                        :: test
  if (test) then
     write (6, 100) number, 'PASS'
     pass = pass + 1
  else
     write (6, 100) number, 'FAIL'
     fail = fail + 1
  endif
100 format ('RESULT', 1x, i2, 1x, A4)
  number = number + 1
end subroutine reporttest

subroutine reportexc(exc)
  use SIDL_BaseException
  implicit none
  type(SIDL_BaseException_t) :: exc
  character (len=100)             :: msg
  character (len=1024)            :: trace

  call getNote(exc, msg)
  write (6, *) msg
  call getTrace(exc, trace)
  write (6, *) trace
end subroutine reportexc

subroutine testnone(fib, test, pass, fail)
  use ExceptionTest_Fib
  use SIDL_BaseException
  implicit none
  type(ExceptionTest_Fib_t) :: fib
  type(SIDL_BaseException_t) :: exc
  integer (selected_int_kind(9))  :: test, pass, fail
  integer (selected_int_kind(9)) :: retval

  call starttest(test)
  call getFib(fib, 10, 25, 200, 0, retval, exc)
  if (is_null(exc)) then
     call reporttest(.true., test, pass, fail)
     write (6, 100) retval
  else
     call reporttest(.false., test, pass, fail)
     call reportexc(exc)
     call deleteRef(exc)
  endif
100 format ('fib= ', I4)
end subroutine testnone

subroutine testneg(fib, test, pass, fail)
  use SIDL_BaseException
  use ExceptionTest_Fib
  implicit none
  type(ExceptionTest_Fib_t) :: fib
  type(SIDL_BaseException_t) :: exc
  integer (selected_int_kind(9))  :: test, pass, fail
  integer (selected_int_kind(9)) :: retval
  logical                         :: isone

  call starttest(test)
  call getFib(fib, -1, 10, 10, 0, retval, exc)
  if (is_null(exc)) then
     call reporttest(.false., test, pass, fail)
     write (6, 100) retval
  else
     call isType(exc, &
          'ExceptionTest.NegativeValueException', isone)
     if (isone .eqv. .true.) then
        call reporttest(.true., test, pass, fail)
     else
        call reporttest(.false., test, pass, fail)
     endif
     call reportexc(exc)
     call deleteRef(exc)
  endif
100 format ('fib= ', I4)
end subroutine testneg

subroutine testdeep(fib, test, pass, fail)
  use SIDL_BaseException
  use ExceptionTest_Fib
  implicit none
  type(ExceptionTest_Fib_t) :: fib
  type(SIDL_BaseException_t) :: exc
  integer (selected_int_kind(9))  :: test, pass, fail
  integer (selected_int_kind(9)) :: retval
  logical                         :: isone

  call starttest(test)
  call getFib (fib, 10, 1, 100, 0, retval, exc)
  if (is_null(exc)) then
     call reporttest(.false., test, pass, fail)
     write (6, 100) retval
  else
     call isType(exc, 'ExceptionTest.TooDeepException', &
          isone)
     if (isone .eqv. .true.) then
        call reporttest(.true., test, pass, fail)
     else
        call reporttest(.false., test, pass, fail)
     endif
     call reportexc(exc)
     call deleteRef(exc)
  endif
100 format ('fib= ', I4)
end subroutine testdeep

subroutine testbig(fib, test, pass, fail)
  use SIDL_BaseException
  use ExceptionTest_Fib
  implicit none
  type(ExceptionTest_Fib_t) :: fib
  type(SIDL_BaseException_t) :: exc
  integer (selected_int_kind(9))  :: test, pass, fail
  integer (selected_int_kind(9)) :: retval
  integer (selected_int_kind(9)), parameter :: n = 10, max_depth = 100, &
       depth = 0, maxvalue = 1
  logical                         :: isone

  call starttest(test)
  call getFib(fib, n, max_depth, depth, maxvalue, retval, exc)
  if (is_null(exc)) then
     call reporttest(.false., test, pass, fail)
     write (6, 100) retval
  else
     call isType(exc, 'ExceptionTest.TooBigException', &
          isone)
     if (isone .eqv. .true.) then
        call reporttest(.true., test, pass, fail)
     else
        call reporttest(.false., test, pass, fail)
     endif
     call reportexc(exc)
     call deleteRef(exc)
  endif
100 format ('fib= ', I4)
end subroutine testbig


program exceptionclient
  use ExceptionTest_Fib
  implicit none
  integer (selected_int_kind(9))  :: test, pass, fail
  type(ExceptionTest_Fib_t) :: fib

  call new(fib)

  test = 1
  pass = 0
  fail = 0

  write(6,130) 4
  write(6,110)
  write(6,120) 'No Exception test            '
  call testnone(fib, test, pass, fail)
  write(6,110)
  write(6,120) 'Negative Value Exception test'
  call testneg(fib, test, pass, fail)
  write(6,110)
  write(6,120) 'Too Deep Exception test      '
  call testdeep(fib, test, pass, fail)
  write(6,110)
  write(6,120) 'Too Big Exception test       '
  call testbig(fib, test, pass, fail)

  call deleteRef(fib)

  write(6, 110) 
  if ((fail .eq. 0) .and. (pass .eq. 4)) then
     write(6, 100) 'PASS'
  else
     write(6, 100) 'FAIL'
  endif
100 format ('TEST_RESULT', 1x, a4)
110 format (' ')
120 format ('COMMENT:', 1x, a30)
130 format ('NPARTS', 1x, i4)
end program exceptionclient
