// 
// File:        ExceptionTestDriver.java
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.3 $
// Date:        $Date: 2002/09/30 23:01:00 $
// Description: exception regression test case for Java calling other languages
// 

/**
 * The following class runs the exception regression test cases for Java.
 */
public class ExceptionTestDriver {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Declare the following part of the test.
   */
  private static void declare() {
    System.out.println("PART " + String.valueOf(++s_part));
  }

  /**
   * Check the results of the test case.
   */
  private static void check(int expected, boolean pass, String test) {
    System.out.println("COMMENT " + test);
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (expected == UNSUPPORTED) {
      System.out.println(s_results[expected]);
      if (s_result == PASS) {
        s_result = XFAIL;
      }
    } else if (expected == PASS) {
      System.out.println(s_results[pass ? PASS : FAIL]);
      if (!pass) {
        s_result = FAIL;
      }
    } else if (expected == XFAIL) {
      System.out.println(s_results[pass ? XPASS : XFAIL]);
      if (pass) {
        s_result = FAIL;
      } else if (s_result > XFAIL) {
        s_result = XFAIL;
      }
    }
  }

  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    try {
      /*
       * Begin the test
       */
      System.out.println("NPARTS 4");

      s_part   = 0;
      s_result = PASS;

      /*
       * No exception thrown
       */

      ExceptionTest.Fib fib = new ExceptionTest.Fib();
      try {
        declare();
        fib.getFib(10, 25, 200, 0);
        check(PASS, true, "no exception thrown (none expected)");
      } catch (java.lang.Exception ex) {
        check(PASS, false, "unexpected exception thrown");
      }

      /*
       * Throw a NegativeValueException
       */

      try {
        declare();
        fib.getFib(-1, 10, 10, 0);
        check(PASS, false, "no exception (NegativeValueException expected)");
      } catch (ExceptionTest.NegativeValueException ex) {
        check(PASS, true, "NegativeValueException thrown (as expected)");
      } catch (java.lang.Exception ex) {
        check(PASS, false, "unexpected exception thrown");
      }

      /*
       * Throw a TooDeepException as a FibException
       */

      try {
        declare();
        fib.getFib(10, 1, 1000, 0);
        check(PASS, false, "no exception (TooDeepException expected)");
      } catch (ExceptionTest.TooDeepException ex) {
        check(PASS, true, "TooDeepException thrown (as expected)");
      } catch (ExceptionTest.FibException ex) {
        if (ex.isType("ExceptionTest.TooDeepException")) {
          check(XFAIL, false, "TooDeepException thrown (as expected)");
        } else {
          check(PASS, false, "unexpected exception thrown");
        }
      } catch (java.lang.Exception ex) {
        check(PASS, false, "unexpected exception thrown");
      }

      /*
       * Throw a TooBigException as a FibException
       */

      try {
        declare();
        fib.getFib(10, 1000, 1, 0);
        check(PASS, false, "no exception (TooBigException expected)");
      } catch (ExceptionTest.TooBigException ex) {
        check(PASS, true, "TooBigException thrown (as expected)");
      } catch (ExceptionTest.FibException ex) {
        if (ex.isType("ExceptionTest.TooBigException")) {
          check(XFAIL, false, "TooBigException thrown (as expected)");
        } else {
          check(PASS, false, "unexpected exception thrown");
        }
      } catch (java.lang.Exception ex) {
        check(PASS, false, "unexpected exception thrown");
      }

      /*
       * Output final test results
       */

      System.out.println("TEST_RESULT " + s_results[s_result]);

      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */
    /*
     * Catch any unexpected exceptions and return a test failure
     */
    } catch (Throwable ex) {
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}
