
#include <stddef.h>
#include <stdio.h>
#include <iostream>
using namespace std;

#include "Inherit.hh"

enum { fail = 0, xfail = 1, pass = 2, xpass = 3, unsupported = 4};
static const char *result_string[] = {
  "FAIL",
  "XFAIL",
  "PASS",
  "XPASS",
  "UNSUPPORTED"
};

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

static void report_test(int part, int result, int &final_result)
{
  cout << "RESULT " << part << ' ' << result_string[result] << endl;
  if (result < final_result) {
    final_result = result;
  }
}

#define INHERITTEST(method, expected) \
{ \
  cout << "PART " << ++part_no << endl \
       << "COMMENT: Method " << #method << " should return " << expected \
       << endl; \
  string str = method; \
  magicNumber = clearstack(magicNumber); \
  result = (str == expected) ? pass : fail; \
  cout << "COMMENT: Method returned " << str << endl; \
  report_test(part_no, result, final_result); \
}


int main( int argc, char * argv[] ) { 

  int result = pass;
  int final_result = pass;
  int magicNumber = 1;
  int part_no = 0;
  cout << endl;
  cout << "NPARTS -1" << endl;

  { 
    Inherit::C  c = Inherit::C::_create();
    cout << "Class C:" << endl;
    INHERITTEST(c.c(), "C.c");
    
    cout << endl << endl;
  }

  { 
    Inherit::D d = Inherit::D::_create();
    cout << "Class D: inheritance of interface A" << endl;
    INHERITTEST(d.a(), "D.a");
    cout << endl;
    INHERITTEST(d.d(), "D.d");
    cout << endl << endl;


    cout << "Class D: via interface A" << endl;
    Inherit::A a = d;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting D to interace A" << endl;
    if ( !a ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(a.a(), "D.a");
    }
    cout << endl << endl;
  }

  { 
    Inherit::E e = Inherit::E::_create(); 
    cout << "Class E: inheritance of class C" << endl;
    INHERITTEST(e.c(), "C.c");
    cout << endl;
    INHERITTEST(e.e(), "E.e");
    cout << endl << endl;

    cout << "Class E: via class C (C.c not overridden)" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting E to class C" << endl;
    Inherit::C c = e;
    if ( !c ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(c.c(), "C.c");
    }
    cout << endl << endl;
  }

  { 
    Inherit::E2 e2 = Inherit::E2::_create(); 
    cout << "Class E2: inheritance of class C" << endl;
    INHERITTEST(e2.c(), "E2.c");
    cout << endl;
    INHERITTEST(e2.e(), "E2.e");
    cout << endl << endl;

    cout << "Class E2: via class C (C.c overridden)" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting E2 to class C" << endl;
    Inherit::C c = e2;
    if ( !c ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(c.c(), "E2.c");
    }
    cout << endl << endl;
  }

  { 
    Inherit::F f = Inherit::F::_create();
    cout << "Class F: Multiple inheritance (no overriding)" << endl;
    INHERITTEST(f.a(), "F.a");
    cout << endl;
    INHERITTEST(f.b(), "F.b");
    cout << endl;
    INHERITTEST(f.c(), "C.c");
    cout << endl;
    INHERITTEST(f.f(), "F.f");
    cout << endl << endl;
    
    cout << "Class F: via interface A" << endl ;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting F to class A" << endl;
    Inherit::A a = f;
    if ( !a ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(a.a(), "F.a");
    }
    cout << endl << endl;

    cout << "Class F: via interface B" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting F to interface B" << endl;
    Inherit::B b = f;
    if ( !b ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(b.b(), "F.b");
    }
    cout << endl << endl;


    cout << "Class F: via class C (no overloading of C.c)" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting F to class C" << endl;
    Inherit::C c = f;
    if ( !c ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(c.c(), "C.c");
    } 
    cout << endl << endl;
  }

  { 
    Inherit::F2 f2 = Inherit::F2::_create();
    cout << "Class F2: Multiple inheritance (overrides C.c)" << endl;
    INHERITTEST(f2.a(), "F2.a");
    cout << endl;
    INHERITTEST(f2.b(), "F2.b");
    cout << endl;
    INHERITTEST(f2.c(), "F2.c");
    cout << endl;
    INHERITTEST(f2.f(), "F2.f");
    cout << endl << endl;
    
    cout << "Class F2: via interface A" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting F2 to interface A" << endl;
    Inherit::A a = f2;
    if ( !a ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(a.a(), "F2.a");
    }
    cout << endl << endl;

    cout << "Class F2: via interface B" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting F2 to interface B" << endl;
    Inherit::B b = f2;
    if ( !b ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(b.b(), "F2.b");
    }
    cout << endl << endl;

    cout << "Class F2: via class C (overloads C.c)" << endl ;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting F2 to class C" << endl;
    Inherit::C c = f2;
    if ( !c ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(c.c(), "F2.c");
    } 
    cout << endl << endl;
  }

  { 
    Inherit::G g = Inherit::G::_create();

    cout << "Class G: indirect multiple inheritance ( no overloads)" << endl;
    INHERITTEST(g.a(), "D.a");
    cout << endl;
    INHERITTEST(g.d(), "D.d");
    cout << endl;
    INHERITTEST(g.g(), "G.g");
    cout << endl << endl;

    
    cout << "Class G: via interface A" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting G to interface A" << endl;
    Inherit::A a = g;
    if ( !a ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(a.a(), "D.a");
    }
    cout << endl << endl;

    cout << "Class G: via class D" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting G to class D" << endl;
    Inherit::D d = g;
    if ( !d ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(d.a(), "D.a");
      INHERITTEST(d.d(), "D.d");
    }

    cout << endl << endl;
  }
  
  { 
    Inherit::G2 g2 = Inherit::G2::_create();

    cout << "Class G2: indirect multiple inheritance (overloads)" << endl;
    INHERITTEST(g2.a(), "G2.a");
    cout << endl;
    INHERITTEST(g2.d(), "G2.d");
    cout << endl;
    INHERITTEST(g2.g(), "G2.g");
    cout << endl << endl;

    
    cout << "Class G2: via interface A" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting G2 to interface A" << endl;
    Inherit::A a = g2;
    if ( !a ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(a.a(), "G2.a");
    }
    cout << endl << endl;

    cout << "Class G2: via class D" << endl;
    cout << "PART " << ++part_no << endl
         << "COMMENT: Casting G2 to class D" << endl;
    Inherit::D d = g2;
    if ( !d ) { 
      report_test(part_no, fail, final_result);
    } else { 
      report_test(part_no, pass, final_result);
      INHERITTEST(d.a(), "G2.a");
      INHERITTEST(d.d(), "G2.d");
    }
    cout << endl;

  }

  {
    Inherit::I i = Inherit::I::_create();
    cout << "Class I: implements abstract class H that implements A" << endl;
    INHERITTEST(i.a(), "I.a");
    INHERITTEST(i.h(), "I.h");
    
    cout << "Class I: via interface A\n";
    Inherit::A a = i;
    INHERITTEST(a.a(), "I.a");
    
    cout << "Class I: via abstract class H\n";
    Inherit::H h = i;
    INHERITTEST(h.a(), "I.a");
    INHERITTEST(h.h(), "I.h");
  }

  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

