#include <string>
#include <iostream>
using namespace std;
#include "objarg_Employee.hh"
#include "objarg_EmployeeArray.hh"

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " <<  #AAA << endl; \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  end_part( part_no, unsupported, &final_result );

struct TmpData_t {
  string name;
  int    age;
  float  salary;
  char   status;
};

struct TmpData_t TmpData[] = {
  { "John Smith", 35, 75.7e3, 'c' },
  { "Jane Doe", 40, 85.5e3, 'm' },
  { "Ella Vader", 64, 144.2e3, 'r' },
  { "Marge Inovera", 32, 483.2e3, 's' },
  { "Hughy Louis Dewey", 45, 182.9e3, 'm' },
  { "Heywood Yubuzof", 12, 20.8e3, 'x' },
  { "Picov Andropov", 90, 120.6e3, 'r' }
};

int main() {
  int result = pass; 
  int final_result = pass;
  int part_no = 0;
  int i;
  const int numEmp = sizeof(TmpData)/sizeof(struct TmpData_t);
  cout << "NPARTS 67\n";
  objarg::EmployeeArray a = objarg::EmployeeArray::_create();
  for(i = 0; i < numEmp; ++i) {
    objarg::Employee e = objarg::Employee::_create();
    MYASSERT(e.init(TmpData[i].name, TmpData[i].age, 
		    TmpData[i].salary, TmpData[i].status));
    MYASSERT(a.appendEmployee(e));
    MYASSERT(a.getLength() == (i+1));
    MYASSERT(e.isSame(a.at(i+1)));
    MYASSERT(e.getAge() == TmpData[i].age);
    MYASSERT(e.getSalary() == TmpData[i].salary);
    MYASSERT(e.getStatus() == TmpData[i].status);
  }
  for(i = 0; i < numEmp; ++i) {
    objarg::Employee e;
    int empInd = a.findByName(TmpData[i].name, e);
    MYASSERT(empInd == (i+1));
    if (empInd != 0) {
      MYASSERT(e.isSame(a.at(empInd)));
    }
  }
  objarg::Employee f = objarg::Employee::_create();
  f.init("Hire High", 21, 0, 's');
  MYASSERT(a.promoteToMaxSalary(f));
  MYASSERT(f.getSalary() == (float)483.2e3);
  MYASSERT(a.appendEmployee(f));
  f = objarg::Employee::_create();
  f.init("Amadeo Avogadro, conte di Quaregna", 225, 6.022045e23, 'd');
  MYASSERT(!a.promoteToMaxSalary(f));
  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}
