/*
 * File:        overloadtest.c
 * Copyright:   (c) 2001 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.6 $
 * Date:        $Date: 2003/08/06 17:03:22 $
 * Description: Overload Test C client
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Overload.h"

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

char* result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED" };
const int unsupported = 4;
const int fail  = 0;
const int xfail = 1;
const int pass  = 2;
const int xpass = 3;

static void declare_part( int * part_no )
{
  ++(*part_no);
  printf("PART %d\n", *part_no);
}

static void end_part(int part_no, int result, int *final_result)
{
  printf("RESULT %d %s\n", part_no, result_string[result]);
  if (result == xpass) {
    *final_result = fail;
  } else if ((result == unsupported) && (*final_result == pass)) { 
    *final_result = xfail;
  } else if (result < *final_result) { 
    *final_result = result;
  }
}

#define CHECK(FUNC,COMMENT)                 \
  declare_part(&part_no);                   \
  printf("COMMENT: %s\n", COMMENT);         \
  result = (FUNC) ? pass : fail;            \
  end_part(part_no, result, &final_result);


int main(int argc, char**argv)
{ 
  int result       = pass; 
  int final_result = pass;
  int part_no      = 0;

  double d1        = 1.0;
  float  f1        = 1.0F;
  int    i1        = 1;
  double did       = 2.0;
  double difd      = 3.0;
  const char*  ev  = "AnException";
  char *msg;
  char*        s1  = "test string";
  char*        sret;

  struct SIDL_dcomplex dc = { 1.1, 1.1 };
  struct SIDL_dcomplex dcret;
  struct SIDL_fcomplex fc = { 1.1F, 1.1F };
  struct SIDL_fcomplex fcret;

  Overload_Test        t  = Overload_Test__create ();
  Overload_AnException ae = Overload_AnException__create ();
  Overload_AClass      ac = Overload_AClass__create();
  Overload_BClass      bc = Overload_BClass__create();

  printf("NPARTS 19\n");
  CHECK(Overload_Test_getValue(t) == 1, 
        "checking empty argument to known value");

  CHECK(Overload_Test_getValueBool(t, TRUE) == TRUE, "checking bool");
  CHECK(Overload_Test_getValueDouble(t, d1) == d1, "checking double");
  dcret = Overload_Test_getValueDcomplex(t, dc);
  CHECK(dcret.real == dc.real && dcret.imaginary == dc.imaginary, 
        "checking dcomplex");
  CHECK(Overload_Test_getValueFloat(t, f1) == f1, "checking float");
  fcret = Overload_Test_getValueFcomplex(t, fc);
  CHECK(fcret.real == fc.real && fcret.imaginary == fc.imaginary, 
        "checking fcomplex");
  CHECK(Overload_Test_getValueInt(t, i1) == i1, "checking int");
  sret = Overload_Test_getValueString(t, s1);
  CHECK(sret && !strcmp(sret, s1), "checking string");
  if (sret) free ((void*)sret);

  CHECK(Overload_Test_getValueDoubleInt(t, d1, i1) == did, 
        "checking double int");
  CHECK(Overload_Test_getValueIntDouble(t, i1, d1) == did, 
        "checking int double");

  CHECK(Overload_Test_getValueDoubleIntFloat(t, d1, i1, f1) == difd, 
       "checking double int float");
  CHECK(Overload_Test_getValueIntDoubleFloat(t, i1, d1, f1) == difd, 
        "checking int double float");

  CHECK(Overload_Test_getValueDoubleFloatInt(t, d1, f1, i1) == difd, 
       "checking double float int");
  CHECK(Overload_Test_getValueIntFloatDouble(t, i1, f1, d1) == difd, 
        "checking int float double");

  CHECK(Overload_Test_getValueFloatDoubleInt(t, f1, d1, i1) == difd, 
       "checking float double int");
  CHECK(Overload_Test_getValueFloatIntDouble(t, f1, i1, d1) == difd, 
        "checking float int double");

  msg = Overload_Test_getValueException(t, ae);
  CHECK(msg && !strcmp(msg, ev), 
        "checking exception to known value");
  if (msg) free((void*)msg);

  CHECK(Overload_Test_getValueAClass(t, ac) == 2, 
        "checking AClass value to known value");

  CHECK(Overload_Test_getValueBClass(t, bc) == 2, 
        "checking BClass value to known value");

  printf("TEST_RESULT %s\n", result_string[final_result] );

  Overload_BClass_deleteRef (bc);
  Overload_AClass_deleteRef (ac);
  Overload_AnException_deleteRef (ae);
  Overload_Test_deleteRef (t);
  return 0;
}
