/*
 * File:          sort_IntegerContainer_Impl.c
 * Symbol:        sort.IntegerContainer-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for sort.IntegerContainer
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.IntegerContainer" (version 0.1)
 * 
 * Integer container.
 */

#include "sort_IntegerContainer_Impl.h"

/* DO-NOT-DELETE splicer.begin(sort.IntegerContainer._includes) */
#include <stdlib.h>
#include <stdio.h>
#include "sort_Integer.h"
/* DO-NOT-DELETE splicer.end(sort.IntegerContainer._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_IntegerContainer__ctor"

void
impl_sort_IntegerContainer__ctor(
  sort_IntegerContainer self)
{
  /* DO-NOT-DELETE splicer.begin(sort.IntegerContainer._ctor) */
  struct sort_IntegerContainer__data *dptr =
    malloc(sizeof(struct sort_IntegerContainer__data));
  if (dptr) {
    dptr->d_elements = NULL;
  }
  sort_IntegerContainer__set_data(self, dptr);
  /* DO-NOT-DELETE splicer.end(sort.IntegerContainer._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_IntegerContainer__dtor"

void
impl_sort_IntegerContainer__dtor(
  sort_IntegerContainer self)
{
  /* DO-NOT-DELETE splicer.begin(sort.IntegerContainer._dtor) */
  struct sort_IntegerContainer__data *dptr =
    sort_IntegerContainer__get_data(self);
  if (dptr) {
    if (dptr->d_elements) {
      sort_Integer__array_deleteRef(dptr->d_elements);
      dptr->d_elements = NULL;
    }
    free((void *)dptr);
    sort_IntegerContainer__set_data(self, NULL);
  }
  /* DO-NOT-DELETE splicer.end(sort.IntegerContainer._dtor) */
}

/*
 * This sets the container length and pseudo-randomly orders the
 * Integer elements contained.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_IntegerContainer_setLength"

void
impl_sort_IntegerContainer_setLength(
  sort_IntegerContainer self, int32_t len)
{
  /* DO-NOT-DELETE splicer.begin(sort.IntegerContainer.setLength) */
  if (len >= 0) {
    struct sort_IntegerContainer__data *dptr =
      sort_IntegerContainer__get_data(self);
    if (dptr) {
      int32_t i, j;
      if (dptr->d_elements) {
        sort_Integer__array_deleteRef(dptr->d_elements);
      }
      dptr->d_elements = sort_Integer__array_create1d(len);
      for(i = 0; i < len ; ++i ) {
        sort_Integer iptr = sort_Integer__create();
        sort_Integer_setValue(iptr, i+1);
        sort_Integer__array_set1(dptr->d_elements, i, iptr);
        sort_Integer_deleteRef(iptr);
      }
      /* shuffle the list */
      for(i = len - 1; i > 0; --i) {
        j = random() % (i + 1);
        if (j != i) {
          sort_IntegerContainer_swap(self, i, j);
        }
      }
    }
  }
  /* DO-NOT-DELETE splicer.end(sort.IntegerContainer.setLength) */
}

/*
 * Return the number of elements in the container.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_IntegerContainer_getLength"

int32_t
impl_sort_IntegerContainer_getLength(
  sort_IntegerContainer self)
{
  /* DO-NOT-DELETE splicer.begin(sort.IntegerContainer.getLength) */
  struct sort_IntegerContainer__data *dptr =
    sort_IntegerContainer__get_data(self);
  return (dptr && dptr->d_elements) ? 
    (sort_Integer__array_upper(dptr->d_elements, 0) - 
     sort_Integer__array_lower(dptr->d_elements, 0) + 1)  : 0;
  /* DO-NOT-DELETE splicer.end(sort.IntegerContainer.getLength) */
}

/*
 * Return -1 if element i is less than element j, 0 if element i
 * is equal to element j, or otherwise 1.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_IntegerContainer_compare"

int32_t
impl_sort_IntegerContainer_compare(
  sort_IntegerContainer self, int32_t i, int32_t j, sort_Comparator comp)
{
  /* DO-NOT-DELETE splicer.begin(sort.IntegerContainer.compare) */
  struct sort_IntegerContainer__data *dptr =
    sort_IntegerContainer__get_data(self);
  int result = 0;
  if (dptr && dptr->d_elements) {
    sort_Integer i1 = sort_Integer__array_get1(dptr->d_elements, i);
    sort_Integer i2 = sort_Integer__array_get1(dptr->d_elements, j);
    result = sort_Comparator_compare(comp,
                                     (SIDL_BaseInterface)i1,
                                     (SIDL_BaseInterface)i2);
    sort_Integer_deleteRef(i1);
    sort_Integer_deleteRef(i2);
  }
  return result;
  /* DO-NOT-DELETE splicer.end(sort.IntegerContainer.compare) */
}

/*
 * Swap elements i and j.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_IntegerContainer_swap"

void
impl_sort_IntegerContainer_swap(
  sort_IntegerContainer self, int32_t i, int32_t j)
{
  /* DO-NOT-DELETE splicer.begin(sort.IntegerContainer.swap) */
  struct sort_IntegerContainer__data *dptr =
    sort_IntegerContainer__get_data(self);
  if (dptr && dptr->d_elements) {
    const int32_t len = sort_IntegerContainer_getLength(self);
    if ((i >= 0) && (j >= 0) && (i < len) && (j < len)) {
      sort_Integer i1 = sort_Integer__array_get1(dptr->d_elements, i);
      sort_Integer i2 = sort_Integer__array_get1(dptr->d_elements, j);
      sort_Integer__array_set1(dptr->d_elements, i, i2);
      sort_Integer__array_set1(dptr->d_elements, j, i1);
      sort_Integer_deleteRef(i1);
      sort_Integer_deleteRef(i2);
    }
    else {
      fprintf(stderr, "\
sort::IntegerContainer::swap index out of bounds swap(%d, %d) len (%d)\n",
              i, j, len);
      exit(2);
    }
  }
  /* DO-NOT-DELETE splicer.end(sort.IntegerContainer.swap) */
}

/*
 * Print elements s through e-1
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_IntegerContainer_output"

void
impl_sort_IntegerContainer_output(
  sort_IntegerContainer self, int32_t s, int32_t e)
{
  /* DO-NOT-DELETE splicer.begin(sort.IntegerContainer.output) */
  struct sort_IntegerContainer__data *dptr =
    sort_IntegerContainer__get_data(self);
  if (dptr && dptr->d_elements) {
    printf("COMMENT: list");
    while (s < e) {
      sort_Integer i = sort_Integer__array_get1(dptr->d_elements, s++);
      printf(" %d", sort_Integer_getValue(i));
      sort_Integer_deleteRef(i);
    }
    putchar('\n');
  }
  /* DO-NOT-DELETE splicer.end(sort.IntegerContainer.output) */
}
