// 
// File:          sort_MergeSort_Impl.cc
// Symbol:        sort.MergeSort-v0.1
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for sort.MergeSort
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 
#include "sort_MergeSort_Impl.hh"

// DO-NOT-DELETE splicer.begin(sort.MergeSort._includes)
static void
mergeLists(sort::Container  &elems,
           sort::Comparator &comp,
           sort::Counter    &cmp,
           sort::Counter    &swp,
           int32_t          start,
           int32_t          mid,
           const int32_t    end)
{
  int32_t j;
  while ((start < mid) && (mid < end)) {
    cmp.inc();
    if (elems.compare(start, mid, comp) > 0) {
      /* move first element of upper list into place */
      for(j = mid;j > start; --j) {
	swp.inc();
	elems.swap(j, j - 1);
      }
      ++mid;
    }
    ++start;
  }
}

/**
 * end is one past the end
 */
static void
mergeSort(sort::Container  &elems,
          sort::Comparator &comp,
          sort::Counter    &cmp,
          sort::Counter    &swp,
          const int32_t   start,
          const int32_t   end)
{
  if ((end - start) > 1) {
    int32_t mid = (start + end) >> 1;
    mergeSort(elems, comp, cmp, swp, start, mid);
    mergeSort(elems, comp, cmp, swp, mid, end);
    mergeLists(elems, comp, cmp, swp, start, mid, end);
  }
}
// DO-NOT-DELETE splicer.end(sort.MergeSort._includes)

// user defined constructor
void sort::MergeSort_impl::_ctor() {
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.MergeSort._ctor)
}

// user defined destructor
void sort::MergeSort_impl::_dtor() {
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.MergeSort._dtor)
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * Sort elements using Merge Sort.
 */
void
sort::MergeSort_impl::sort (
  /*in*/ ::sort::Container elems,
  /*in*/ ::sort::Comparator comp ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(sort.MergeSort.sort)
  const int32_t num = elems.getLength();
  sort::Counter cmp = self.getCompareCounter();
  sort::Counter swp = self.getSwapCounter();
  mergeSort(elems, comp, cmp, swp, 0, num);
  // DO-NOT-DELETE splicer.end(sort.MergeSort.sort)
}

/**
 * Return merge sort.
 */
::std::string
sort::MergeSort_impl::getName () 
throw () 

{
  // DO-NOT-DELETE splicer.begin(sort.MergeSort.getName)
  return "Merge sort";
  // DO-NOT-DELETE splicer.end(sort.MergeSort.getName)
}


// DO-NOT-DELETE splicer.begin(sort.MergeSort._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.MergeSort._misc)

