C       
C       File:          sort_IntegerContainer_Impl.f
C       Symbol:        sort.IntegerContainer-v0.1
C       Symbol Type:   class
C       Babel Version: 0.8.8
C       Description:   Server-side implementation for sort.IntegerContainer
C       
C       WARNING: Automatically generated; only changes within splicers preserved
C       
C       babel-version = 0.8.8
C       


C       
C       Symbol "sort.IntegerContainer" (version 0.1)
C       
C       Integer container.
C       


C       DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
C       Insert extra code here...
C       DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




C       
C       Class constructor called when the class is created.
C       

        subroutine sort_IntegerContainer__ctor_fi(self)
        implicit none
        integer*8 self

C       DO-NOT-DELETE splicer.begin(sort.IntegerContainer._ctor)
        integer*8 data
        data = 0
        call sort_IntegerContainer__set_data_f(self, data)
C       DO-NOT-DELETE splicer.end(sort.IntegerContainer._ctor)
        end


C       
C       Class destructor called when the class is deleted.
C       

        subroutine sort_IntegerContainer__dtor_fi(self)
        implicit none
        integer*8 self

C       DO-NOT-DELETE splicer.begin(sort.IntegerContainer._dtor)
        integer*8 data
        call sort_IntegerContainer__get_data_f(self, data)
        if (data .ne. 0) then
           call sort_Integer__array_deleteRef_f(data)
           data = 0
           call sort_IntegerContainer__set_data_f(self, data)
        endif
C       DO-NOT-DELETE splicer.end(sort.IntegerContainer._dtor)
        end


C       
C       This sets the container length and pseudo-randomly orders the
C       Integer elements contained.
C       

        subroutine sort_IntegerContainer_setLength_fi(self, len)
        implicit none
        integer*8 self
        integer*4 len

C       DO-NOT-DELETE splicer.begin(sort.IntegerContainer.setLength)
        integer*8 data, intobj
        integer*4 i
        if (len .ge. 0) then
           call sort_IntegerContainer__get_data_f(self, data)
           call sort_Integer__array_deleteRef_f(data)
           call sort_Integer__array_create1d_f(len, data)
           do i = 0, len - 1
              call sort_Integer__create_f(intobj)
              call sort_Integer_setValue_f(intobj, i + 1)
              if (mod(i,2) .eq. 0) then
                 call sort_Integer__array_set1_f(data, i/2, intobj)
              else
                 call sort_Integer__array_set1_f(data,
     $                len - 1 - i/2, intobj)
              endif
              call sort_Integer_deleteRef_f(intobj)
           enddo
C     don't shuffle the list because no standard random number generator
           call sort_IntegerContainer__set_data_f(self, data)
        endif
C       DO-NOT-DELETE splicer.end(sort.IntegerContainer.setLength)
        end


C       
C       Return the number of elements in the container.
C       

        subroutine sort_IntegerContainer_getLength_fi(self, retval)
        implicit none
        integer*8 self
        integer*4 retval

C       DO-NOT-DELETE splicer.begin(sort.IntegerContainer.getLength)
        integer*8 data
        integer*4 lower, upper
        integer*4 zero
        data zero / 0 /
        call sort_IntegerContainer__get_data_f(self, data)
        retval = 0
        if (data .ne. 0) then
           call sort_Integer__array_lower_f(data, zero, lower)
           call sort_Integer__array_upper_f(data, zero, upper)
           retval = 1 + upper - lower
        endif
C       DO-NOT-DELETE splicer.end(sort.IntegerContainer.getLength)
        end


C       
C       Return -1 if element i is less than element j, 0 if element i
C       is equal to element j, or otherwise 1.
C       

        subroutine sort_IntegerContainer_compare_fi(self, i, j, comp,
     &     retval)
        implicit none
        integer*8 self
        integer*4 i
        integer*4 j
        integer*8 comp
        integer*4 retval

C       DO-NOT-DELETE splicer.begin(sort.IntegerContainer.compare)
        integer*8 i1, i2, data
        call sort_IntegerContainer__get_data_f(self, data)
        if (data .ne. 0) then
           call sort_Integer__array_get1_f(data, i, i1)
           call sort_Integer__array_get1_f(data, j, i2)
           call sort_Comparator_compare_f(comp, i1, i2, retval)
           call sort_Integer_deleteRef_f(i1)
           call sort_Integer_deleteRef_f(i2)
        endif
C       DO-NOT-DELETE splicer.end(sort.IntegerContainer.compare)
        end


C       
C       Swap elements i and j.
C       

        subroutine sort_IntegerContainer_swap_fi(self, i, j)
        implicit none
        integer*8 self
        integer*4 i
        integer*4 j

C       DO-NOT-DELETE splicer.begin(sort.IntegerContainer.swap)
        integer*8 data, i1, i2
        integer*4 len
        call sort_IntegerContainer__get_data_f(self, data)
        if (data .ne. 0) then
           call sort_IntegerContainer_getLength_f(self, len)
           if ((i .ge. 0) .and. (j .ge. 0) .and.
     $          (i .lt. len) .and. (j .lt. len)) then
              call sort_Integer__array_get1_f(data, i, i1)
              call sort_Integer__array_get1_f(data, j, i2)
              call sort_Integer__array_set1_f(data, i, i2)
              call sort_Integer__array_set1_f(data, j, i1)
              call sort_Integer_deleteRef_f(i1)
              call sort_Integer_deleteRef_f(i2)
           else
              write(*,*)
     $             'sort::IntegerContainer::swap index out of bounds'
           endif
        endif
C       Insert the implementation here...
C       DO-NOT-DELETE splicer.end(sort.IntegerContainer.swap)
        end


C       
C       Print elements s through e-1
C       

        subroutine sort_IntegerContainer_output_fi(self, s, e)
        implicit none
        integer*8 self
        integer*4 s
        integer*4 e

C       DO-NOT-DELETE splicer.begin(sort.IntegerContainer.output)
        write (*, *) 'COMMENT: output list not implemented'
C       DO-NOT-DELETE splicer.end(sort.IntegerContainer.output)
        end


C       DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
C       Insert extra code here...
C       DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
