/*
 * File:        SIDLf90array.h
 * Copyright:   (c) 2003 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.1 $
 * Date:        $Date: 2003/09/03 15:09:36 $
 * Description: Functions to convert SIDL arrays into F90 derived type
 *
 */

#ifndef included_SIDLf90array_h
#define included_SIDLf90array_h

#ifndef included_SIDLType_h
#include "SIDLType.h"
#endif

#if defined(SIDL_MAX_F90_DESCRIPTOR) && !defined(FORTRAN90_DISABLED)

/* forward declaration of SIDL array struct's */
struct SIDL_dcomplex__array;
struct SIDL_double__array;
struct SIDL_fcomplex__array;
struct SIDL_float__array;
struct SIDL_int__array;
struct SIDL_long__array;

struct SIDL_fortran_array {
  int64_t d_ior;
  char    d_descriptor[SIDL_MAX_F90_DESCRIPTOR];
};

#ifdef __cplusplus
extern "C" {
#endif
/**
 * Convert a SIDL IOR into a F90 derived type containing the IOR pointer
 * as a 64 bit integer and a F90 pointer to an array.
 * src        NULL or a valid SIDL array
 * src_dimen  the dimension of src (*only* used when src is NULL)
 * desc       must be non-NULL pointer to single struct. This incoming
 *            contents of this struct are ignored. The incoming contents
 *            are overwritten.
 *
 * return value 0 means everything worked. Non-zero means it failed
 */
int
SIDL_dcomplex__array_convert2f90(const struct SIDL_dcomplex__array *src,
                                 const int src_dimen,
                                 struct SIDL_fortran_array *dest);


/**
 * Convert a SIDL IOR into a F90 derived type containing the IOR pointer
 * as a 64 bit integer and a F90 pointer to an array.
 * src        NULL or a valid SIDL array
 * src_dimen  the dimension of src (*only* used when src is NULL)
 * desc       must be non-NULL pointer to single struct. This incoming
 *            contents of this struct are ignored. The incoming contents
 *            are overwritten.
 *
 * return value 0 means everything worked. Non-zero means it failed
 */
int
SIDL_double__array_convert2f90(const struct SIDL_double__array *src,
                               const int src_dimen,
                               struct SIDL_fortran_array *dest);

/**
 * Convert a SIDL IOR into a F90 derived type containing the IOR pointer
 * as a 64 bit integer and a F90 pointer to an array.
 * src        NULL or a valid SIDL array
 * src_dimen  the dimension of src (*only* used when src is NULL)
 * desc       must be non-NULL pointer to single struct. This incoming
 *            contents of this struct are ignored. The incoming contents
 *            are overwritten.
 *
 * return value 0 means everything worked. Non-zero means it failed
 */
int
SIDL_fcomplex__array_convert2f90(const struct SIDL_fcomplex__array *src,
                                 const int src_dimen,
                                 struct SIDL_fortran_array *dest);

/**
 * Convert a SIDL IOR into a F90 derived type containing the IOR pointer
 * as a 64 bit integer and a F90 pointer to an array.
 * src        NULL or a valid SIDL array
 * src_dimen  the dimension of src (*only* used when src is NULL)
 * desc       must be non-NULL pointer to single struct. This incoming
 *            contents of this struct are ignored. The incoming contents
 *            are overwritten.
 *
 * return value 0 means everything worked. Non-zero means it failed
 */
int
SIDL_float__array_convert2f90(const struct SIDL_float__array *src,
                              const int src_dimen,
                              struct SIDL_fortran_array *dest);

/**
 * Convert a SIDL IOR into a F90 derived type containing the IOR pointer
 * as a 64 bit integer and a F90 pointer to an array.
 * src        NULL or a valid SIDL array
 * src_dimen  the dimension of src (*only* used when src is NULL)
 * desc       must be non-NULL pointer to single struct. This incoming
 *            contents of this struct are ignored. The incoming contents
 *            are overwritten.
 *
 * return value 0 means everything worked. Non-zero means it failed
 */
int
SIDL_int__array_convert2f90(const struct SIDL_int__array *src,
                            const int src_dimen,
                            struct SIDL_fortran_array *dest);

/**
 * Convert a SIDL IOR into a F90 derived type containing the IOR pointer
 * as a 64 bit integer and a F90 pointer to an array.
 * src        NULL or a valid SIDL array
 * src_dimen  the dimension of src (*only* used when src is NULL)
 * desc       must be non-NULL pointer to single struct. This incoming
 *            contents of this struct are ignored. The incoming contents
 *            are overwritten.
 *
 * return value 0 means everything worked. Non-zero means it failed
 */
int
SIDL_long__array_convert2f90(const struct SIDL_long__array *src,
                             const int src_dimen,
                             struct SIDL_fortran_array *dest);
#ifdef __cplusplus
}
#endif


#endif /* defined(SIDL_MAX_F90_DESCRIPTOR) && !defined(FORTRAN90_DISABLED) */
#endif /*  included_SIDLf90array_h */
