/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared;

import com.google.gwt.core.client.impl.WeakMapping;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoBeanUtils {
    public static boolean deepEquals(AutoBean<?> a, AutoBean<?> b) {
        return AutoBeanUtils.sameOrEquals(a, b, new HashMap<PendingComparison, Comparison>());
    }

    public static Map<String, Object> diff(AutoBean<?> a, AutoBean<?> b) {
        if (a.equals(b)) {
            return Collections.emptyMap();
        }
        final Map<String, Object> toReturn = AutoBeanUtils.getAllProperties(b);
        a.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> previousValue, AutoBeanVisitor.PropertyContext ctx) {
                if (toReturn.containsKey(propertyName)) {
                    if (this.equal(propertyName, previousValue)) {
                        toReturn.remove(propertyName);
                    }
                } else {
                    toReturn.put(propertyName, null);
                }
                return false;
            }

            @Override
            public boolean visitValueProperty(String propertyName, Object previousValue, AutoBeanVisitor.PropertyContext ctx) {
                if (toReturn.containsKey(propertyName)) {
                    if (this.equal(propertyName, previousValue)) {
                        toReturn.remove(propertyName);
                    }
                } else {
                    toReturn.put(propertyName, null);
                }
                return false;
            }

            private boolean equal(String propertyName, AutoBean<?> previousValue) {
                return previousValue == null && toReturn.get(propertyName) == null || previousValue != null && this.equal(propertyName, previousValue.as());
            }

            private boolean equal(String propertyName, Object previousValue) {
                Object currentValue = toReturn.get(propertyName);
                return previousValue == null && currentValue == null || previousValue != null && previousValue.equals(currentValue);
            }
        });
        return toReturn;
    }

    public static Map<String, Object> getAllProperties(AutoBean<?> bean) {
        final LinkedHashMap<String, Object> toReturn = new LinkedHashMap<String, Object>();
        bean.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                toReturn.put(propertyName, value == null ? null : (Object)value.as());
                return false;
            }

            @Override
            public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                toReturn.put(propertyName, value);
                return false;
            }
        });
        return toReturn;
    }

    public static <T, U extends T> AutoBean<T> getAutoBean(U delegate) {
        return delegate == null ? null : (AutoBean)WeakMapping.get(delegate, AutoBean.class.getName());
    }

    static boolean sameOrEquals(Object value, Object otherValue, Map<PendingComparison, Comparison> pending) {
        if (value == otherValue) {
            return true;
        }
        if (value instanceof Collection && otherValue instanceof Collection) {
            return AutoBeanUtils.sameOrEquals((Collection)((Object)value), (Collection)((Object)otherValue), pending, null);
        }
        if (value instanceof Map && otherValue instanceof Map) {
            return AutoBeanUtils.sameOrEquals((Map)((Object)value), (Map)((Object)otherValue), pending);
        }
        if (value instanceof Splittable && otherValue instanceof Splittable) {
            return AutoBeanUtils.sameOrEquals((Splittable)((Object)value), (Splittable)((Object)otherValue), pending);
        }
        AutoBean maybeValue = AutoBeanUtils.getAutoBean(value);
        AutoBean maybeOther = AutoBeanUtils.getAutoBean(otherValue);
        if (maybeValue != null && maybeOther != null) {
            value = maybeValue;
            otherValue = maybeOther;
        }
        if (value instanceof AutoBean && otherValue instanceof AutoBean) {
            return AutoBeanUtils.sameOrEquals(value, otherValue, pending);
        }
        if (value == null ^ otherValue == null) {
            return false;
        }
        return value == null || value.equals(otherValue);
    }

    private static boolean sameOrEquals(AutoBean<?> value, AutoBean<?> otherValue, Map<PendingComparison, Comparison> pending) {
        if (value == otherValue) {
            return true;
        }
        if (!value.getType().equals(otherValue.getType())) {
            return false;
        }
        PendingComparison key = new PendingComparison(value, otherValue);
        Comparison previous = pending.get(key);
        if (previous == null) {
            pending.put(key, Comparison.PENDING);
            Map<String, Object> beanProperties = AutoBeanUtils.getAllProperties(value);
            Map<String, Object> otherProperties = AutoBeanUtils.getAllProperties(otherValue);
            for (Map.Entry<String, Object> entry : beanProperties.entrySet()) {
                Object otherProperty;
                Object property = entry.getValue();
                if (AutoBeanUtils.sameOrEquals(property, otherProperty = otherProperties.get(entry.getKey()), pending)) continue;
                pending.put(key, Comparison.FALSE);
                return false;
            }
            pending.put(key, Comparison.TRUE);
            return true;
        }
        return !Comparison.FALSE.equals((Object)previous);
    }

    private static boolean sameOrEquals(Collection<?> collection, Collection<?> otherCollection, Map<PendingComparison, Comparison> pending, Map<Object, Object> pairs) {
        if (collection.size() != otherCollection.size()) {
            return false;
        }
        if (collection instanceof List) {
            Iterator<?> it = collection.iterator();
            Iterator<?> otherIt = otherCollection.iterator();
            while (it.hasNext()) {
                Object otherElement;
                assert (otherIt.hasNext());
                Object element = it.next();
                if (!AutoBeanUtils.sameOrEquals(element, otherElement = otherIt.next(), pending)) {
                    return false;
                }
                if (pairs == null) continue;
                pairs.put(element, otherElement);
            }
        } else {
            ArrayList values = new ArrayList(collection);
            ArrayList otherValues = new ArrayList(otherCollection);
            Iterator it = values.iterator();
            block1: while (it.hasNext()) {
                Object value = it.next();
                Iterator otherIt = otherValues.iterator();
                while (otherIt.hasNext()) {
                    Object otherValue = otherIt.next();
                    if (!AutoBeanUtils.sameOrEquals(value, otherValue, pending)) continue;
                    if (pairs != null) {
                        pairs.put(value, otherValue);
                    }
                    it.remove();
                    otherIt.remove();
                    continue block1;
                }
                return false;
            }
            assert (values.isEmpty() && otherValues.isEmpty());
        }
        return true;
    }

    private static boolean sameOrEquals(Map<?, ?> map, Map<?, ?> otherMap, Map<PendingComparison, Comparison> pending) {
        if (map.size() != otherMap.size()) {
            return false;
        }
        IdentityHashMap<Object, Object> pairs = new IdentityHashMap<Object, Object>();
        if (!AutoBeanUtils.sameOrEquals(map.keySet(), otherMap.keySet(), pending, pairs)) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object otherValue = otherMap.get(pairs.get(entry.getKey()));
            if (AutoBeanUtils.sameOrEquals(entry.getValue(), otherValue, pending)) continue;
            return false;
        }
        return true;
    }

    private static boolean sameOrEquals(Splittable value, Splittable otherValue, Map<PendingComparison, Comparison> pending) {
        if (value == otherValue) {
            return true;
        }
        if (value.isString()) {
            if (!otherValue.isString()) {
                return false;
            }
            return value.asString().equals(otherValue.asString());
        }
        if (value.isIndexed()) {
            if (!otherValue.isIndexed()) {
                return false;
            }
            if (value.size() != otherValue.size()) {
                return false;
            }
            int j = value.size();
            for (int i = 0; i < j; ++i) {
                if (AutoBeanUtils.sameOrEquals(value.get(i), otherValue.get(i), pending)) continue;
                return false;
            }
            return true;
        }
        if (value.isKeyed()) {
            if (!otherValue.isKeyed()) {
                return false;
            }
            List<String> keys = value.getPropertyKeys();
            for (String key : keys) {
                if (!(value.isNull(key) ? !otherValue.isNull(key) : otherValue.isNull(key) || !AutoBeanUtils.sameOrEquals(value.get(key), otherValue.get(key), pending))) continue;
                return false;
            }
            ArrayList<String> otherKeys = new ArrayList<String>(otherValue.getPropertyKeys());
            otherKeys.removeAll(keys);
            for (String key : otherKeys) {
                if (value.isNull(key)) continue;
                return false;
            }
            return true;
        }
        throw new UnsupportedOperationException("Splittable of unknown type");
    }

    private AutoBeanUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PendingComparison {
        private final AutoBean<?> a;
        private final AutoBean<?> b;
        private final int hashCode;

        public PendingComparison(AutoBean<?> a, AutoBean<?> b) {
            this.a = a;
            this.b = b;
            this.hashCode = System.identityHashCode(a) + System.identityHashCode(b);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PendingComparison)) {
                return false;
            }
            PendingComparison other = (PendingComparison)o;
            return this.a == other.a && this.b == other.b || this.a == other.b && this.b == other.a;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Comparison {
        TRUE,
        FALSE,
        PENDING;

    }
}

