// Copyright (c) 1999,2000,2001,2002,2003  INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you may redistribute it under
// the terms of the Q Public License version 1.0.
// See the file LICENSE.QPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL: svn+ssh://scm.gforge.inria.fr/svn/cgal/branches/CGAL-3.4-branch/Triangulation_2/include/CGAL/Triangulation_ds_vertex_base_2.h $
// $Id: Triangulation_ds_vertex_base_2.h 41733 2008-01-20 22:46:28Z spion $
// 
//
// Author(s)     : Mariette Yvinec


#ifndef CGAL_TRIANGULATION_DS_VERTEX_BASE_2_H
#define CGAL_TRIANGULATION_DS_VERTEX_BASE_2_H

#include <CGAL/basic.h>
#include <CGAL/Triangulation_short_names_2.h>
#include <CGAL/Dummy_tds_2.h>

CGAL_BEGIN_NAMESPACE

template < class TDS = void >
class Triangulation_ds_vertex_base_2 
{

public:
  typedef TDS                          Triangulation_data_structure;
  typedef typename TDS::Face_handle    Face_handle;
  typedef typename TDS::Vertex_handle  Vertex_handle;

  template <typename TDS2>
  struct Rebind_TDS { typedef Triangulation_ds_vertex_base_2<TDS2> Other; };

  Triangulation_ds_vertex_base_2 ()    : _f()  {}
  Triangulation_ds_vertex_base_2(Face_handle f)    :  _f(f)    {}

  Face_handle face() const { return _f;}
  void set_face(Face_handle f) { _f = f ;}

  //the following trivial is_valid to allow
  // the user of derived face base classes 
  // to add their own purpose checking
  bool is_valid(bool /*verbose*/=false, int /*level*/= 0) const
    {return face() != Face_handle();}

    // For use by the Compact_container.
  void *   for_compact_container() const { return _f.for_compact_container(); }
  void * & for_compact_container()       { return _f.for_compact_container(); }

private:
  Face_handle _f;
};

// Specialization for void.
template <>
class Triangulation_ds_vertex_base_2<void>
{
public:
  typedef Dummy_tds_2  Triangulation_data_structure;
  typedef Triangulation_data_structure::Vertex_handle   Vertex_handle;
  typedef Triangulation_data_structure::Face_handle     Face_handle;
  template <typename TDS2>
  struct Rebind_TDS { typedef Triangulation_ds_vertex_base_2<TDS2> Other; };
};


template < class TDS >
inline
std::istream&
operator>>(std::istream &is, Triangulation_ds_vertex_base_2<TDS> &)
  // no combinatorial information.
{
  return is;
}

template < class TDS >
inline
std::ostream&
operator<<(std::ostream &os, const Triangulation_ds_vertex_base_2<TDS> &)
  // no combinatorial information.
{
  return os;
}
CGAL_END_NAMESPACE

#endif //CGAL_TRIANGULATION_DS_VERTEX_BASE_2_H
