(in-package :cl-user)

(defun test-table (&optional (file (lw:current-pathname "test-table.pdf"))
                   &aux content table (margins '(72 72 72 50)))
  (let* ((tt:*default-font* (pdf:get-font "Helvetica"))
         (tt:*default-font-size* 10)
         (row-height nil))
   (tt:with-document ()
    (setq content (tt:compile-text (:font tt:*default-font*
                                    :font-size tt:*default-font-size*)
     (tt:paragraph () "Test table spans and borders")
     (tt:table (:col-widths '(20 40 60 80 120) :background-color :yellow :border 1)
       (tt:header-row ()
         (tt:cell (:col-span 5)
           (tt:paragraph (:h-align :center :font-size 12)
             "Table with cells spanning more then one row or column")))
       (tt:row (:background-color :green)
         (tt:cell (:row-span 2 :background-color :blue)
           "1,1 2,1  row-span 2")
         (tt:cell () "1,2")
         (tt:cell (:col-span 2 :row-span 3 :background-color :red)
           "1,3 1,4 - 3,3 3,4  col-span 2 row-span 3")
         (tt:cell () "1,5"))
       (tt::row ()
         (tt:cell () "2,2")
         (tt:cell (:row-span 2 :background-color :blue) "2,5 3,5  row-span 2"))
       (tt:row (:background-color :green)
         (tt:cell (:col-span 2) "3,1 3,2  col-span 2"))
       (tt::row ()
         (tt:cell () "4,1")
         (tt:cell () "4,2")
         (tt:cell () "4,3")
         (tt:cell () "4,4")
         (tt:cell () "4,5")))

    (setq table
     (tt:table (:col-widths '(50 40 60 80 120) :border 0)
       (tt:header-row ()
         (tt:cell (:col-span 0 :border 1)
           (tt:paragraph (:h-align :centered :font-size 12)
             "Cells with borders. Header row cell  col-span 0")))
       (tt:row (:background-color :green)
         (tt:cell (:row-span 2 :background-color :blue)
           "1,1 2,1  row-span 2")
         (tt:cell () "1,2")
         (tt:cell (:col-span 2 :row-span 3 :background-color :red)
           "1,3 1,4 - 3,3 3,4  col-span 2 row-span 3")
         (tt:cell () "1,5"))
       (tt:row ()
         (tt:cell (:border 2) "2,2")
         (tt:cell (:row-span 2 :background-color :blue) "2,5 3,5  row-span 2"))
       (tt:row (:background-color :green)
         (tt:cell (:col-span 2 :border 2) "3,1 3,2  col-span 2"))
       (tt:row ()
         (tt:cell (:border #(3 0 0 0)) "4,1 left-border 3")
         (tt:cell (:border #(0 3 0 0)) "4,2 top-border 3")
         (tt:cell (:border #(2 2 2 2)) "4,3 border #(2 2 2 2)")
         (tt:cell (:border #(0 0 3 0)) "4,4 right-border 3")
         (tt:cell (:border #(0 0 0 3)) "4,5 bottom-border 3"))
       (tt:footer-row ()
         (tt:cell (:col-span 5 :border '(0 1/4))
           (tt:paragraph (:h-align :justified :font-size 12)
             "footer" :hfill "cell" :hfill "spanning" :hfill "several" :hfill "columns")))))
   
     (tt:table (:col-widths '(60 60 60 60 60) :border 1)
       (tt:row (:height row-height)
         (tt:cell (:row-span 2) "1,1 2,1  row-span 2")
         (tt:cell () "1,2")
         (tt:cell () "1,3")
         (tt:cell (:col-span 0) "1,4 1,5  col-span 0"))
       (tt::row (:height row-height)
         (tt:cell (:row-span 3) "2,2 3,2 4,2  row-span 3")
         (tt:cell () "2,3")
         (tt:cell (:col-span 0 :row-span 0) "2,4 - 4,5  col-span 0 row-span 0"))
       (tt:row (:height row-height)
         (tt:cell (:row-span 0) "3,1 4,1  row-span 0")
         (tt:cell () "3,3"))
       (tt:row (:height row-height)
         (tt:cell () "4,3")))

     (tt:table (:col-widths '(60 60 60) :border 1)
       (tt:row (:height row-height)
         (tt:cell (:row-span 2) "1,1 2,1  row-span 2")
         (tt:cell () "1,2")
         (tt:cell () "1,3"))
       (tt::row (:height row-height)
         (tt:cell (:row-span 3) "2,2 3,2 4,2  row-span 3")
         (tt:cell () "2,3"))
       (tt:row (:height row-height)
         (tt:cell (:row-span 2) "3,1 4,1  row-span 2")
         (tt:cell () "3,3"))
       (tt:row (:height row-height)
         (tt:cell () "4,3")))
    ))
    (tt::draw-pages content :margins margins :break :after)
    (pdf:write-document file)))
 table)

;(pdf:load-fonts)
;(setq pdf:*compress-streams* nil)
;(setq table (test-table))
