/****************************************************************************
**
** Copyright (C) 2004-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "Import.h"

#include <qapplication.h>
#include <assert.h>

#include "globals.h"
#include "TextEncoder.h"
#include "ImportDialogImpl.h"

QString Import::s_lastProfile = "";
QString Import::s_lastComment = "";
QStringList Import::s_vendorTagList;
QStringList Import::s_releaseTagList;


Import * Import::importProject(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, false);
}

Import * Import::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, int mode) {

   DirBase * dir = workBench->selectedItem();

   ImportDialogImpl* dlg = new ImportDialogImpl( &s_lastProfile,
	 &cvsProfileNameList,
	 &cvsUsers,
	 &cvsServers,
	 &cvsRepositories,
	 &WORKDIRHISTORYLIST,
	 &s_vendorTagList,
	 &s_releaseTagList,
	 &s_lastComment,
	 whatsThisIconSet,
	 parent, "Import Dialog", true,
	 LookAndFeel::g_modalF);

   if (dlg->exec()) {
      Import * p = new Import(whatsThisIconSet, parent, workBench, dir, mode);
      p->m_dlg = dlg;
      p->acceptCvs();
   } else {
      delete dlg;
      dlg = NULL;
   }

   return NULL;

//    if (dir->getType() == DirBase::Cvs) {

//       Import * p = new Import(whatsThisIconSet, parent, workBench, dir, mode);

      //       p->m_dlg = new Dialog();

//       connect(p->m_dlg,SIGNAL(accept()),p,SLOT(acceptCvs()));
//       connect(p->m_dlg,SIGNAL(reject()),p,SLOT(reject()));
//       p->m_dlg->show();

//       return p;

//    } else {

//       qDebug("Import: Method not implemented");
//       return NULL;
//    }
}

Import::Import(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, int mode)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_mode(mode)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(checkTree(DirBase *)),parent,SLOT(slot_checkStatusOfTree(DirBase *)));
   connect(this,SIGNAL(showWarning(const QString&,const QString&)),parent,SLOT(showWarning(const QString&,const QString&)));
}

Import::~Import() {
   if (m_dlg) delete m_dlg;
   m_dlg = NULL;
}

void Import::acceptCvs() {

   assert(m_dlg);

   ImportDialogImpl * dlg = static_cast<ImportDialogImpl *>(m_dlg);
   assert(dlg);

   //read dlg values
   QDir localDir(dlg->localDir());
   if(!localDir.exists()) {
      emit showWarning( tr("Warning")+", "+tr("import stopped"),
	    tr("Directory doesn't exist:")+"\n"+
	    dlg->localDir());
      reject();
      return;
   }

   QString dir = localDir.absPath();
   QString module = dlg->module();
   QString comment = dlg->comment();
   QString user = dlg->user();
   QString server = dlg->server();
   QString repository = dlg->repository();
   QString tmpCvsRsh = dlg->getCvsRsh();
   QString tagV = dlg->tagV();
   QString tagR = dlg->tagR();
   int mode = dlg->mode();
   int rshMode = dlg->rshMode();
   int sshAccess = dlg->getSshPreset();
   bool keepFTime = dlg->getKeepFTime();
   bool createDirs = dlg->getCreateDirs();
   QStringList ignoreWildcards = dlg->getIgnoreWildcards();
   QStringList binaryWildcards = dlg->getBinaryWildcards();

   delete m_dlg;
   m_dlg = NULL;

   bool needcvsroot = false;
   QString cvsRoot;
   QString files;
  
   //modify application-wide lists
   adaptQStringList(module,&MODULEHISTORYLIST,HistorySize::g_profiles);
   adaptQStringList(dir.left(dir.findRev("/")),&WORKDIRHISTORYLIST,HistorySize::g_workdirs);
   adaptQStringList(tagV,&s_vendorTagList,20);
   adaptQStringList(tagR,&s_releaseTagList,20);
   adaptQStringList(user, &cvsUsers, HistorySize::g_profiles);
   adaptQStringList(server, &cvsServers, HistorySize::g_profiles);
   adaptQStringList(repository, &cvsRepositories, HistorySize::g_profiles);
  
   //check ssh access settings
   bUseSsh = false;
   bUseSshAgent = false;
   bUseSshAgentVars = false;
   switch( sshAccess) {
      case USESSH: {
	 bUseSsh = true;
	 break;
      }
      case USESSHAGENT: {
	 bUseSshAgent = true;
	 break;
      }
      case USESSHAGENTVARS: {
	 bUseSshAgentVars = true;
	 break;
      }
   }
  
   //set CVSROOT      
   if(mode == SSPI) { //sspi
      //set CVSROOT for sspi mode
      cvsRoot = ":sspi:";
      needcvsroot = true;
   }else if(mode == PSERVER) { //password server
      //set CVSROOT for pserver mode
      cvsRoot = ":pserver:";
      needcvsroot = true;
   } else if(mode == RSH) {//remote shell access
      needcvsroot = true;
      if(rshMode == RSH_EXT) {
	 cvsRoot = ":ext:";
      } else {
	 cvsRoot = ":server:";
      }
   }
   if (server.find(':') == -1) server += ":";
   if (needcvsroot) cvsRoot += user + "@" + server;
   cvsRoot +=  repository;
   cvsRoot = masqWs(cvsRoot);
   files = "-r " + CvsOptions::cmprStr();
  
   files += " import ";
   
   if (keepFTime) files += "-d ";
   if (createDirs) files += "-C ";
    
  
   //ignore files:
   QString sIgnore = "-I ! ";
   if (!ignoreWildcards.empty()) {
      sIgnore += "-I \"";
      sIgnore += ignoreWildcards.join("\" -I \"");
      sIgnore += "\" ";
   }
   files += sIgnore;
  
   //binary import files:
   if (!binaryWildcards.empty()) {
      QString sBin = "-W \"";
      sBin += binaryWildcards.join(" -k 'b'\" -W \"");
      sBin += " -k 'b'\" ";
      files += sBin;
   }
  
   //add commitinfo
   files += "-m ";
   files += "\"" + I18n::g_pTextEncoder->encode(comment) + "\" ";
  
   files += masqWs(module) + " " + tagV + " " + tagR;
   QString topModule = QString::null;

   callInteractive( topModule, dir, cvsRoot,
	 files, CVS_IMPORT_CMD, tmpCvsRsh);
}

void Import::reject() {
   emit deleteObject(this);
}

void Import::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Import::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Import::afterCall(int cmd,CvsBuffer*,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject();
      return;
   }
   switch( cmd) {
      case NOOP: {
	 break;
      }
      case CVS_IMPORT_CMD: {
	 break;
      }
      default: {
	 qDebug("Import::afterCall: Unknown cmd");
      }
   }
   reject();
}

