/****************************************************************************
**
** Copyright (C) 2003-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef CVSCONTROL_H
#define CVSCONTROL_H

#include "config.h"

#include "globals.h"
#include "cmainwindow.h"
#include "CvsBuffer.h"
#include "CCvsOutput.h"
#include "GuardedDir.h"
#include "InteractiveCmdThread.h"
#include "CommandInterface.h"
#include "ExtTimer.h"

class CvsDirListView;
class Directory;
class ColorTabWidget;
class CPixmapTimer;
class cvsToolbar;


class CvsControl: public CMainWindow, public CommandInterface
{
   Q_OBJECT

 signals:
   
   void tagListFetched();

 public:

   CvsControl( QString);
   ~CvsControl();
 
   bool addProject(const char * fileName = 0, bool expand = false);
   bool addNewProject(const QString fileName, bool expand = false);
   void callInteractiveCmd( QString& topModule,
	 QString& dir,
	 QString& cvsRoot,
	 QString& repository,
	 int cmd,
	 QString& cvsRsh,
	 bool noroot=false,
	 CommandInterface *instance = NULL);
   void afterCall(int,CvsBuffer*,bool);

 public slots:

   virtual void slot_checkStatus(bool forceRefresh=false);
   virtual void slot_checkStatusOfTree(DirBase *);
   
   void slot_addCheckedOutProject(QString,QString,int);
   void slot_removeProjectSlot(DirBase * = NULL);
   void dirConnectorDataNotify();
   void slot_openTreeAndActivate(DirBase *,const QString);
   void slot_selectSubDir(DirBase **,QString);   

   /** only for testing purpose, not for release */
   virtual void test();
   
 protected:

   void readSettings();
   void writeSettings();
   void writeCfg();
   void setSettings();
   void applyProjectSettings(QString projectName = "");
   
   void initLocalRepository(QString);
   void recValidateCvsFilesStatus(bool forceCacheReset = false, bool forceEntriesReset = false);
   QStringList * getCurrentTagList() { return &m_currentTagList;}
   
   static const bool OVERRIDE;
   
   cvsToolbar *m_pTools;   //needed for whatsthis iconset
   
   //Flags for GUI blocking
   enum Block {
      BLOCKALL = 0,
      BLOCKNOCURSOR = 1,
      BLOCKNOCONTROLS = 2
   };
   
   /* -------------------------------- move these to gui later --------------------------------- */
   
   // Progress (image) timer related stuff
   CPixmapTimer *m_pPixmapTimer;
   
   CCvsOutput *m_pMessages;
   CvsDirListView *m_pWorkBenchTree;
   ColorTabWidget *m_pFileViews;
   
   
   /* ---------------------------- these need to be checked after redesign -------------------------------- */
   
   //AutoUpdate
   CExtTimer   m_updateTimer;
   
   //checkStatus
   CExtTimer   m_timer;
   
   enum Timers {
      TALL = 0,
      TSTATUS = 1,
      TUPDATE = 2
   };
   
   void stopTimers(int = TALL);
   void startTimers(int = TALL);
   
   /* ----------------------------------------------------------------------------------- */
   
 protected slots:
   
   /** Help menu slots */
   void slot_debug();
   void slot_onlineHelp();
   
   void removeDirIfNoCvsRegisteredFiles();
   void slot_rereadProject(DirBase * = NULL);
   void stopCurAction();
   void killInteractiveCmdThread();
   void editFile( QString);
   void viewFileWithPath( QString);
   void openFile();
   void viewFile();
   void loginDir();
   void logoutDir();
   void browseDir();
   void openShellDir();
   void createNewFile();
   void createNewDir();
   void renameDir(Directory *,QString);
   void slot_removeFileFromDisk();
   void removeNonCvsFileFromDisk();
   void removeCvsIgnoreFileFromDisk(); 
   void initialDirScanning();
   void expandDir();
   void collapsDir();
   void disableProjectSlot();
   void enableProjectSlot();
   void disableOthers();
   void enableTree();
   void exportFromModuleDir();
   void updateProjectTagList();
   void readCurrentTagList();
   
 private:
   
   virtual void writeSetup() = 0;
   virtual void initDone() = 0;
   virtual void setStatusText( const QString&, int ms=0) = 0;
   virtual void blockGUI(bool,int=BLOCKALL) = 0;
   virtual bool isGuiBlocked() = 0;
   virtual Directory* getSelectedDir(const bool bShowWarning = true) = 0;
   virtual void showInfo(const QString&, const QString&) = 0;
   virtual void showWarning(const QString&, const QString&) = 0;
   virtual bool showYesNoQuestion(const QString&, const QString&) = 0;
   virtual bool showOkCancelQuestion(const QString&, const QString&) = 0;
   virtual bool showVerifyDialog(const QString&, const QString&) = 0;
   virtual void checkInProgress(bool) = 0;
   
   void cvsCallFailed(int,CommandInterface*);
   void finishInteractiveCmd();
   bool moveProject(const QString&, const QString&, const QString&);
   bool renameProject(const QString&, const QString&);
   void expurgateProjectSettings();
   void fillCmdDebugStream(QTextStream&);
   
   // since this function removes the project tree, the
   // returned entry is the new allocated entry for the dir
   // with the same fullpath as the Dir argument
   Directory * rereadProjectOfDir( Directory * Dir ) ;
   bool removeDirTreeFromDisk(QString,bool);
   bool removeFilesInTreeFromDisk(QString,bool);
   void performRereadProject( QString,QString);
   Directory *  openTreeAt(const QString&,const QString&);
   Directory *  openTreeAndActivate(const QString&,QString);
   
   // InteractiveCmdThread-related stuff
   CvsBuffer*             m_pCvsBuffer;
   bool                   m_interactiveCmdThreadIsRunning;
   bool                   m_chainedCommand;
   InteractiveCmdThread  *m_pInteractiveCmdThread;
   Directory *            m_pLastCvsCallDir;
   
   bool             m_stopAction;
   QStringList      m_currentTagList;
   QString          m_tmpStartUpDir;
   QValueList<QString> m_DirsToKill;
   
   //DebugFile related stuff
   QString m_debugCvsCallString;

   //fetch tags stuff
   DirBase * m_pFetchTagDir;
   
 private slots:

   void handleMessage(MESSAGE);
   void cvsCommandFinished();
   void startInSingleDir();
   void slot_requestDirectorySuicide(const QVariant&);
   void slot_execDirectorySuicide();


};

//----------------------------------------------------------------------------

#endif   //CVSCONTROL_H

