/****************************************************************************
**
** Copyright (C) 2003-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

//----------------------------------------------------------------------------

#include <qfile.h>
#include <qtextstream.h>
#include <qdatetime.h>
#include <qregexp.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "LinCVSLog.h"

//----------------------------------------------------------------------------

CLinCVSLog::CLinCVSLog()
{
   m_logFileName  = tmpDir + "/";
   m_logFileName += LC_LOG_FILE;

  //add markers for new session
#ifdef QT_THREAD_SUPPORT
   if (getMutex()) {
#endif
      QFile logFile(m_logFileName);

      if (Debug::g_logLevel > 0) {
         if ( logFile.open(IO_ReadWrite | IO_Append) ) {
            QDateTime date = QDateTime::currentDateTime();

            QTextStream stream(&logFile);
            stream << "----------------------------------------------------------------------\r\n";
            stream << "CrossVC started at " << date.toString("dd-MM-yyyy hh:mm:ss") << "\r\n";
            stream << "----------------------------------------------------------------------\r\n\r\n";
            logFile.close();
         }
      }
#ifdef QT_THREAD_SUPPORT
      m_mutex.unlock();
   }
#endif
}

//----------------------------------------------------------------------------

CLinCVSLog::~CLinCVSLog()
{
  //add markers for closing session
#ifdef QT_THREAD_SUPPORT
   if (getMutex()) {
#endif
      QFile logFile(m_logFileName);

      if (Debug::g_logLevel > 0) {
         if ( logFile.open(IO_ReadWrite | IO_Append) ) {
            QDateTime date = QDateTime::currentDateTime();

            QTextStream stream(&logFile);
            stream << "----------------------------------------------------------------------\r\n";
            stream << "CrossVC terminated at " << date.toString("dd-MM-yyyy hh:mm:ss") << "\r\n";
            stream << "----------------------------------------------------------------------\r\n\r\n\r\n";
            logFile.close();
         }
      }
#ifdef QT_THREAD_SUPPORT
      m_mutex.unlock();
   }
#endif
}

//----------------------------------------------------------------------------

bool CLinCVSLog::log(Debug::LogLevel level, const QString msg)
{
   if ( (Debug::g_logLevel > 0) && (Debug::g_logLevel >= level) ) {
#ifdef QT_THREAD_SUPPORT
      if (getMutex()) {
#endif
         QFile logFile(m_logFileName);

         if ( logFile.open(IO_ReadWrite | IO_Append) ) {
            
            QString sLevel;
            switch(level) {
               case Debug::LL_THE_OLD_MAN_AND_THE_SEA:
               sLevel = "WARNING ";
               break;
               case Debug::LL_INFO:
               sLevel = "INFO ";
               break;
               case Debug::LL_DEBUG:
               sLevel = "DEBUG ";
               break;
               case Debug::LL_GOSSIP_MONGER:
               sLevel = "DEBUG ALL ";
               break;
               default:
               sLevel = "Should never appear";
            }
            
            QDateTime date = QDateTime::currentDateTime();
            QTextStream stream(&logFile);
            stream << sLevel << date.toString("dd-MM-yyyy hh:mm:ss") << ":\t"+msg+"\r\n";
            logFile.close();

#ifdef QT_THREAD_SUPPORT
	         m_mutex.unlock();
#endif
            return true;
         } else {
#ifdef QT_THREAD_SUPPORT
	         m_mutex.unlock();
#endif
	         return false;
         }
#ifdef QT_THREAD_SUPPORT
      } else return false;
#endif
   } else return true;
}

//----------------------------------------------------------------------------

#ifdef QT_THREAD_SUPPORT
bool CLinCVSLog::getMutex(int timeout /*= 500ms*/)
{
   if (m_mutex.tryLock()) return true;
   
   //could not obtain the mutex --> wait for timeout milli seconds
   wait(timeout);
   
   return m_mutex.tryLock();
}
#endif

//----------------------------------------------------------------------------

