/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __SWABYTES
#define __SWABYTES

   inline   Word16   __SwapWord16( Word16 w)
      {  return (w>>8) | (w<<8); }

   inline   Word32   __SwapWord32( Word32 ww)
      {  return   ( Word32(__SwapWord16( Word16(ww >> 16) ))  )  |
                  ( Word32(__SwapWord16( Word16(ww) )) << 16  );
      }

   #define __SWAP16(x) x=__SwapWord16((Word16)x)
   #define __SWAP32(x) x=__SwapWord32((Word32)x)

   inline void SwapWord16(Word16 & x)  { __SWAP16(x); }
   inline void SwapWord32(Word32 & x)  { __SWAP32(x); }
   inline void SwapInt16(Int16 & x)    { __SWAP16(x); }
   inline void SwapInt32(Int32 & x)    { __SWAP32(x); }
   inline void SwapRect16(Rect16 & x)
      { __SWAP16(x.left); __SWAP16(x.top); __SWAP16(x.right); __SWAP16(x.bottom); }
   inline void SwapRect32(Rect32 & x)
      { __SWAP32(x.left); __SWAP32(x.top); __SWAP32(x.right); __SWAP32(x.bottom); }
   inline void SwapPoint16(Point16 & x)  { __SWAP16(x.x); __SWAP16(x.y); }
   inline void SwapPoint32(Point32 & x)  { __SWAP32(x.x); __SWAP32(x.y); }

#endif
