/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "lnslang.h"

#include <stdio.h>
#include <stdlib.h>

/*#include <windows.h> // MB()*/

#ifdef __cplusplus
extern "C" {
#endif

void   __assertfail( char  *__msg,
                                   char  *__cond,
                                   char  *__file,
                                   int __line);

void   my_assert_fail(const char  *__cond, const char  *__file, int __line);


#ifdef  __cplusplus
}
#endif

#if defined( WIN32 )
   #define __ASM _asm
#else
   #define __ASM asm
#endif

void my_assert_fail(const char  *__cond, const char  *__file, int __line	){

#if defined( _Windows ) || defined( WIN32 )
	char mess[500];
	sprintf( mess,
        " %s file %s, line %d\n Continue (Yes),Breakpoint(No) or Cancel?",
				__cond, __file, __line);
   OutputDebugString(mess);

   return;

#else
	int c(0);
	printf( "\nAssertion failed: %s file %s, line %d\n", __cond, __file, __line );
	printf( "\nPress <Space> to continue execution, <Esc> to abort" );

	do {
		c = getchar();
	} while((c != 32) && (c != 27) && (c != EOF));
	if (c == 27)
		exit(0);
	printf("..OK");
#endif
}
