/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "layout.h"

#ifndef __SHEET__
#define __SHEET__


#define MAXSHEETS 10

#define MAXH 128
#define MAXV 128

typedef struct Line {int Ax,Ay,Bx,By;}  LINE;

struct strSheet {
 INT      Sh,Sv,angle,VerCount;
 INT	  *Ver;
 INT	  *Hor;
 INT	  *Tab;
 LINE     *VerLine;
 INT      ShiftX;
 INT      ShiftY;
                };
typedef struct strSheet SHT;

// ltsheet.c
int  GetUserNumSheet(SHT * sht,int x,int y);
int  GetWidthSheet(SHT * sht,int x,int y);
int  GetNumFragmentColumn(SHT * sht,int num);
BOOL ExtractSheets(INT NumSht,SHT ** sht);
BOOL DeleteSheet(INT);
BOOL ExistSheets(void);
BOOL GetSheetIncline(INT * angle);
BOOL ItsSheetBlock(BLOCK * p);
BOOL OutsideSheet(int * xLeft,int * yTop,int * xRight,int * yBottom);

int  GetHeightItemSheet	(SHT *,int,int);
int  GetWidthItemSheet 	(SHT *,int,int);
int  GetUserNumSheet   	(SHT *,int,int);
BOOL ItsNewItem		(SHT *,int,int);


void backup_sheets   (int * nSheets, SHT ** sht);
void free_undo_sheets(int nSheets,SHT * sht);
void undo_sheets     (int nSheets,SHT * sht);

// gmsheet.c
BOOL ExtractSheetFragments(void);



#endif
