#!/bin/bash
#
# dm-backup-log.sh
#
#    Backup log file.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"

# create backup for log files
for F in "1box-server.log" "usbinput.log" "userful-start.log"; do
	# make backup
	mv --backup=numbered /var/log/$F /var/log/$F.old

	# delete backup files older than 30 days
	find /var/log/ -name "$F.old*" -mtime +30 -exec rm -f \{\} \;
done

date >> $logfile
echo >> $logfile
