#!/bin/bash
#
# dm-config-mx.sh
#
#    Create config file for X. (userful.Mxorg.conf)
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"

PATH=$PATH:/usr/X11R6/bin/

CPUTYPE=
CARDNAME=
DUALVIEW=0

TOUCHSCREEN=5
DEVTYPE=
VENDORID=
PRODUCTID=
NUM_OF_TOUCH=0
NO_NVIDIA_DRIVER=0

ELOTOUCH=04E7
MITOUCH=0596

OSNAME=
OSVER=
# it is used to be userful.xorg.conf.all
X_CONFIG_FILE="userful.xorg.conf.one"

# find available lspci command.
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi
BUSID_LEN=`$LSPCI -n | grep -m 1 "0300: " | cut -d ' ' -f 1 | wc -m`


###
# Check number of DualView capable cards
###
check_dualview()
{
	$LSPCI -n | grep "0300: " > /tmp/videolist.tmp

	while read VIDEOENTRY; do
		if echo $VIDEOENTRY | tr "[A-Z]" "[a-z]" | grep class > /dev/null 2>&1 ; then
			DEVID=`echo $VIDEOENTRY | awk -- '{print $4}'`
		else
			DEVID=`echo $VIDEOENTRY | awk -- '{print $3}'`
		fi

		if grep "$DEVID" /opt/userful/bin/VGAINFO > /dev/null ; then
			CARDTYPE=`grep "$DEVID" /opt/userful/bin/VGAINFO | awk -- '{print $3}'`
			if [ "$CARDTYPE" == "D" ]; then
				DUALVIEW=$(( $DUALVIEW + 1 ))
			fi
		fi
	done < /tmp/videolist.tmp
}


###
# check if current system is Laptop computer
###
check_laptop()
{
	TMPSTR=`$LSPCI -n | grep -c "0300: "`
	if [ "$TMPSTR" == "1" ]; then  # laptop has only one graphic card entity
		TMPSTR=`$LSPCI -n | grep "0300: "`

		if echo $TMPSTR | tr "[A-Z]" "[a-z]" | grep class > /dev/null 2>&1 ; then
			# has "Class" string in the lspci -n
        	VENDORID=`echo $TMPSTR | awk '{split($4,a,":"); print a[1]}'`
        	VIDEOID=`echo $TMPSTR | awk '{split($4,a,":"); print a[2]}'`
		else
			# doesn't has "Class" string in the lspci -n
        	VENDORID=`echo $TMPSTR | awk '{split($3,a,":"); print a[1]}'`
        	VIDEOID=`echo $TMPSTR | awk '{split($3,a,":"); print a[2]}'`
		fi

		CARDNAME=`grep "0x"$VENDORID /etc/userful/pcitable |
				   grep "0x"$VIDEOID |
				   awk -- '{if(substr($3,2,4) == "Card") {split($0,a,"\""); print a[2]}}' |
				   awk -- '{split($0,b,":"); print b[2]}'`

		if echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " mobility" > /dev/null 2>&1 || \
		   echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " igp" > /dev/null 2>&1 || \
		   echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " go" > /dev/null 2>&1 ; then
		   CPUTYPE=`grep -m 1 "model name" /proc/cpuinfo |
				    awk -- '{split($0,a,":"); print a[2]}'`
	   fi
	fi
}

###
# check if there is touchscreen device in the system
# It assumes that any device that has ELOTOUCH and MITOUCH for the Vendor ID 
# is a Touch screen device
###
function check_touchscreen()
{
	rm -f /tmp/touchscreen-dev
	TOUCH_CNT=0

	while read USBINPUT; do
		if [ "${USBINPUT:0:1}" == "I" ]; then # Interface
			if  echo $USBINPUT | tr "a-z" "A-Z" | grep "VENDOR=$ELOTOUCH" > /dev/null 2>&1 || \
				echo $USBINPUT | tr "a-z" "A-Z" | grep "VENDOR=$MITOUCH" > /dev/null 2>&1; then
				# found Elo touch or Mi touch device
				NUM_OF_TOUCH=$(( $NUM_OF_TOUCH + 1 ))
				TOUCH_CNT=1
			fi
		elif [ "${USBINPUT:0:1}" == "N" -a $TOUCH_CNT -eq 1 ]; then # Name
			if echo $USBINPUT | tr "a-z" "A-Z" | grep "NAME=" > /dev/null 2>&1 ; then
				echo $USBINPUT | awk -F'=' -- '{print $2}' | tr -d "\"" >> /tmp/touchscreen-dev
				TOUCH_CNT=0
			fi
		fi
	done < /proc/bus/input/devices

	while read USBDEV; do
		if ! echo $USBDEV | grep "^[[:space:]]*#" > /dev/null 2>&1 && \
			[ ${#USBDEV} -ne 0 ]; then
			VENDORID=`echo $USBDEV | awk -- '{print $1}'`
			PRODUCTID=`echo $USBDEV | awk -- '{print $2}'`
			DEVTYPE=`echo $USBDEV | awk -- '{print $3}'`

			if [ $DEVTYPE -eq $TOUCHSCREEN ] &&
				[ "$VENDORID" != "$ELOTOUCH" -a "$VENDORID" != "$MITOUCH" ]; then

				# number of current touchscreen device
				CNT=`grep -i "Vendor=$VENDORID Product=$PRODUCTID" /proc/bus/input/devices | wc -l`

				if [ $CNT -gt 0 ]; then
					# get the name of current touchscreen
					grep -i -A 1 "Vendor=$VENDORID Product=$PRODUCTID" /proc/bus/input/devices | \
							grep "N:" | awk -F'"' -- '{print $2}' >> /tmp/touchscreen-dev

					NUM_OF_TOUCH=$(( $NUM_OF_TOUCH + $CNT ))
				fi

			fi
		fi
	done < /opt/userful/bin/USBINPUTTABLE

	cat /tmp/touchscreen-dev >>  $logfile
}

function check_nvidia_driver()
{
	if $LSPCI -n | tr "a-z" "A-Z" | grep "0300:[[:space:]]10DE:" > /dev/null 2>&1 ; then
		# nVidia card exist
		if [ -e /usr/lib/xorg/modules/drivers/nvidia_drv.o -o \
			-e /usr/lib64/xorg/modules/drivers/nvidia_drv.o -o \
			-e /usr/X11R6/lib64/modules/drivers/nvidia_drv.o -o \
		 	-e /usr/X11R6/lib/modules/drivers/nvidia_drv.o ]; then
			 # Load the nVidia kerenl module
			 modprobe -q nvidia
			 NO_NVIDIA_DRIVER=0
		else
			echo "(WW) nvidia driver is not available" >>  $logfile
			NO_NVIDIA_DRIVER=1
		fi

	fi
}

###
# configure DM. create /etc/X11/userful.Mxorg.conf
###
configure_mx()
{
	if [ -x /usr/X11R6/bin/XFree86 ]; then
		XSERVER="/usr/X11R6/bin/XFree86"
	elif [ -x /usr/X11R6/bin/Xorg ]; then
		XSERVER="/usr/X11R6/bin/Xorg"
	elif [ -x /usr/bin/Xorg ]; then # For X 7.0
		XSERVER="/usr/bin/Xorg"
	else
		chvt 2
		echo "(EE) Can't find X server" >> $logfile
		exit 1
	fi
	
	# configure mga driver
	/opt/userful/bin/dm-config-mga-driver.sh single

	# initialize
	rm -f /etc/dm-sys-info
	rm -f /tmp/ret-config-message

	# check if nVidia cards and nvidia_drv.o exist
	check_nvidia_driver

	# create xorg.conf.new
	$XSERVER -configure
	if [ ! -f /root/xorg.conf.new ]; then
		if [ -f /xorg.conf.new ]; then
			cp -f /xorg.conf.new /root/
		else
			echo "(EE) /root/xorg.conf.new is not available." >> $logfile
		fi
	fi

	# create userful.xorg.conf.all and userful.xorg.conf.one for configuration screen
	if [ -f /root/xorg.conf.new ]; then
		/opt/userful/bin/dm-gen-xconfig.sh -one
		/opt/userful/bin/dm-gen-xconfig.sh -all
	else
		/opt/userful/bin/mx-config-gen.sh -all
		/opt/userful/bin/mx-config-gen.sh -one
	fi

	# create /tmp/sysinfo.tmp for the CPU and VGA information
	/opt/userful/bin/dm-create-sysinfo.sh

	# check if current system is Laptop computer
	check_laptop

	# check if there is TouchScreen device in the system
	# TouchScreen doesn't support DualView
	check_touchscreen
	#echo "Number of touchscreen: $NUM_OF_TOUCH"
	
	# check reseller's logo
	rm -f /opt/userful/images/reseller-logo.jpg
	/opt/userful/bin/sno-comp
	source /etc/userful/userful-license-info
	if [ "$RESELLER_LOGO" != "" -a -e /opt/userful/images/reseller/$RESELLER_LOGO.jpg ]; then
		echo "(II) use reseller log: $RESELLER_LOGO.jpg" >>  $logfile
		cp -f /opt/userful/images/reseller/$RESELLER_LOGO.jpg /opt/userful/images/reseller-logo.jpg
	fi

	# Set the X_CONFIG_FILE to userful.xorg.conf.one for some distros that use Xorg 6.9/7.0.
	# New X (Xorg 6.9/7.0) has problem with multiple graphic cards.
	source /etc/userful/os-info
	if [ ! -z $OSNAME -a ! -z $OSVER ]; then
		if [ "$OSNAME" == "novell" -a "$OSVER" == "10" ] || 
			[ "$OSNAME" == "ubuntu" -a "$OSVER" == "6.06" ]; then # Novell 10, Ubuntu 6.06
			X_CONFIG_FILE="userful.xorg.conf.one"
		fi
	fi

	# We need to set environment variables for language translation.
	# This could be different for each distro.

	# FC4
	[ -f /etc/profile.d/lang.sh ] && . /etc/profile.d/lang.sh
	echo "LANG=$LANG" >> $logfile

	# check if config-message program starts properly.
	# Multiple Colorgraphics savage cards causes normal X hung.
	/opt/userful/bin/watch-x-config.sh &

	if [ ! -z "$CARDNAME" -a ! -z "$CPUTYPE" ]; then # In case of Laptop 
		if [ $NUM_OF_TOUCH -gt 0 ]; then
			if [ $NO_NVIDIA_DRIVER -eq 1 ]; then
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" -nonvidia \
					-touchscreen $NUM_OF_TOUCH -- $XSERVER -xf86config $X_CONFIG_FILE
			else
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" \
					-touchscreen $NUM_OF_TOUCH -- $XSERVER -xf86config $X_CONFIG_FILE
			fi
		else
			if [ $NO_NVIDIA_DRIVER -eq 1 ]; then
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" -nonvidia \
					-- $XSERVER -xf86config $X_CONFIG_FILE
			else
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" \
					-- $XSERVER -xf86config $X_CONFIG_FILE
			fi
		fi
	elif [ $NUM_OF_TOUCH -gt 0 ]; then # Normal Desktop with touchscreen
		if [ $NO_NVIDIA_DRIVER -eq 1 ]; then
			xinit /opt/userful/bin/config-message $1 -touchscreen $NUM_OF_TOUCH -nonvidia \
				-- $XSERVER -xf86config $X_CONFIG_FILE
		else
			xinit /opt/userful/bin/config-message $1 -touchscreen $NUM_OF_TOUCH \
				-- $XSERVER -xf86config $X_CONFIG_FILE
		fi
	else # Normal desktop 
		check_dualview
		if [ $NO_NVIDIA_DRIVER -eq 1 ]; then
			xinit /opt/userful/bin/config-message $1 -dualview $DUALVIEW -nonvidia \
				-- $XSERVER -xf86config $X_CONFIG_FILE
		else
			xinit /opt/userful/bin/config-message $1 -dualview $DUALVIEW \
				-- $XSERVER -xf86config $X_CONFIG_FILE
		fi
	fi

	RET=`cat /tmp/ret-config-message`
	if [ $RET -eq 1 ]; then
		# use old config file
		echo "(II) Use old configuration instead of creating new one." >>  $logfile
		$LSPCI -n | grep "0300: " > /etc/X11/vgainfo
		return 0
	elif [ $RET -ne 0 ]; then
		# exit from startup procedure
		echo "(EE) Failed to configure system." >>  $logfile
		chvt 2
		exit 1
	fi

	###
	# create userful.Mxorg.conf
	###
	rm -f /etc/stations
	rm -f /etc/X11/stations
	rm -f /etc/X11/userful.Mxorg.conf
	rm -f /etc/usbinput
	rm -f /etc/X11/xdm/Xservers
	rm -f /etc/mvgainfo
	rm -f /etc/mvgainfo.fail

	/opt/userful/bin/sno-comp
	$LSPCI -n | grep "0300: " > /etc/X11/vgainfo

	# create config files
	if [ -f /root/xorg.conf.new ]; then
		/opt/userful/bin/dm-gen-xconfig.sh -check
		/opt/userful/bin/dm-gen-xconfig.sh -1box
	else
		pushd /opt/userful/bin > /dev/null
			/opt/userful/bin/mx-config-gen.sh -check
			/opt/userful/bin/mx-config-gen.sh -1box
   		popd > /dev/null
	fi

	# Block this for a while
	# create config file for normal X if there isn't any.
	#if [ -x /usr/X11R6/bin/XFree86 ] && [ ! -e /etc/X11/XF86Config ]; then
	#	cp -f /etc/X11/userful.xorg.conf.one /etc/X11/XF86Config
	#
	#elif [ ! -e /etc/X11/xorg.conf ]; then
	#	cp -f /etc/X11/userful.xorg.conf.one /etc/X11/xorg.conf
	#fi

	# There are Touchscreen device. Need to calibrate
	if [ -e /tmp/touchscreen-dev ]; then
		echo "(II) Calibration procedure starts." >>  $logfile
		/opt/userful/evtouch/calibrate.sh
	fi

	# reboot system if Matrox Card exists
	#$LSPCI -n | grep "0300: " | tr "a-z" "A-Z" | grep 102B > /dev/null
	#if [ $? -eq 0 ]; then
	#	sync;sync;reboot;reboot
	#fi
}

#-----------------
# Start from here
#-----------------
###
# check if creating config file is needed.
###
if [ -e /etc/userful/DM-install -a ! -e /etc/X11/userful.Mxorg.conf ]; then
	# First install
	configure_mx -f

elif [ ! -e /etc/X11/vgainfo -o ! -e /etc/X11/userful.Mxorg.conf \
  -o ! -e /etc/stations -o ! -e /etc/X11/stations -o ! -e /etc/mvgainfo ]; then
	# There is no configuration file
	configure_mx -n

else
	$LSPCI -n | grep "0300: " > /etc/X11/vgainfo.new

	diff /etc/X11/vgainfo /etc/X11/vgainfo.new > /dev/null

	if [ $? != 0 ]; then
		# there are changes in the graphic cards
		cp -f /etc/X11/userful.Mxorg.conf /etc/X11/userful.Mxorg.conf.old
		configure_mx -r
	fi
	
	/opt/userful/bin/sno-comp
	if [ $? != 0 ]; then
		# there is change in the # of station of the key file
		# no need to re-create config file
		rm -f /etc/X11/xdm/Xservers
		rm -f /etc/stations
		/opt/userful/bin/sno-comp
	fi
fi
