#!/bin/bash
#
# dm-create-sysinfo.sh
#
#	 Create /tmp/sysinfo.tmp.  sysinfo.tmp used by config-message program
#	 to show the system information.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
logfile="/var/log/userful-start.log"


###
# Create /tmp/sysinfo.tmp file
###
rm /tmp/sysinfo.tmp

# set LSPCI
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi
BUSID_LEN=`$LSPCI -n | grep -m 1 "0300: " | cut -d ' ' -f 1 | wc -m`

# get CPU information
grep -m 1 "model name" /proc/cpuinfo | cut -d ':' -f 2 > /tmp/sysinfo.tmp

grep "model name" /proc/cpuinfo >>  $logfile

##
# get VGA information

# get BusID for each graphic cards
$LSPCI -n | grep "0300: " | cut -d ' ' -f 1 > /tmp/videolist.tmp
$LSPCI | grep "VGA"  >>  $logfile

while read VIDEOENTRY; do
	if [ $BUSID_LEN -lt 12 ]; then  # 00:00.0 type
		$LSPCI | grep $VIDEOENTRY | cut -d ':' -f 3 >> /tmp/sysinfo.tmp
	else 							# 0000:00:00.0 type
		$LSPCI | grep $VIDEOENTRY | cut -d ':' -f 4 >> /tmp/sysinfo.tmp
	fi
done < /tmp/videolist.tmp

rm -f /tmp/videolist.tmp
