#!/bin/bash

# Copyright (c) 2002-2006 Userful Corporation. All rights reserved.
# http://userful.com/

# comment this out for distribution
#DEBUG=1
PROGRESS_DLG_PID=-1

function print_usage () {
            echo "usage: $0 [OPTION]...
Submit debug info.

 -g        use graphical interface
 -d text   add a description
 -h        print this text
"
}

function failed() {
    if [ -d /proc/$PROGRESS_DLG_PID ] ; then
        $KILL_PROGRESS
    fi

    INFO=$*
    if [ -z "$INFO" ] ; then
        INFO=unknown
    fi
    if [ -x /usr/share/np-identify/identify.py ] ; then
        /usr/share/np-identify/identify.py --reboot-reason=568 --description="$INFO"
    fi
    exit 1
}

# next block taken from install-license.sh
ERR_DLG=/usr/share/1box-utils/error-dialog.py
if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=./error-dialog.py
fi 
if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=echo
fi

PROGRESS_DLG=./progress-dialog.py
if [ ! -x $PROGRESS_DLG ] ; then
    PROGRESS_DLG=/usr/share/1box-utils/progress-dialog.py
fi
if [ ! -x $PROGRESS_DLG ] ; then
    PROGRESS_DLG=$ERR_DLG
fi


GRAPHICAL=0
DETAILS_PROVIDED=0

# parse arguments:
while getopts "hgd:" flag ; do
    # echo "$flag" $OPTIND $OPTARG
    case "$flag" in
        h)
            print_usage
            exit 0
            ;;
        g)
            GRAPHICAL=1
            ;;
        d)
            DETAILS_PROVIDED=1
            DETAILS=$OPTARG
            ;;
        ?)
            print_usage
            exit 1
            ;;
    esac
done



TMP_SPACE=${TMPDIR:-/tmp}/submit-debug-info.sh.$$
trap "rm -rf $TMP 2>/dev/null" 0

ETH_NUM=0
MAC=`LANG=C /sbin/ifconfig -a eth$ETH_NUM | grep "HWaddr" | awk '{ print $5 }'`
if [ -z "$MAC" ] || [ ${#MAC} != 17 ] ; then 
    # MAC is no good
    MAC=unknown
fi

EDATE=`date +%s`

MAC_DASHES=${MAC//:/-}

DEST=$TMP_SPACE/$MAC_DASHES-$EDATE

mkdir -p $DEST

DATE=`date`
echo "DATE=\"$DATE\"" > $TMP_SPACE/details
UPTIME=`uptime`
echo "UPTIME=\"$UPTIME\"" >> $TMP_SPACE/details

if [ "$GRAPHICAL" == 1 ] ; then
    if [ -n "$DISPLAY" ] ; then
        [ -n "$DEBUG" ] && echo "Showing submission dialog..."
        if [ -x /usr/share/1box-utils/submission.py ] ; then
        # put this file in a retreiveable place, so that we can pre-fill the dialog if it faild
            /usr/share/1box-utils/submission.py -f /tmp/details || exit 1
            # /usr/share/1box-utils/submission.py -f /tmp/details || failed "Submission dialog failed"
        else
            if [ "$DETAILS_PROVIDED" == 0 ] ; then
                DETAILS="no deatils"
            fi
            echo "DETAILS=\"$DETAILS\"" > /tmp/details
        fi
    else
        GRAPHICAL=0
        if [ "$DETAILS_PROVIDED" == 0 ] ; then
            DETAILS="no deatils"
        fi
        echo "DETAILS=\"no display\"" > /tmp/details
    fi
fi

if [ "$GRAPHICAL" == 1 ] ; then
    $PROGRESS_DLG &
    PROGRESS_DLG_PID=$!
    KILL_PROGRESS="kill -SIGHUP $PROGRESS_DLG_PID"
fi

if [ -f /tmp/details ] ; then
    cat $TMP_SPACE/details /tmp/details > $DEST/details
else
    mv $TMP_SPACE/details $DEST/details
fi

# - /var/log/1box-server.log and old files
if [ -r /var/log/1box-server.log ] ; then
    mkdir $DEST/1box
    cp -ar /var/log/1box-server.log* $DEST/1box
fi

# - /var/log/userful-start.log and old files
if [ -r /var/log/userful-start.log ] ; then
    mkdir $DEST/userful-start
    cp -ar /var/log/userful-start.log* $DEST/userful-start
fi

# - /var/log/messages
if [ -r /var/log/messages ] ; then
    cp /var/log/messages $DEST
else
    echo "The messages file was not readable" > $DEST/messages
fi

if [ -x /sbin/lspci ] ; then
    /sbin/lspci &> $DEST/lspci
    /sbin/lspci -n &> $DEST/lspci-n
else
    echo "lspci not found" > $DEST/lspci
    echo "lspci not found" > $DEST/lspci-n
fi

if [ -r /var/log/usbinput.log ] ; then
    cp -ar /var/log/usbinput.log $DEST
else
    echo "The usbinput log was not readable" > $DEST/messages
fi

#- /proc/bus/input/devices
if [ -r /proc/bus/input/devices ] ; then
    cat /proc/bus/input/devices > $DEST/devices
else
    echo "Could not read /proc/bus/input/devices" > $DEST/devices
fi

#- /etc/usbinput
if [ -r /etc/usbinput ] ; then
    cp -ar /etc/usbinput $DEST
else
    echo "Could not read " > $DEST/usbinput
fi

#- /etc/X11/userful.Mxorg.conf
if [ -r /etc/X11/userful.Mxorg.conf ] ; then
    cp -ar /etc/X11/userful.Mxorg.conf $DEST
else
    echo "Could not read " > $DEST/userful.Mxorg.conf
fi

if [ -d /etc/userful ] ; then
    cp -ar /etc/userful $DEST
else
    mkdir -p $DEST/userful
    echo "No /etc/userful directory" > $DEST/userful/missing
fi

# In case there's discoverStation stuff too
if [ -d /var/log/userful ] ; then
    # there may be nothing there or we may not be able to read some files, we'll just try and get something
    cp -ar /var/log/userful $DEST/userful-logs &> /dev/null
fi
if [ -d /var/log/kiosk ] ; then
    cp -ar /var/log/kiosk $DEST &> /dev/null
fi

if [ -d /etc/X11 ] ; then
    ls -l /etc/X11 > $DEST/ll-etc-X11
else
    echo "Directory does not exist" > $DEST/ll-etc-X11
fi

if ls /etc/*-release &> /dev/null ; then
    cp -ar /etc/*-release $DEST
fi

# Tar and feather the files
cd $TMP_SPACE
TARGET=$MAC_DASHES-$EDATE.tar.gz
if tar zcf $TARGET $MAC_DASHES-$EDATE ; then
    if [ -w /var/log/userful/ ] || [ -w /var/log/userful/submit.log ] ; then
        echo "`date` Success" > /var/log/userful/submit.log
    fi
else
    failed "Could not tar files"
fi

# send it off
SERVER=np.userful.com
URL="http://$SERVER/upload-bug-report?form:mode=edit&form:id=upload_file_form&__confirmed_p=0&__refreshing_p=0&formbutton:ok=Save"

if [ -n "$DEBUG" ] ; then
    SERVER=np-dev.userful.ca
    URL="http://$SERVER/support/np/upload_file_test?form:mode=edit&form:id=upload_file_form&__confirmed_p=0&__refreshing_p=0&formbutton:ok=Save"
fi

if [ -x /usr/share/1box-utils/post-file.py ] ; then
    if /usr/share/1box-utils/post-file.py -u "$URL" -f $TARGET ; then
        if [ -d /proc/$PROGRESS_DLG_PID ] ; then
            $KILL_PROGRESS
        fi

        if [ "$GRAPHICAL" == 1 ] ; then
            exec $ERR_DLG type=sucess text="Successfully submitted information. Thank you."
        else
            echo "Successfully submitted information. Thank you."
        fi

        exit 0
    fi
else
    failed "python post script missing"
    exit 1
fi

if [ -d /proc/$PROGRESS_DLG_PID ] ; then
    $KILL_PROGRESS
fi

if [ "$GRAPHICAL" == 1 ] ; then
    exec $ERR_DLG type=error text="Failed to submit information. Check your Internet connection and try again."
else
    echo "$0: ERROR: Failed to send file."
    echo "Remnants are here: /tmp/$TARGET"
fi

mv $TMP_SPACE/$TARGET /tmp

failed "Python post script failed"

exit 127
