#!/bin/bash
#
# dm-check-os.sh
#
#    Check current OS name and version.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#####################################################
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

if [ -f $logfile ]; then
	chmod a+w $logfile
fi

# Check OS name and version
if [ -f /etc/fedora-release ]; then # Fedora Core
	if [ -e /etc/freedows-release ]; then # Freedows
		OSNAME=freedows
	else
		OSNAME=fedora
	fi
	OSVER=`rpm -qf --qf %{VERSION} /etc/fedora-release`

elif [ -f /etc/mandrake-release ]; then # Mandrake, Mandriva
	# need to update later.  MXsetup has problem to opn rpm dababase on post section
	OSNAME=mandrake
	OSVER=`rpm -qf --qf %{VERSION} /etc/mandrake-release`

elif [ -f /etc/SuSE-release ]; then
	if [ -e /etc/novell-release ]; then # Novell Desktop
		OSNAME=novell
	elif [ -e /etc/sun-release ]; then # Sun Java Desktop
		OSNAME=jds
	else # SuSE
		OSNAME=suse
	fi
	OSVER=`rpm -qf --qf %{VERSION} /etc/SuSE-release`

elif [ -f /etc/redhat-release ]; then # RHEL, CentOS
	OSNAME=`rpm -qf --qf %{NAME} /etc/redhat-release`
	OSNAME=${OSNAME%-release}
	OSVER=`rpm -qf --qf %{VERSION} /etc/redhat-release`

elif [ -f /etc/xandros-desktop-version ]; then # Xandros
	OSNAME=xandros
	OSVER=`grep "^Version" /etc/xandros-desktop-version | awk '{printf $5}'` 

elif [ -f /etc/morphix_version ]; then # Dreamlinux
	OSNAME=morphix
	OSVER=`cat /etc/morphix_version`

elif [ -f /etc/lsb-release ]; then  ## Ubuntu
    source /etc/lsb-release
    OSNAME=`echo $DISTRIB_ID | tr "[A-Z]" "[a-z]"`
    OSVER=$DISTRIB_RELEASE

elif [ -f /etc/freespire-version ]; then # Freespire
    OSNAME=freespire
	OSVER=`grep "^Version:" /etc/freespire-version | awk '{printf $2}'` 

elif [ -f /etc/linspire-version ]; then # Linspire
    OSNAME=linspire
	OSVER=0  

elif [ -f /etc/debian_version ]; then # Debian
    OSNAME=debian
	OSVER=`cat /etc/debian_version`

else
	dpkg -s simplymepis > /dev/null 2>1
	if [ $? == 0 ]; then # Mepis
		OSNAME=mepis
		OSVER=0  
	else
		OSNAME=unsupported
		OSVER=unsupported
	fi
fi

echo "OSNAME=$OSNAME" > /etc/userful/os-info
echo "OSVER=$OSVER" >> /etc/userful/os-info
echo "`date +"%b %d %T"` $ProgramName: OSNAME=$OSNAME, OSVER=$OSVER" >> $logfile
