#!/bin/bash
#
#   umx-gen-log.sh
#
#   This will generate log file for Userful Multiplier.
#
#   Copyright (c) 2002-2008 Userful Corporation. All rights reserved.
#   Jason Kim <jason@userful.com>
#
# Called from: submit-debug-info.sh

logfile="/tmp/umx.log"
ProgramName=`basename $0`

#
# append() - append the contents of the specified file to the log
#
append()
{
    echo "____________________________________________" >> $logfile
    echo ""                                             >> $logfile

    if [ ! -f "$1" ]; then
        echo "$1 does not exist"                        >> $logfile
    elif [ ! -r "$1" ]; then
        echo "$1 is not readable"                       >> $logfile
    else
        echo "$1"                                       >> $logfile
        echo ""                                         >> $logfile
        cat "$1"                                        >> $logfile
    fi
    echo ""                                             >> $logfile
}

#
# append_silent() - same as append(), but don't print anything if the
# file does not exist
#
append_silent()
{
    if [ -f "$1" -a -r "$1" ]; then
        echo "____________________________________________" >> $logfile
        echo ""                                             >> $logfile
        echo "$1"                                           >> $logfile
        cat "$1"                                            >> $logfile
        echo ""                                             >> $logfile
    fi
}

#
# append_command() - append the result of the specified command.
#
append_command()
{
    command=""
    command=`which $1 2> /dev/null | head -n 1`

    if [ $? -eq 0 -a "$command" != "" ]; then
        echo "____________________________________________" >> $logfile
        echo ""                                             >> $logfile
        echo "$*"                                           >> $logfile
        echo ""                                             >> $logfile
        ( $* >> $logfile ; exit 0 ) > /dev/null 2>&1
        echo ""                                             >> $logfile
    else
        echo "Skipping $command.. ($command not found)"     >> $logfile
        echo ""                                             >> $logfile
    fi
}

#
# Start of script
#

# check user
if [ `id -u` -ne 0 ]; then
    echo "ERROR: Please run $ProgramName as root."
    exit 1
fi

# Generate /etc/userful/userful-license-info
if [ -x /opt/userful/bin/dm-gen-info ]; then
    /opt/userful/bin/dm-gen-info -licenseinfo
fi

# remove any old log file
if [ -f $logfile ]; then
    rm -f $logfile
fi
touch $logfile 2> /dev/null

# Print prologue to the log file
echo "################################################" >> $logfile
echo "# Main Log file for Userful Multiplier    "       >> $logfile
echo "# Date: `date`"                                   >> $logfile
echo "# uname: `uname -a`"                              >> $logfile
echo "# uptime: `uptime`"                               >> $logfile
echo "################################################" >> $logfile

# Check Multimedia and Storage support
if [ ! -f /opt/userful/bin/multistation-audio-config.sh ]; then
    echo ""                                                 >> $logfile
    echo "Multistation audio support package is not found." >> $logfile
fi
if [ ! -f /opt/userful/bin/multistation-storage-config.sh ]; then
    echo ""                                                   >> $logfile
    echo "Multistation storage support package is not found." >> $logfile
fi

# Informational files
append_command ifconfig
append "/etc/userful/sys-id"
append "/etc/sysconfig/xtype"
append "/etc/userful/dm-release"
append "/etc/userful/os-info"
append "/etc/userful/userful-license-info"
append "/etc/stations"
append "/etc/X11/stations"
append "/etc/userful/dm.conf"

# Files from Proc
append "/proc/cpuinfo"
append "/proc/version"
append "/proc/meminfo"
append "/proc/bus/input/devices"
append "/proc/bus/usb/devices"
append "/proc/asound/cards"

append_command lspci
append_command lspci -n
append_command lspci -vv
append_command lsusb
append_command lsusb -v
append_command lsmod
append_command lshal
append_command ls -l /etc/X11/
append_command ls -l /etc/X11/Xinput
append_command ls /dev/input
append_command ls -l /dev/snd

append_command xset -q
