#!/bin/bash
#
# dm-start-mx.sh
#
#	 Start Multi X.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

PATH=$PATH:/usr/X11R6/bin/

MAX_X_START_TIME=120
MIN_X_START_TIME=10

MXVER=MX11R6

# find available lspci command.
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi

# Update userful.Mxorg.conf for input devices not required.
# For now, check TouchScreen and update config file.
update_mx_config()
{
	NUM_OF_HEADS=`cat /etc/X11/stations`

	if ! grep "tch" /etc/usbinput > /dev/null 2>&1 ; then
		# No touchscreen device in the /etc/usbinput.
		# Remove Touch from ServerLayout in the userful.Mxorg.conf
		for ((i = 0; i < $NUM_OF_HEADS; i++))
		do
			TEST=`grep "InputDevice" /etc/X11/userful.Mxorg.conf | grep "Touch$i"`

			if [ -n "$TEST" ]; then
				sed -i -e "/$TEST/d" /etc/X11/userful.Mxorg.conf
			fi
		done
	elif ! grep "InputDevice" /etc/X11/userful.Mxorg.conf | grep "Touch" > /dev/null 2>&1 ; then
		# Touchscreen exist in the /etc/usbinput, but no Touch entry in the ServerLayout section
		# Recreate userful.Mxorg.conf
		echo "(II) Touchscreen detected. Create userful.Mxorg.conf with touchscreen infomation" >>  $logfile
		if [ -f /root/xorg.conf.new ]; then
			/opt/userful/bin/dm-gen-xconfig.sh -1box
		else
			/opt/userful/bin/mx-config-gen.sh -1box
		fi
	fi
}

# Start Multi X
start_mx()
{
    # Message
    clear
    echo
    #echo -e "Starting \E[36m\033[1mUSERFUL\033[0m \033[1mDesktop Multiplier\033[0m. Please wait..."
    echo -e "Starting \E[36mUSERFUL\033[0m Desktop Multiplier. Please wait..."

    # Waiting for usbhub and input device initialization.
    if [[ -x /opt/userful/bin/waiting-for.sh ]]; then
        /opt/userful/bin/waiting-for.sh --hub -interval 3
        /opt/userful/bin/waiting-for.sh --input -interval 2
    fi

	source /etc/userful/MXVERSION

	# load nvidia module if nvidia driver exist
	if $LSPCI -n | grep "0300:" | tr "a-z" "A-Z" | grep "10DE" > /dev/null 2>&1 ; then
		if [ -e /usr/lib/xorg/modules/drivers/nvidia_drv.o -o \
			-e /usr/lib64/xorg/modules/drivers/nvidia_drv.o -o \
			-e /usr/X11R6/lib64/modules/drivers/nvidia_drv.o -o \
		 	-e /usr/X11R6/lib/modules/drivers/nvidia_drv.o ]; then
			modprobe -q nvidia
		fi
	fi

	#reset PS/2 device if needed
	/opt/userful/bin/checkPS2

	# create usbinput config file
	echo "`date +"%b %d %T"` $ProgramName: Create /etc/usbinput and symbolic link in /etc/X11/Xinput/ directory" >>  $logfile
	/opt/userful/bin/make-config-file 2>> $logfile

	# update userful.Mxorg.conf before X starts
	update_mx_config

    if [ -f /etc/userful/dm.conf ]; then
        sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
        source /tmp/dm.conf.tmp
    fi

	if which date > /dev/null 2>&1; then
		date +%s > /tmp/X-start
	else
		rm -f /tmp/X-start
	fi

    if [ "$MXVER" == "MX11R7" ]; then
        if grep "\"mga\"" /etc/X11/userful.Mxorg.conf > /dev/null 2>&1; then
            IGNOREABI="-ignoreABI"
        else
            IGNOREABI=""
        fi
    else
        IGNOREABI=""
    fi

	# start Multi X
	# disable TCP connection for now
    # TODO:
    #     Need to use -ingoreABI for the version mismatch of mga drvier.
	echo "`date +"%b %d %T"` $ProgramName: Start $MXVER with userful.Mxorg.conf. It may take some time." >>  $logfile
    if [ "$DMTYPE" == "remote" ]; then
        # Need to listen TCP connection, add -ac option to disable access control restriction
        xinit /opt/userful/bin/mx.xinitrc  -- /opt/$MXVER/bin/X :0 $IGNOREABI \
		    -ac -br -logfile /var/log/1box-server.log -config userful.Mxorg.conf &	
    else
        xinit /opt/userful/bin/mx.xinitrc  -- /opt/$MXVER/bin/X :0 $IGNOREABI \
		    -br -logfile /var/log/1box-server.log -nolisten tcp -config userful.Mxorg.conf &	
    fi

	sleep 1
}

# check if MX starts well within certain time
check_mx_start()
{
	if which date > /dev/null 2>&1; then
		START_TIME=`cat /tmp/X-start`
		TIME_TAKEN=0
	else
		sleep 10
	fi

	while [ -f /tmp/X-start ]; do
		NOW=`date +%s`
		TIME_TAKEN=$(( $NOW - $START_TIME ))
		if [ $TIME_TAKEN -gt $MIN_X_START_TIME ] ; then
			# check Multi-X still alive or not.
			pgrep X
			if [ "$?" != "0" ]; then # MXserver doesn't exist.
				echo "(EE) Multi-X has been crashed. See the /var/log/1box-server.log" >>  $logfile
				break
			fi
		fi

		# IF MX has been stuck somewhere, reboot system. -- problem in initialization..
		if [ $TIME_TAKEN -gt $MAX_X_START_TIME ] ; then
			pkill -9 X 2> /dev/null
			sleep 5
			echo "(EE) Starting Multi-X has been taken more than $MAX_X_START_TIME seconds. See the /var/log/1box-server.log" >>  $logfile
			break
		fi
		# wait 1 second for next checking
		sleep 1
	done
}

# Start MX and check if it starts well
start_1box_server()
{
	# start MX
	start_mx

	# check MX starting 
	check_mx_start

	###
	# /etc/userful/start-mx : specify the success of starting Multi-X
	###
	# 0: Starting Multi-X has been succeeded once before.
	# 1: Starting Multi-X has been failed, or this is first boot.
	# 2: Starting Multi-X has been failed more than two time in a row.
	if [ ! -e /etc/userful/start-mx ]; then
		START_MX=0
	else
		START_MX=`cat /etc/userful/start-mx`
	fi

	if [ -f /tmp/X-start ] || [ -f /tmp/mx-config-error ]; then
		# fails to start X or fails to create config file
		rm -f /tmp/X-start
		sleep 2
		clear
		
		START_MX=$(( $START_MX + 1 ))
		echo "(EE) Multi-X has failed to start $START_MX times in a row." >>  $logfile

		if [ $START_MX -eq 5 ]; then
			DETAILED_MSG="(EE) Failed to start Multi-X $START_MX times. Start text login."
			# submit debug info
			/usr/share/1box-utils/submit-debug-info.sh -d "$DETAILED_MSG"

			echo "(EE) Start text login." >>  $logfile
			echo 0 > /etc/userful/start-mx
			pkill prefdm_multi
			chvt 2
			exit 1

		elif [ $START_MX -eq 4 ]; then
			DETAILED_MSG="(EE) Failed to start Multi-X with single head configuration."
			echo "(II) Remove possible onboard video entry from the configuration." >>  $logfile

			sed -i -e "/^1:0:0.*/d" /etc/mvgainfo
			rm -f /etc/usbinput
			rm -f /etc/X11/xdm/Xservers

			if [ -f /root/xorg.conf.new ]; then
				/opt/userful/bin/dm-gen-xconfig.sh -1box
			else
   				pushd /opt/userful/bin > /dev/null
					/opt/userful/bin/mx-config-gen.sh -1box
   				popd /dev/null
			fi
			echo $START_MX > /etc/userful/start-mx

		elif [ $START_MX -eq 3 ]; then
			DETAILED_MSG="(EE) Failed to start Multi-X with normal configuration."
			echo "(II) Reconfigure userful.Mxorg.conf with single head configuration" >>  $logfile

			while read VIDEOCARD; do
				BUSID=`echo $VIDEOCARD | awk -F'^' '{print $1}'`
				VENDORNAME=`echo $VIDEOCARD | awk -F'^' '{print $2}'`
				BOARDNAME=`echo $VIDEOCARD | awk -F'^' '{print $3}'`
				DRIVER=`echo $VIDEOCARD | awk -F'^' '{print $4}'`
				DEVID=`echo $VIDEOCARD | awk -F'^' '{print $6}'`

				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^1^$DEVID" >> /etc/mvgainfo.new
			done < /etc/mvgainfo

			rm -f /etc/mvgainfo.fail
			mv -f /etc/mvgainfo /etc/mvgainfo.fail
			mv -f /etc/mvgainfo.new /etc/mvgainfo

			rm -f /etc/usbinput
			rm -f /etc/X11/xdm/Xservers

			if [ -f /root/xorg.conf.new ]; then
				/opt/userful/bin/dm-gen-xconfig.sh -1box
			else
   				pushd /opt/userful/bin > /dev/null
					/opt/userful/bin/mx-config-gen.sh -1box
   				popd /dev/null
			fi
			echo $START_MX > /etc/userful/start-mx

		else
			DETAILED_MSG="(EE) Failed to start Multi-X with normal configuration."
			echo $START_MX > /etc/userful/start-mx
		fi

		# submit debug info
		/usr/share/1box-utils/submit-debug-info.sh -d "$DETAILED_MSG"

		sync;sync;reboot;reboot
		exit 1

	else 
		echo "`date +"%b %d %T"` $ProgramName: Multi-X started." >>  $logfile
		# start MX successfully
		echo 0 > /etc/userful/start-mx

        # Update the current numbers of station, keyboard and mouse
	    /opt/userful/bin/make-config-file -u

        # Disable DPMS explicitly.  DPMS hasn't been virtualized yet..
        # Radeon driver seems to have some problems with DPMS.
        if which xset > /dev/null 2>&1; then
            echo "`date +"%b %d %T"` $ProgramName: xset -display :0 -dpms" >>  $logfile
            xset -display :0 -dpms
        fi
	fi
}

#--------------------
# Start from here..
#--------------------

# Check if MX is running already
if [ -e /var/run/x.pid ]; then
   	if [ -e /proc/`cat /var/run/x.pid` ]; then
		# MX is running
   		echo "" >> /var/log/usbinput.log
       	echo "(WW) Multi X is already running ..." >>  $logfile
		rm -f /tmp/mx-trial
		usleep 100000
   	else
		# Start MX and check if it starts well
		start_1box_server
   	fi
else
	# Start MX and check if it starts well
	start_1box_server
fi
