#!/bin/bash
#
# Copyright (c) 2005-2006 by Userful Corporation
#
# Name: userful-input-remove.sh
# Author: Jason Kim <jason@userful.com>
# Description:
#    This script is called from udev rule in 99-userful-hotplug.rules. It starts GUI for
#	kbd-assignment if a keyboard device has been removed. 
#
# $1: kernel name of the device (event#)
##################################################################################

logfile="/var/log/userful-start.log"
usbinput_logfile="/var/log/usbinput.log"
ProgramName=`basename $0`
LOCK_FILE="/tmp/usbinput.lock"

DEV_NAME=
DEV_NUM=
DEV_STR=

UNPLUG_DEVICE=
PROTOCOL=
SCREENNUM=

TRUE=1
FALSE=0

# Exit from this hotplug agent program if:
#  - X is not running.
#  - During X startup
if [[ ! -e /var/run/x.pid ]]; then
    exit 1
elif ! kill -0 `cat /var/run/x.pid` > /dev/null 2>&1; then
    exit 1
fi

# During the X start, don't run userful hotplug agent too.
if [[ -e /tmp/X-start ]]; then
    exit 1
fi

# start GUI for kbd-assignment. unconfigure devices that have same screenNum.
function unplug_kbd()
{
	##
	## /etc/usbinput should be accessed exclusively. 
	#if [ -f /tmp/usbinput.lock ]; then
	#	while [ -f /tmp/usbinput.lock ]; do
	#		usleep 150000
	#	done
	#fi
	## create lock file
	#touch /tmp/usbinput.lock
	while ! (set -C; : > $LOCK_FILE) 2> /dev/null; do
		usleep 150000
	done

	## delete temp file for usbinput
	rm -f /tmp/unplug.tmp.$SCREENNUM

	while read USBINPUT; do
		# find usbinput entries having same screen number
    	if echo "$USBINPUT" | grep "Srn#=$SCREENNUM" > /dev/null; then
			if [ ${USBINPUT:1:1} -eq 1 ]; then  # If the current device is configured
	    		USBINPUT=${USBINPUT/1/0}   # replace 1 to 0  (first match)
			fi
    	fi
    	echo "$USBINPUT" >> /tmp/unplug.tmp.$SCREENNUM
	done < /etc/usbinput
	cp -f /tmp/unplug.tmp.$SCREENNUM /etc/usbinput

	# update configstat
	/opt/userful/bin/make-config-file -u

	## delete lock file
	rm -f $LOCK_FILE

	# find current display manager
	if [ -f /etc/userful/currentdm ]; then
    	source /etc/userful/currentdm
	else
		CURRENTDM=gdm
	fi

    # This is bug fix for locale problem in Educational Linux
    if [[ -f /etc/default/locale ]]; then
        echo "`date +"%b %d %T"` [$ProgramName]: source locale" >> $logfile
        source /etc/default/locale 2>> $logfile
        while read line; do
            VARS_NAME=`echo $line | awk -F'=' '{print $1}'`
            export $VARS_NAME >> $logfile
        done < /etc/default/locale

        if [[ -f /etc/bash.bashrc ]]; then
            source /etc/bash.bashrc
        fi
        if [[ -f /etc/profile ]]; then
            source /etc/profile
        fi

        if [[ -f /root/.bashrc ]]; then
            source /root/.bashrc
        fi
        if [[ -f /root/.profile ]]; then
            source /root/.profile
        fi
    fi

	# check if GUI for kbd-assignment exists on the $SCREENNUM display
	if [ ! -e /var/run/pid.kbdlink$((10#$SCREENNUM)) -o \
		 ! -d /proc/`cat /var/run/pid.kbdlink$((10#$SCREENNUM))` ]; then
		#echo "userful-input-remove.sh  start GUI.." >> $logfile

		if [ "$CURRENTDM" == "kdm" -o "$CURRENTDM" == "xdm" ]; then
			/opt/userful/bin/checkGrabKeyboard -display :$((10#$SCREENNUM))
			RET=$?

			if [ $RET -eq $TRUE ]; then
				#echo "userful-input-remove.sh  kill login-server" >> $logfile
				kill `cat /var/run/pid.login-server$((10#$SCREENNUM))`
			else
				#echo "userful-input-remove.sh  start GUI" >> $logfile
				/opt/userful/bin/userful-usbinput-config -display :$((10#$SCREENNUM)) -r &
			fi
		else
			#echo "userful-input-remove.sh  start GUI" >> $logfile
			/opt/userful/bin/userful-usbinput-config -display :$((10#$SCREENNUM)) -r &
		fi
		usleep 500000
	else
		#echo "userful-input-remove.sh  GUI is exist already.." >> $logfile
		:
	fi
}

usage()
{
    echo
    echo "Usage: $0 <device name>"
    echo
    exit 1
}

#
# start here...
#
# $1: device name (event#)

# Exit if normal X is running.
if [ -f /etc/sysconfig/xtype ]; then
	source /etc/sysconfig/xtype

	if [ "$XTYPE" = SINGLE -o "$XTYPE" = single ]; then
		exit 1
	fi
fi

# Exit if USBConfigDaemon is not running.
if [ ! -e /var/run/pid.usbconfigdaemon -o ! -d /proc/`cat /var/run/pid.usbconfigdaemon` ]; then
	exit 1
fi

# receive only one argument - device name
if [ $# -ne 1 ]; then
    usage
fi

# Touch input-hotplug file
touch /tmp/input-hotplug

echo "`date +"%b %d %T"` $ProgramName:  $1 removed." >> $usbinput_logfile
echo "`date +"%b %d %T"` $ProgramName:  $1 removed." >> $logfile

# Check the device config type.  If it is static, then exit program.
if [[ -e /etc/userful/dm.conf ]]; then
    sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
    source /tmp/dm.conf.tmp
fi
if [ "$DEVCONF" == "static" ]; then
    echo "`date +"%b %d %T"` $ProgramName: Current device config type is static. Do nothing." >> $logfile
    exit 0
fi

DEV_NAME=$1 # event device
DEV_NUM=${DEV_NAME#event}  # event device number


# get the DEV#=XXX string for the usbinput file
if [ $DEV_NUM -lt 10 ]; then
	DEV_STR="Dev#=00$DEV_NUM"
elif [ $DEV_NUM -lt 100 ]; then
	DEV_STR="Dev#=0$DEV_NUM"
else
	DEV_STR="Dev#=$DEV_NUM"
fi

UNPLUG_DEVICE=`grep "$DEV_STR" /etc/usbinput`
if [ -z "$UNPLUG_DEVICE" ];then
    exit 1 # no entry in the usbinput file. may not a real input device
fi

# Get assinged screen# and device type
SCREENNUM=${UNPLUG_DEVICE:32:2}
PROTOCOL=${UNPLUG_DEVICE:40:2}

case "$PROTOCOL" in
	"01" ) 
		# In case of keyboard, need to show Press F-key program and unassign every other devices too.
		unplug_kbd
		;;
	"02"|"03"|"04" ) 
		# In case of secondary device, remain the current configuration info for future use.
		/opt/userful/bin/make-config-file -u
		;;
	"05" ) 
		# In case of Touch Screen, need to send signal to X, otherwise X keeps trying to open it.
	    # This is the problem in evtouch driver.	
		/opt/userful/bin/make-config-file -u
		/opt/userful/bin/send_signal
		;;
esac

# Removing many keyboards at the same time causes GUI crash
#killall -HUP userful-usbinput-config
pkill -USR2 kbd-daemon
pkill -USR2 mse-daemon
