#!/usr/bin/env python

# Copyright (c) 2002-2007 Userful Corporation. All rights reserved.
# http://www.userful.com/

# activation-dialog.py

# this is the dialog the appears when the user clicks "Register" in the
# about dialog.

import gtk 
import gtk.glade
import os
import sys
import getopt

import gettext
gettext.bindtextdomain('userful-about-dialog')
gettext.textdomain('userful-about-dialog')
_ = gettext.gettext

class PyGlade:
    glade_filename = 'activation-dialog.glade'
    paths = []
    paths.append('./')
    paths.append('/usr/share/1box-utils/')

    def __init__(self):
        glade_file = self.find_file(self.glade_filename)
        
        if os.access(glade_file, os.R_OK) == 1:
            self.gtk_glade_xml = gtk.glade.XML(glade_file)
        else:
            sys.exit(1)

        main_dialog = self.gtk_glade_xml.get_widget("activation_dialog")
        main_dialog.set_icon_from_file(self.find_file("multi-station-system-64.png"))

        widget = self.gtk_glade_xml.get_widget("activation_instructions_title_label")
        widget.set_markup(_("<b>Activate</b>"))

        widget = self.gtk_glade_xml.get_widget("activation_instructions_label")
        widget.set_text(_("If you already have an activation code, enter it along with the desired number of stations:"))

        widget = self.gtk_glade_xml.get_widget("error_label")
        widget.hide()

        widget = self.gtk_glade_xml.get_widget("register_instructions_title_label")
        widget.set_markup(_("<b>Get Activation Code or License Key</b>"))

        widget = self.gtk_glade_xml.get_widget("register_instructions_label")
        widget.set_text(_("If you don't have an activation code, you will need to purchase or obtain one through your reseller. Click the button below to connect with your reseller to obtain an activation code or license key."))

        widget = self.gtk_glade_xml.get_widget("install_local_license_title_label")
        widget.set_markup(_("<b>License File</b>"))

        widget = self.gtk_glade_xml.get_widget("install_local_license_label")
        widget.set_text(_("If you already have a license key either saved to your computer or to removable media, click the button below to browse to the license key or the zip file containing the license key."))

        num_stations = 10
        # read /etc/X11/stations (if it doesn't exist, find number of video heads)
        widget = self.gtk_glade_xml.get_widget("stations_spinbutton")
        stations_available = True
        try:
            stations_file = file("/etc/X11/stations", "rU")
        except IOError:
            stations_available = False
            
        if stations_available:
            station_number_read = stations_file.readline()
            station_number = station_number_read.strip()
            if station_number.isdigit():
                num_stations = int(station_number)
            else:
                widget.set_sensitive(False)

        widget.set_range(1, 64)
        widget.set_value(num_stations)

        # get a dictionary of all the class' methods
        signal_handlers = {}
        for key in dir(self.__class__):
            signal_handlers[key] = getattr(self, key)

        # this will connect all the signals defined in the glade file to functions
        # witth the same name, this will warn if signals are not handled 
        self.gtk_glade_xml.signal_autoconnect(signal_handlers)

        main_dialog.show()

    def set_error_text (self, text):
        widget = self.gtk_glade_xml.get_widget("error_label")

        if text == "":
            widget.hide()
            return
        else:
            widget.show()

        #widget.set_text(text)
        text_prefix = "<span foreground=\"red\" weight=\"bold\">"
        text_postfix = "</span>"
        if (len(text) > 256):
            # truncate text to 255 characters
            text = text[:255]
        text = text.replace("&", "&amp;")
        text = text.replace("<", "&lt;")
        text = text.replace(">", "&gt;")
        try:
            widget.set_markup(text_prefix + text + text_postfix)
        except:
            widget.set_markup(text_prefix + "server error" + text_postfix)
        return

    def set_key_text (self, text):
        widget = self.gtk_glade_xml.get_widget("activation_key_entry")
        widget.set_text(text)
        return

    def find_file (self, file_name):
        for path in self.paths:
            file_path = os.path.join(path, file_name)
            if os.path.isfile(file_path):
                break
        return file_path

    ################ CALLBACKS ################

    def on_activation_dialog_destroy(self, widget):
        if not widget:
            return
        gtk.main_quit()
        return 

    def on_launch_browser_button_clicked(self, widget):
        os.system(self.find_file("register.sh") + " &")
        # Ryan wants to leave the window open
        #gtk.main_quit()
        return 
    def on_activate_button_clicked(self, widget):
        if not widget:
            return

        widget = self.gtk_glade_xml.get_widget("activation_key_entry")
        activation_key = widget.get_text()

        widget = self.gtk_glade_xml.get_widget("stations_spinbutton")
        num_stations = widget.get_value_as_int()

        os.system(self.find_file("install-license.sh") + " -a \"" + str(activation_key) + "\" -s " + str(num_stations) + " &")
        gtk.main_quit()
        return 
    def on_activation_key_entry_editing_done(self, widget):
        self.on_activate_button_clicked(self, widget)
        return

    def on_install_local_license_button_clicked(self, widget):
        
        file_chooser = self.gtk_glade_xml.get_widget("filechooserbutton")
        file_path = file_chooser.get_filename()
        if file_path is not None:
            print "file is: " + file_path
        os.system(self.find_file("install-license.sh") + " -l \"" + str(file_path) + "\" &")
        gtk.main_quit()
        return

    def on_help_button_clicked(self, widget):
        os.system(self.find_file("launch-preferred-browser.sh") + " \"" + _("http://support.userful.com/wiki/index.php/How_To/Get_a_Desktop_Multiplier_License_Key") + "\" &")
        return
    def on_cancel_button_clicked(self, widget):
        gtk.main_quit()
        return

def main():
    PyGlade_ins = PyGlade()


    try:
        optlist, args = getopt.getopt(sys.argv[1:], "a:t:", ["activationkey=", "instructiontext="])
    except getopt.GetoptError:
        # print help information and exit:
        self.usage("Error in parsing arguments")
        sys.exit(2)

    file_name = "/dev/stdout"

    instruction_text = ""

    for o, a in optlist:
        if o in ("-a", "--activationkey"):
            PyGlade_ins.set_key_text(a)
        if o in ("-t", "--instructiontext"):
            instruction_text = a

    PyGlade_ins.set_error_text(instruction_text)

    gtk.main()

if __name__ == "__main__":
    main()

