/*
Copyright (C) 2000  Steffen Zschaler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * SpecifyTypeTraceSourceDialog.java
 *
 * Created on October 13, 2000, 7:43 PM
 */
 
package tudresden.ocl.injection.reverseeng;

import java.io.File;

import java.util.*;

import javax.swing.*;
import javax.swing.filechooser.*;

/** 
 *
 * @author  sz9
 */
public class SpecifyTypeTraceSourceDialog extends javax.swing.JDialog {

  class TTListModel extends AbstractListModel {
    private List m_lttiFileList;
    
    public TTListModel (List lttiFileList) {
      super();
      
      m_lttiFileList = lttiFileList;
    }
    
    public int getSize() {
      return m_lttiFileList.size();
    }

    public Object getElementAt (int nIdx) {
      return m_lttiFileList.get (nIdx);
    }
    
    public void add (TypeTraceInfo tti) {
      m_lttiFileList.add (tti);
      
      fireIntervalAdded (this, m_lttiFileList.size() - 1, m_lttiFileList.size() - 1);
    }
    
    public void remove (TypeTraceInfo tti) {
      int nIdx = m_lttiFileList.indexOf (tti);
      
      if (nIdx > -1) {
        m_lttiFileList.remove (nIdx);
        
        fireIntervalRemoved (this, nIdx, nIdx);
      }
    }
  }
  
  private TTListModel m_ttlmFileList;
  
  class TTIListCellRenderer extends DefaultListCellRenderer {
    public java.awt.Component getListCellRendererComponent (JList list, 
                                                                 Object value,
                                                                 int index, 
                                                                 boolean isSelected, 
                                                                 boolean cellHasFocus) {
      super.getListCellRendererComponent (list, value, index, isSelected, cellHasFocus);
      
      setText (((TypeTraceInfo) value).getName());
      
      return this;
    }
  }
  
  /** Creates new form SpecifyTypeTraceSourceDialog */
  public SpecifyTypeTraceSourceDialog (java.awt.Frame parent, 
                                            boolean modal,
                                            List lttiFileList) {
    super (parent, modal);

    init (lttiFileList);
  }

  /** Creates new form SpecifyTypeTraceSourceDialog */
  public SpecifyTypeTraceSourceDialog (JDialog parent, 
                                            boolean modal,
                                            List lttiFileList) {
    super (parent, modal);

    init (lttiFileList);
  }

  private void init (List lttiFileList) {
    m_ttlmFileList = new TTListModel (lttiFileList);
    
    initComponents ();
    pack ();
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    m_jspFiles = new javax.swing.JScrollPane ();
    m_jlFiles = new javax.swing.JList ();
    m_jpPad1 = new javax.swing.JPanel ();
    m_jbAddFile = new javax.swing.JButton ();
    m_jbRemoveFile = new javax.swing.JButton ();
    m_jpPad2 = new javax.swing.JPanel ();
    m_jpOKPanel = new javax.swing.JPanel ();
    m_jbClose = new javax.swing.JButton ();
    getContentPane ().setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );


      m_jlFiles.setModel (m_ttlmFileList);
      m_jlFiles.setCellRenderer (new TTIListCellRenderer());
  
      m_jspFiles.setViewportView (m_jlFiles);
  

    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 4;
    gridBagConstraints1.gridheight = 4;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
    gridBagConstraints1.weightx = 4.0;
    gridBagConstraints1.weighty = 5.0;
    getContentPane ().add (m_jspFiles, gridBagConstraints1);



    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHEAST;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    getContentPane ().add (m_jpPad1, gridBagConstraints1);

    m_jbAddFile.setText ("Add File...");
    m_jbAddFile.addActionListener (new java.awt.event.ActionListener () {
      public void actionPerformed (java.awt.event.ActionEvent evt) {
        onAddFileBtn (evt);
      }
    }
    );


    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTH;
    gridBagConstraints1.weightx = 1.0;
    getContentPane ().add (m_jbAddFile, gridBagConstraints1);

    m_jbRemoveFile.setText ("Remove File");
    m_jbRemoveFile.addActionListener (new java.awt.event.ActionListener () {
      public void actionPerformed (java.awt.event.ActionEvent evt) {
        onRemoveFileBtn (evt);
      }
    }
    );


    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTH;
    gridBagConstraints1.weightx = 1.0;
    getContentPane ().add (m_jbRemoveFile, gridBagConstraints1);



    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.SOUTHEAST;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    getContentPane ().add (m_jpPad2, gridBagConstraints1);


      m_jbClose.setText ("Close");
      m_jbClose.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          onCloseBtn (evt);
        }
      }
      );
  
      m_jpOKPanel.add (m_jbClose);
  

    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.gridheight = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.weightx = 5.0;
    getContentPane ().add (m_jpOKPanel, gridBagConstraints1);

  }//GEN-END:initComponents

  private void onRemoveFileBtn (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onRemoveFileBtn
    m_ttlmFileList.remove ((TypeTraceInfo) m_jlFiles.getSelectedValue());
  }//GEN-LAST:event_onRemoveFileBtn

  private void onAddFileBtn (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onAddFileBtn
    JFileChooser jfc = new JFileChooser();
    
    FileFilter ffOCLTypeTrace = new FileFilter() {
      public boolean accept (File f) {
        return (f.isDirectory()) ||
                (f.getName().indexOf (".ocltypetrace") > -1);
      }
      
      public String getDescription() {
        return "Runtime Type Trace Log Files";
      }
    };
    
    jfc.addChoosableFileFilter (ffOCLTypeTrace);
    jfc.setFileFilter (ffOCLTypeTrace);
    
    jfc.setDialogTitle ("Select Runtime Type Trace Log");
    
    if (jfc.showDialog (this, "Select") == JFileChooser.APPROVE_OPTION) {
      // Actually add file to list
      m_ttlmFileList.add (new TypeTraceInfo (jfc.getSelectedFile()));
    }
    
  }//GEN-LAST:event_onAddFileBtn

  private void onCloseBtn (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onCloseBtn
    closeDialog (null);
  }//GEN-LAST:event_onCloseBtn

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new SpecifyTypeTraceSourceDialog (new javax.swing.JFrame (), true, new LinkedList()).show ();
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JScrollPane m_jspFiles;
  private javax.swing.JList m_jlFiles;
  private javax.swing.JPanel m_jpPad1;
  private javax.swing.JButton m_jbAddFile;
  private javax.swing.JButton m_jbRemoveFile;
  private javax.swing.JPanel m_jpPad2;
  private javax.swing.JPanel m_jpOKPanel;
  private javax.swing.JButton m_jbClose;
  // End of variables declaration//GEN-END:variables

}