/////////////////////////////////////////////////////////////////////////////
// Name:        BurnDlg.h
// Purpose:     Burn dialog
// Author:      Alex Thuering
// Created:	23.03.2003
// RCS-ID:      $Id: BurnDlg.h,v 1.11 2008/12/31 16:04:02 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include <wx/wx.h>
#include <wx/image.h>

#ifndef BURNDLG_H
#define BURNDLG_H

// begin wxGlade: dependencies
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade

class BurnDlg: public wxDialog
{
  public:
    // begin wxGlade: BurnDlg::ids
    // end wxGlade
    BurnDlg(wxWindow* parent);
    wxString GetTempDir() { return m_tempDirText->GetValue(); }
	bool DoPreview() { return m_previewCheck->GetValue(); }
	bool DoGenerate() { return m_generateRadioBt->GetValue(); }
	bool DoCreateIso() { return m_isoRadioBt->GetValue(); }
	wxString GetIsoFile() { return m_isoText->GetValue(); }
	bool DoAddECC() { return m_addECCCheck->GetValue(); }
	bool DoBurn() { return m_burnRadioBt->GetValue(); }
	bool DoFormat() { return m_formatCheck->GetValue(); }
	wxString GetDevice();
	int GetSpeed();

  private:
    // begin wxGlade: BurnDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade

  protected:
    // begin wxGlade: BurnDlg::attributes
    wxStaticText* m_tempDirLabel;
    wxTextCtrl* m_tempDirText;
    wxButton* m_tempDirBt;
    wxStaticText* m_spaceLabel;
    wxCheckBox* m_previewCheck;
    wxRadioButton* m_generateRadioBt;
    wxRadioButton* m_isoRadioBt;
    wxStaticText* m_isoLabel;
    wxTextCtrl* m_isoText;
    wxButton* m_isoBt;
    wxRadioButton* m_burnRadioBt;
    wxCheckBox* m_formatCheck;
    wxStaticText* m_deviceLabel;
    wxComboBox* m_deviceChoice;
    wxStaticText* m_speedLabel;
    wxComboBox* m_speedChoice;
    wxPanel* m_devPanel;
    wxCheckBox* m_addECCCheck;
    wxPanel* m_spacer;
    wxButton* m_startBt;
    wxButton* m_cancelBt;
    wxButton* m_resetBt;
    // end wxGlade
	
	wxArrayString m_devices;
	void SetDevice(wxString device);
	void SetSpeed(int speed);
	void UpdateCtrls(bool def = false);
	void UpdateFreeSpace();
	virtual void OnTempDirChange(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnChooseTempDir(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnRadioBt(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnChooseIsoFile(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnOk(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnReset(wxCommandEvent &event); // wxGlade: <event_handler>
	
  private:
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class

#endif // BURNDLG_H
